/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedFrequencyBlockTrips;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;

@TransitTimeIndex
public class FrequencyBlockTripIndex
extends AbstractBlockTripIndex
implements HasIndexedFrequencyBlockTrips {
    private final List<FrequencyEntry> _frequencies;
    private final FrequencyServiceIntervalBlock _serviceIntervalBlock;

    public FrequencyBlockTripIndex(List<BlockTripEntry> trips, List<FrequencyEntry> frequencies, FrequencyServiceIntervalBlock serviceIntervalBlock) {
        super(trips);
        if (frequencies == null) {
            throw new IllegalArgumentException("frequencies is null");
        }
        if (frequencies.isEmpty()) {
            throw new IllegalArgumentException("frequencies is empty");
        }
        this._frequencies = frequencies;
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    public List<FrequencyEntry> getFrequencies() {
        return this._frequencies;
    }

    public FrequencyServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public String toString() {
        return "FrequencyBlockTripIndex [trips=" + this._trips + ", serviceIntervalBlock=" + this._serviceIntervalBlock + "]";
    }

    @Override
    public int getStartTimeForIndex(int index) {
        return this._frequencies.get(index).getStartTime();
    }

    @Override
    public int getEndTimeForIndex(int index) {
        return this._frequencies.get(index).getEndTime();
    }
}

