/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockTripIndex;
import org.onebusaway.transit_data_federation.services.blocks.ServiceIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;

@TransitTimeIndex
public class BlockTripIndex
extends AbstractBlockTripIndex {
    private final ServiceIntervalBlock _serviceIntervalBlock;

    public BlockTripIndex(List<BlockTripEntry> trips, ServiceIntervalBlock serviceIntervalBlock) {
        super(trips);
        this._serviceIntervalBlock = serviceIntervalBlock;
    }

    public ServiceIntervalBlock getServiceIntervalBlock() {
        return this._serviceIntervalBlock;
    }

    public String toString() {
        return "BlockTripIndex [blocks=" + this._trips + ", serviceIds=" + this.getServiceIds() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockTripIndex other = (BlockTripIndex)obj;
        if (this._trips.size() != other._trips.size() && !this._trips.containsAll(other._trips)) {
            return false;
        }
        for (int i = 0; i < this._trips.size(); ++i) {
            List<BlockStopTimeEntry> stopTimes = ((BlockTripEntry)this._trips.get(i)).getStopTimes();
            List<BlockStopTimeEntry> otherStopTimes = ((BlockTripEntry)other._trips.get(i)).getStopTimes();
            if (stopTimes.size() == otherStopTimes.size() || stopTimes.containsAll(otherStopTimes)) continue;
            return false;
        }
        return true;
    }
}

