/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.AbstractList;
import java.util.List;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.HasIndexedBlockStopTimes;
import org.onebusaway.transit_data_federation.services.blocks.TransitTimeIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;

@TransitTimeIndex
public class BlockStopSequenceIndex
implements HasIndexedBlockStopTimes {
    private final BlockSequenceIndex _index;
    private final int _offset;
    private final ServiceInterval _serviceInterval;
    private final List<BlockStopTimeEntry> _stopTimes = new ListImpl();

    public BlockStopSequenceIndex(BlockSequenceIndex index, int offset) {
        this._index = index;
        this._offset = offset;
        this._serviceInterval = this.computeServiceInterval(index, offset);
    }

    public BlockSequenceIndex getIndex() {
        return this._index;
    }

    public int getOffset() {
        return this._offset;
    }

    public ServiceIdActivation getServiceIds() {
        return this._index.getServiceIds();
    }

    public ServiceInterval getServiceInterval() {
        return this._serviceInterval;
    }

    public int size() {
        return this._index.size();
    }

    public BlockStopTimeEntry getBlockStopTimeForIndex(int index) {
        return this._stopTimes.get(index);
    }

    public BlockSequence getBlockSequenceForIndex(int index) {
        return this._index.getSequences().get(index);
    }

    @Override
    public List<BlockStopTimeEntry> getStopTimes() {
        return this._stopTimes;
    }

    @Override
    public int getArrivalTimeForIndex(int index) {
        List<BlockSequence> sequences = this._index.getSequences();
        BlockSequence sequence = sequences.get(index);
        return sequence.getArrivalTimeForIndex(this._offset);
    }

    @Override
    public int getDepartureTimeForIndex(int index) {
        List<BlockSequence> sequences = this._index.getSequences();
        BlockSequence sequence = sequences.get(index);
        return sequence.getDepartureTimeForIndex(this._offset);
    }

    public String toString() {
        List<BlockSequence> sequences = this._index.getSequences();
        BlockSequence sequence = sequences.get(0);
        List<BlockStopTimeEntry> stopTimes = sequence.getStopTimes();
        BlockStopTimeEntry bst = stopTimes.get(this._offset);
        return bst.toString();
    }

    private ServiceInterval computeServiceInterval(BlockSequenceIndex index, int stopIndex) {
        List<BlockSequence> sequences = this._index.getSequences();
        BlockStopTimeEntry fromBst = sequences.get(0).getStopTimes().get(stopIndex);
        BlockStopTimeEntry toBst = sequences.get(sequences.size() - 1).getStopTimes().get(stopIndex);
        StopTimeEntry fromSt = fromBst.getStopTime();
        StopTimeEntry toSt = toBst.getStopTime();
        return new ServiceInterval(fromSt.getArrivalTime(), fromSt.getDepartureTime(), toSt.getArrivalTime(), toSt.getDepartureTime());
    }

    private class ListImpl
    extends AbstractList<BlockStopTimeEntry> {
        private ListImpl() {
        }

        @Override
        public BlockStopTimeEntry get(int index) {
            List<BlockSequence> sequences = BlockStopSequenceIndex.this._index.getSequences();
            BlockSequence sequence = sequences.get(index);
            return sequence.getStopTimes().get(BlockStopSequenceIndex.this._offset);
        }

        @Override
        public int size() {
            return BlockStopSequenceIndex.this._index.size();
        }
    }
}

