/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.BlockLayoverIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripReference;
import org.onebusaway.transit_data_federation.services.blocks.LayoverIntervalBlock;
import org.onebusaway.transit_data_federation.services.blocks.ReferencesLibrary;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;

public class BlockLayoverIndexData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<BlockTripReference> _blockTripReferences;
    private final LayoverIntervalBlock _layoverIntervalBlock;

    public BlockLayoverIndexData(List<BlockTripReference> blockTripReferences, LayoverIntervalBlock layoverIntervalBlock) {
        this._blockTripReferences = blockTripReferences;
        this._layoverIntervalBlock = layoverIntervalBlock;
    }

    public List<BlockTripReference> getBlockTripReferences() {
        return this._blockTripReferences;
    }

    public LayoverIntervalBlock getLayoverIntervalBlock() {
        return this._layoverIntervalBlock;
    }

    public BlockLayoverIndex createIndex(TransitGraphDao dao) {
        ArrayList<BlockTripEntry> trips = new ArrayList<BlockTripEntry>();
        for (BlockTripReference blockTripReference : this._blockTripReferences) {
            BlockTripEntry trip = ReferencesLibrary.getReferenceAsTrip(blockTripReference, dao);
            trips.add(trip);
        }
        return new BlockLayoverIndex(trips, this._layoverIntervalBlock);
    }
}

