/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.io.Serializable;
import org.onebusaway.gtfs.model.AgencyAndId;

public class BlockConfigurationReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final AgencyAndId blockId;
    private final int configurationIndex;

    public BlockConfigurationReference(AgencyAndId blockId, int configurationIndex) {
        if (blockId == null) {
            throw new IllegalArgumentException();
        }
        this.blockId = blockId;
        this.configurationIndex = configurationIndex;
    }

    public AgencyAndId getBlockId() {
        return this.blockId;
    }

    public int getConfigurationIndex() {
        return this.configurationIndex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockId.hashCode();
        result = 31 * result + this.configurationIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockConfigurationReference other = (BlockConfigurationReference)obj;
        if (!this.blockId.equals((Object)other.blockId)) {
            return false;
        }
        return this.configurationIndex == other.configurationIndex;
    }

    public String toString() {
        return "blockId=" + this.blockId + " index=" + this.configurationIndex;
    }
}

