/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.services.blocks;

import java.util.List;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;

public abstract class AbstractBlockSequenceIndex {
    protected final List<BlockSequence> _sequences;
    protected final ServiceIdActivation _serviceIds;
    protected final boolean _privateService;

    public AbstractBlockSequenceIndex(List<BlockSequence> sequences, boolean privateService) {
        if (sequences == null) {
            throw new IllegalArgumentException("sequences is null");
        }
        if (sequences.isEmpty()) {
            throw new IllegalArgumentException("sequences is empty");
        }
        AbstractBlockSequenceIndex.checkSequencesHaveSameServiceids(sequences);
        this._sequences = sequences;
        this._serviceIds = this._sequences.get(0).getBlockConfig().getServiceIds();
        this._privateService = privateService;
    }

    public List<BlockSequence> getSequences() {
        return this._sequences;
    }

    public ServiceIdActivation getServiceIds() {
        return this._serviceIds;
    }

    public boolean isPrivateService() {
        return this._privateService;
    }

    public int size() {
        return this._sequences.size();
    }

    private static void checkSequencesHaveSameServiceids(List<BlockSequence> blocks) {
        ServiceIdActivation expected = blocks.get(0).getBlockConfig().getServiceIds();
        for (int i = 1; i < blocks.size(); ++i) {
            ServiceIdActivation actual = blocks.get(i).getBlockConfig().getServiceIds();
            if (expected.equals(actual)) continue;
            throw new IllegalArgumentException("serviceIds mismatch: expected=" + expected + " actual=" + actual);
        }
    }
}

