/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model.bundle;

import java.io.Serializable;
import org.onebusaway.gtfs.model.AgencyAndId;

public class HistoricalRidership
implements Serializable {
    private AgencyAndId tripId;
    private AgencyAndId routeId;
    private AgencyAndId stopId;
    private CalendarType calendarType;
    private double loadFactor;

    public static Builder builder() {
        return new Builder();
    }

    private HistoricalRidership(Builder builder) {
        this.tripId = builder.tripId;
        this.routeId = builder.routeId;
        this.stopId = builder.stopId;
        this.calendarType = builder.calendarType;
        this.loadFactor = builder.loadFactor;
    }

    public AgencyAndId getStopId() {
        return this.stopId;
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public AgencyAndId getRouteId() {
        return this.routeId;
    }

    public AgencyAndId getTripId() {
        return this.tripId;
    }

    public CalendarType getCalendarType() {
        return this.calendarType;
    }

    public static class Builder {
        private AgencyAndId tripId;
        private AgencyAndId routeId;
        private AgencyAndId stopId;
        private CalendarType calendarType = CalendarType.WEEKDAY;
        private double loadFactor;

        public HistoricalRidership create() {
            return new HistoricalRidership(this);
        }

        public void setTripId(AgencyAndId tripId) {
            this.tripId = tripId;
        }

        public void setRouteId(AgencyAndId routeId) {
            this.routeId = routeId;
        }

        public void setStopId(AgencyAndId stopId) {
            this.stopId = stopId;
        }

        public void setCalendarType(CalendarType calendarType) {
            this.calendarType = calendarType;
        }

        public void setLoadFactor(double loadFactor) {
            this.loadFactor = loadFactor;
        }
    }

    public static enum CalendarType {
        WEEKDAY,
        SATURDAY,
        SUNDAY;

    }
}

