/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.model.bundle.BundleFileItem;

public class BundleItem
implements Serializable,
Comparable<BundleItem> {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private List<String> applicableAgencyIds;
    private ServiceDate serviceDateFrom;
    private ServiceDate serviceDateTo;
    private DateTime created;
    private DateTime updated;
    private ArrayList<BundleFileItem> files;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getApplicableAgencyIds() {
        return this.applicableAgencyIds;
    }

    public void setApplicableAgencyIds(List<String> applicableAgencyIds) {
        this.applicableAgencyIds = applicableAgencyIds;
    }

    public ServiceDate getServiceDateFrom() {
        return this.serviceDateFrom;
    }

    public void setServiceDateFrom(ServiceDate serviceDateFrom) {
        this.serviceDateFrom = serviceDateFrom;
    }

    public ServiceDate getServiceDateTo() {
        return this.serviceDateTo;
    }

    public void setServiceDateTo(ServiceDate serviceDateTo) {
        this.serviceDateTo = serviceDateTo;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public void setCreated(DateTime created) {
        this.created = created;
    }

    public DateTime getUpdated() {
        return this.updated;
    }

    public void setUpdated(DateTime updated) {
        this.updated = updated;
    }

    public ArrayList<BundleFileItem> getFiles() {
        return this.files;
    }

    public void setFiles(ArrayList<BundleFileItem> files) {
        this.files = files;
    }

    public boolean isApplicableToDate(ServiceDate date) {
        return date.compareTo(this.serviceDateFrom) >= 0 && date.compareTo(this.serviceDateTo) <= 0;
    }

    @Override
    public int compareTo(BundleItem otherBundle) {
        return this.getUpdated().compareTo((ReadableInstant)otherBundle.getUpdated());
    }
}

