/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model;

import java.io.Serializable;
import org.onebusaway.util.SystemTime;

public final class TargetTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long currentTime;
    private final long targetTime;

    public TargetTime() {
        this(SystemTime.currentTimeMillis());
    }

    public TargetTime(long targetTime) {
        this(targetTime, SystemTime.currentTimeMillis());
    }

    public TargetTime(long targetTime, long currentTime) {
        this.currentTime = currentTime;
        this.targetTime = targetTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public long getTargetTime() {
        return this.targetTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.currentTime ^ this.currentTime >>> 32);
        result = 31 * result + (int)(this.targetTime ^ this.targetTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TargetTime other = (TargetTime)obj;
        if (this.currentTime != other.currentTime) {
            return false;
        }
        return this.targetTime == other.targetTime;
    }
}

