/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model;

import java.text.DateFormat;
import org.onebusaway.transit_data_federation.impl.blocks.BlockSequence;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.InstanceState;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;

public class StopTimeInstance {
    private static final DateFormat DAY_FORMAT = DateFormat.getDateInstance(3);
    private static final DateFormat TIME_FORMAT = DateFormat.getDateTimeInstance(3, 3);
    public static final int UNSPECIFIED_FREQUENCY_OFFSET = Integer.MIN_VALUE;
    private final BlockStopTimeEntry _stopTime;
    private final InstanceState _state;
    private final int _frequencyOffset;
    private BlockSequence blockSequence;

    public StopTimeInstance(BlockStopTimeEntry stopTime, InstanceState state) {
        this(stopTime, state, Integer.MIN_VALUE);
    }

    public StopTimeInstance(BlockStopTimeEntry stopTime, InstanceState state, int frequencyOffset) {
        this._stopTime = stopTime;
        this._state = state;
        this._frequencyOffset = frequencyOffset;
    }

    public BlockStopTimeEntry getStopTime() {
        return this._stopTime;
    }

    public InstanceState getState() {
        return this._state;
    }

    public long getServiceDate() {
        return this._state.getServiceDate();
    }

    public FrequencyEntry getFrequency() {
        return this._state.getFrequency();
    }

    public FrequencyEntry getFrequencyLabel() {
        if (this._state.getFrequency() != null) {
            return this._state.getFrequency();
        }
        return this._stopTime.getTrip().getTrip().getFrequencyLabel();
    }

    public boolean isFrequencyOffsetSpecified() {
        return StopTimeInstance.isFrequencyOffsetSpecified(this._frequencyOffset);
    }

    public int getFrequencyOffset() {
        return this._frequencyOffset;
    }

    public BlockInstance getBlockInstance() {
        return new BlockInstance(this._stopTime.getTrip().getBlockConfiguration(), this._state);
    }

    public BlockTripEntry getTrip() {
        return this._stopTime.getTrip();
    }

    public int getSequence() {
        return this._stopTime.getBlockSequence();
    }

    public StopEntry getStop() {
        return this._stopTime.getStopTime().getStop();
    }

    public long getArrivalTime() {
        int offset = this.isFrequencyOffsetSpecified() ? this._frequencyOffset : 0;
        return this._state.getServiceDate() + (long)((this._stopTime.getStopTime().getArrivalTime() + offset) * 1000);
    }

    public long getDepartureTime() {
        int offset = this.isFrequencyOffsetSpecified() ? this._frequencyOffset : 0;
        return this._state.getServiceDate() + (long)((this._stopTime.getStopTime().getDepartureTime() + offset) * 1000);
    }

    public StopTimeInstance getPreviousStopTimeInstance() {
        if (!this._stopTime.hasPreviousStop()) {
            return null;
        }
        return new StopTimeInstance(this._stopTime.getPreviousStop(), this._state, this._frequencyOffset);
    }

    public StopTimeInstance getNextStopTimeInstance() {
        if (!this._stopTime.hasNextStop()) {
            return null;
        }
        return new StopTimeInstance(this._stopTime.getNextStop(), this._state, this._frequencyOffset);
    }

    public BlockSequence getBlockSequence() {
        return this.blockSequence;
    }

    public void setBlockSequence(BlockSequence blockSequence) {
        this.blockSequence = blockSequence;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._frequencyOffset;
        result = 31 * result + this._state.hashCode();
        result = 31 * result + this._stopTime.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StopTimeInstance other = (StopTimeInstance)obj;
        if (this._frequencyOffset != other._frequencyOffset) {
            return false;
        }
        if (!this._state.equals(other._state)) {
            return false;
        }
        return this._stopTime.equals(other._stopTime);
    }

    public String toString() {
        long serviceDate = this._state.getServiceDate();
        FrequencyEntry frequency = this._state.getFrequency();
        if (frequency != null) {
            long start = serviceDate + (long)(frequency.getStartTime() * 1000);
            long end = serviceDate + (long)(frequency.getEndTime() * 1000);
            StringBuilder b = new StringBuilder();
            b.append("StopTimeInstance(stop=");
            b.append(this._stopTime.getStopTime().getStop().getId());
            b.append(" trip=");
            b.append(this.getTrip());
            b.append(" service=");
            b.append(DAY_FORMAT.format(serviceDate));
            b.append(" start=");
            b.append(TIME_FORMAT.format(start));
            b.append(" end=");
            b.append(TIME_FORMAT.format(end));
            if (this.isFrequencyOffsetSpecified()) {
                b.append(" arrival=");
                b.append(TIME_FORMAT.format(this.getArrivalTime()));
                b.append(" departure=");
                b.append(TIME_FORMAT.format(this.getDepartureTime()));
            }
            b.append(")");
            return b.toString();
        }
        return "StopTimeInstance(stop=" + this._stopTime.getStopTime().getStop().getId() + " trip=" + this.getTrip() + " service=" + DAY_FORMAT.format(serviceDate) + " arrival=" + TIME_FORMAT.format(this.getArrivalTime()) + " departure=" + TIME_FORMAT.format(this.getDepartureTime()) + ")";
    }

    public static boolean isFrequencyOffsetSpecified(int frequencyOffset) {
        return frequencyOffset != Integer.MIN_VALUE;
    }
}

