/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model;

import java.io.Serializable;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;

public class ShapePoints
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AgencyAndId shapeId;
    private double[] lats;
    private double[] lons;
    private double[] distTraveled;

    public int getSize() {
        return this.lats.length;
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public AgencyAndId getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(AgencyAndId shapeId) {
        this.shapeId = shapeId;
    }

    public double[] getLats() {
        return this.lats;
    }

    public void setLats(double[] lat) {
        this.lats = lat;
    }

    public double getLatForIndex(int index) {
        return this.lats[index];
    }

    public double[] getLons() {
        return this.lons;
    }

    public void setLons(double[] lon) {
        this.lons = lon;
    }

    public double getLonForIndex(int index) {
        return this.lons[index];
    }

    public double[] getDistTraveled() {
        return this.distTraveled;
    }

    public void setDistTraveled(double[] distTraveled) {
        this.distTraveled = distTraveled;
    }

    public double getDistTraveledForIndex(int index) {
        return this.distTraveled[index];
    }

    public CoordinatePoint getPointForIndex(int index) {
        return new CoordinatePoint(this.lats[index], this.lons[index]);
    }

    public void ensureDistTraveled() {
        if (this.distTraveled == null || this.distTraveled.length == 0) {
            return;
        }
        int n = this.distTraveled.length;
        if (this.distTraveled[n - 1] > 0.0) {
            return;
        }
        double totalDistanceTraveled = 0.0;
        double prevLat = this.lats[0];
        double prevLon = this.lons[0];
        for (int i = 1; i < n; ++i) {
            double curLat = this.lats[i];
            double curLon = this.lons[i];
            this.distTraveled[i] = totalDistanceTraveled += SphericalGeometryLibrary.distance((double)prevLat, (double)prevLon, (double)curLat, (double)curLon);
            prevLat = curLat;
            prevLon = curLon;
        }
    }
}

