/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.model;

import java.io.Serializable;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;

public class ProjectedPoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double lat;
    private final double lon;
    private final double x;
    private final double y;
    private final int srid;

    public ProjectedPoint(double lat, double lon, double x, double y, int srid) {
        this.lat = lat;
        this.lon = lon;
        this.x = x;
        this.y = y;
        this.srid = srid;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public CoordinatePoint toCoordinatePoint() {
        return new CoordinatePoint(this.lat, this.lon);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getSrid() {
        return this.srid;
    }

    public double distance(ProjectedPoint p) {
        if (this.srid == p.srid) {
            return Math.sqrt(ProjectedPoint.p2(p.x - this.x) + ProjectedPoint.p2(p.y - this.y));
        }
        return SphericalGeometryLibrary.distance((double)this.lat, (double)this.lon, (double)p.lat, (double)p.lon);
    }

    private static final double p2(double x) {
        return x * x;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.lat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.srid;
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectedPoint other = (ProjectedPoint)obj;
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lon) != Double.doubleToLongBits(other.lon)) {
            return false;
        }
        if (this.srid != other.srid) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return this.lat + " " + this.lon + " " + this.x + " " + this.y + " " + this.srid;
    }
}

