/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.strtree.STRtree;
import org.onebusaway.collections.adapter.IAdapter;
import org.onebusaway.collections.adapter.ListAdapter;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.transit_graph.AgencyEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteCollectionEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.RouteEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.TripEntryImpl;
import org.onebusaway.transit_data_federation.model.transit_graph.TransitGraph;
import org.onebusaway.transit_data_federation.services.serialization.EntryCallback;
import org.onebusaway.transit_data_federation.services.serialization.EntryIdAndCallback;
import org.onebusaway.transit_data_federation.services.transit_graph.AgencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteCollectionEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitGraphImpl
implements Serializable,
TransitGraph {
    private static final long serialVersionUID = 2L;
    private static Logger _log = LoggerFactory.getLogger(TransitGraphImpl.class);
    private static final AgencyEntryAdapter _agencyEntryAdapter = new AgencyEntryAdapter();
    private static final TripEntryAdapter _tripEntryAdapter = new TripEntryAdapter();
    private static final BlockEntryAdapter _blockEntryAdapter = new BlockEntryAdapter();
    private static final StopEntryAdapter _stopEntryAdapter = new StopEntryAdapter();
    private static final RouteCollectionEntryAdapter _routeCollectionEntryAdapter = new RouteCollectionEntryAdapter();
    private static final RouteEntryAdapter _routeEntryAdapter = new RouteEntryAdapter();
    private static transient ReadHelper _helper;
    private List<AgencyEntryImpl> _agencies = new ArrayList<AgencyEntryImpl>();
    private List<StopEntryImpl> _stops = new ArrayList<StopEntryImpl>();
    private List<TripEntryImpl> _trips = new ArrayList<TripEntryImpl>();
    private List<BlockEntryImpl> _blocks = new ArrayList<BlockEntryImpl>();
    private List<RouteCollectionEntryImpl> _routeCollections = new ArrayList<RouteCollectionEntryImpl>();
    private List<RouteEntryImpl> _routes = new ArrayList<RouteEntryImpl>();
    private transient STRtree _stopLocationTree = null;
    private transient Map<String, AgencyEntryImpl> _agencyEntriesById = new HashMap<String, AgencyEntryImpl>();
    private transient Map<AgencyAndId, StopEntryImpl> _stopEntriesById = new HashMap<AgencyAndId, StopEntryImpl>();
    private transient Map<AgencyAndId, TripEntryImpl> _tripEntriesById = new HashMap<AgencyAndId, TripEntryImpl>();
    private transient Map<AgencyAndId, BlockEntryImpl> _blockEntriesById = new HashMap<AgencyAndId, BlockEntryImpl>();
    private transient Map<AgencyAndId, RouteCollectionEntryImpl> _routeCollectionEntriesById = new HashMap<AgencyAndId, RouteCollectionEntryImpl>();
    private transient Map<AgencyAndId, RouteEntryImpl> _routeEntriesById = new HashMap<AgencyAndId, RouteEntryImpl>();

    public void empty() {
        this._agencyEntriesById.clear();
        this._stopEntriesById.clear();
        this._tripEntriesById.clear();
        this._blockEntriesById.clear();
        this._routeCollectionEntriesById.clear();
        this._routeEntriesById.clear();
        this._routeCollections.clear();
        this._blocks.clear();
        this._trips.clear();
        this._stops.clear();
        this._routes.clear();
        this._agencies.clear();
        this._stopLocationTree = null;
    }

    public void initialize() {
        int i;
        if (this._stopLocationTree == null) {
            System.out.println("initializing transit graph...");
            if (this._stops.size() == 0) {
                _log.warn("no stops found for graph");
            } else {
                this._stopLocationTree = new STRtree(this._stops.size());
                for (i = 0; i < this._stops.size(); ++i) {
                    StopEntry stop = this._stops.get(i);
                    double x = stop.getStopLon();
                    double y = stop.getStopLat();
                    Envelope r = new Envelope(x, x, y, y);
                    this._stopLocationTree.insert(r, (Object)stop);
                }
                this._stopLocationTree.build();
            }
            System.out.println("  stops=" + this._stops.size());
            System.out.println("  trips= " + this._trips.size());
        }
        if (this._agencyEntriesById == null || this._agencyEntriesById.size() < this._agencies.size()) {
            this.refreshAgencyMapping();
        }
        if (this._tripEntriesById == null || this._tripEntriesById.size() < this._trips.size()) {
            this.refreshTripMapping();
        }
        if (this._blockEntriesById == null || this._blockEntriesById.size() < this._blocks.size()) {
            this.refreshBlockMapping();
        }
        if (this._stopEntriesById == null || this._stopEntriesById.size() < this._stops.size()) {
            this.refreshStopMapping();
        }
        if (this._routeCollectionEntriesById == null || this._routeCollectionEntriesById.size() < this._routeCollections.size()) {
            this.refreshRouteCollectionMapping();
        }
        if (this._routeEntriesById == null || this._routeEntriesById.size() < this._routes.size()) {
            this.refreshRouteMapping();
        }
        i = 0;
        for (StopEntryImpl stop : this._stops) {
            stop.setIndex(i++);
        }
    }

    public void initializeFromExistinGraph(TransitGraphImpl graph) {
        this._agencies.addAll(graph._agencies);
        this._stops.addAll(graph._stops);
        this._routes.addAll(graph._routes);
        this._routeCollections.addAll(graph._routeCollections);
        this._trips.addAll(graph._trips);
        this._blocks.addAll(graph._blocks);
        this.initialize();
    }

    public void putAgencyEntry(AgencyEntryImpl agencyEntry) {
        this._agencies.add(agencyEntry);
    }

    public void putStopEntry(StopEntryImpl stopEntry) {
        this._stops.add(stopEntry);
    }

    public List<StopEntryImpl> getStops() {
        return this._stops;
    }

    public void putTripEntry(TripEntryImpl tripEntry) {
        this._trips.add(tripEntry);
    }

    public List<TripEntryImpl> getTrips() {
        return this._trips;
    }

    public void putBlockEntry(BlockEntryImpl blockEntry) {
        this._blocks.add(blockEntry);
    }

    public List<BlockEntryImpl> getBlocks() {
        return this._blocks;
    }

    public void putRouteEntry(RouteEntryImpl routeEntry) {
        this._routes.add(routeEntry);
    }

    public List<RouteEntryImpl> getRoutes() {
        return this._routes;
    }

    public void putRouteCollectionEntry(RouteCollectionEntryImpl routeCollection) {
        this._routeCollections.add(routeCollection);
    }

    public void refreshAgencyMapping() {
        this._agencyEntriesById = new HashMap<String, AgencyEntryImpl>();
        for (AgencyEntryImpl entry : this._agencies) {
            this._agencyEntriesById.put(entry.getId(), entry);
        }
    }

    public void refreshTripMapping() {
        this._tripEntriesById = new HashMap<AgencyAndId, TripEntryImpl>();
        for (TripEntryImpl entry : this._trips) {
            this._tripEntriesById.put(entry.getId(), entry);
        }
    }

    public void refreshBlockMapping() {
        this._blockEntriesById = new HashMap<AgencyAndId, BlockEntryImpl>();
        for (BlockEntryImpl entry : this._blocks) {
            this._blockEntriesById.put(entry.getId(), entry);
        }
    }

    public void refreshStopMapping() {
        this._stopEntriesById = new HashMap<AgencyAndId, StopEntryImpl>();
        for (StopEntryImpl entry : this._stops) {
            this._stopEntriesById.put(entry.getId(), entry);
        }
    }

    public void refreshRouteMapping() {
        this._routeEntriesById = new HashMap<AgencyAndId, RouteEntryImpl>();
        for (RouteEntryImpl entry : this._routes) {
            this._routeEntriesById.put(entry.getId(), entry);
        }
    }

    public void refreshRouteCollectionMapping() {
        this._routeCollectionEntriesById = new HashMap<AgencyAndId, RouteCollectionEntryImpl>();
        for (RouteCollectionEntryImpl entry : this._routeCollections) {
            this._routeCollectionEntriesById.put(entry.getId(), entry);
        }
    }

    @Override
    public List<AgencyEntry> getAllAgencies() {
        return new ListAdapter(this._agencies, (IAdapter)_agencyEntryAdapter);
    }

    @Override
    public AgencyEntryImpl getAgencyForId(String id) {
        return this._agencyEntriesById.get(id);
    }

    @Override
    public List<StopEntry> getAllStops() {
        return new ListAdapter(this._stops, (IAdapter)_stopEntryAdapter);
    }

    @Override
    public List<TripEntry> getAllTrips() {
        return new ListAdapter(this._trips, (IAdapter)_tripEntryAdapter);
    }

    @Override
    public List<BlockEntry> getAllBlocks() {
        return new ListAdapter(this._blocks, (IAdapter)_blockEntryAdapter);
    }

    @Override
    public List<RouteCollectionEntry> getAllRouteCollections() {
        return new ListAdapter(this._routeCollections, (IAdapter)_routeCollectionEntryAdapter);
    }

    @Override
    public List<RouteEntry> getAllRoutes() {
        return new ListAdapter(this._routes, (IAdapter)_routeEntryAdapter);
    }

    @Override
    public StopEntryImpl getStopEntryForId(AgencyAndId id) {
        return this._stopEntriesById.get(id);
    }

    @Override
    public TripEntryImpl getTripEntryForId(AgencyAndId id) {
        return this._tripEntriesById.get(id);
    }

    @Override
    public BlockEntry getBlockEntryForId(AgencyAndId blockId) {
        return this._blockEntriesById.get(blockId);
    }

    @Override
    public RouteCollectionEntry getRouteCollectionForId(AgencyAndId id) {
        return this._routeCollectionEntriesById.get(id);
    }

    @Override
    public RouteEntryImpl getRouteForId(AgencyAndId id) {
        return this._routeEntriesById.get(id);
    }

    @Override
    public List<StopEntry> getStopsByLocation(CoordinateBounds bounds) {
        if (this._stopLocationTree == null) {
            return Collections.emptyList();
        }
        Envelope r = new Envelope(bounds.getMinLon(), bounds.getMaxLon(), bounds.getMinLat(), bounds.getMaxLat());
        StopRTreeVisitor go = new StopRTreeVisitor();
        this._stopLocationTree.query(r, (ItemVisitor)go);
        return go.getStops();
    }

    public static void handleStopEntryRead(StopEntryImpl stopEntryImpl) {
        _helper.handleStopEntryRead(stopEntryImpl);
    }

    public static void handleTripEntryRead(TripEntryImpl tripEntryImpl) {
        _helper.handleTripEntryRead(tripEntryImpl);
    }

    public static void addStopEntryCallback(AgencyAndId stopEntry, EntryCallback<StopEntryImpl> entry) {
        _helper.addStopEntryCallback(stopEntry, entry);
    }

    public static void addTripEntryCallback(AgencyAndId tripEntry, EntryCallback<TripEntryImpl> entry) {
        _helper.addTripEntryCallback(tripEntry, entry);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        _helper = new ReadHelper();
        in.defaultReadObject();
        _helper.flush();
        _helper = null;
        this.initialize();
        System.gc();
        System.gc();
    }

    private static class RouteEntryAdapter
    implements IAdapter<RouteEntryImpl, RouteEntry> {
        private RouteEntryAdapter() {
        }

        public RouteEntry adapt(RouteEntryImpl source) {
            return source;
        }
    }

    private static class RouteCollectionEntryAdapter
    implements IAdapter<RouteCollectionEntryImpl, RouteCollectionEntry> {
        private RouteCollectionEntryAdapter() {
        }

        public RouteCollectionEntry adapt(RouteCollectionEntryImpl source) {
            return source;
        }
    }

    private static class StopEntryAdapter
    implements IAdapter<StopEntryImpl, StopEntry> {
        private StopEntryAdapter() {
        }

        public StopEntry adapt(StopEntryImpl source) {
            return source;
        }
    }

    private static class BlockEntryAdapter
    implements IAdapter<BlockEntryImpl, BlockEntry> {
        private BlockEntryAdapter() {
        }

        public BlockEntry adapt(BlockEntryImpl source) {
            return source;
        }
    }

    private static class TripEntryAdapter
    implements IAdapter<TripEntryImpl, TripEntry> {
        private TripEntryAdapter() {
        }

        public TripEntry adapt(TripEntryImpl source) {
            return source;
        }
    }

    private static class AgencyEntryAdapter
    implements IAdapter<AgencyEntryImpl, AgencyEntry> {
        private AgencyEntryAdapter() {
        }

        public AgencyEntry adapt(AgencyEntryImpl source) {
            return source;
        }
    }

    private static class ReadHelper {
        private Map<AgencyAndId, StopEntryImpl> _stops = new HashMap<AgencyAndId, StopEntryImpl>();
        private Map<AgencyAndId, TripEntryImpl> _trips = new HashMap<AgencyAndId, TripEntryImpl>();
        private List<EntryIdAndCallback<AgencyAndId, StopEntryImpl>> _stopCallbacks = new ArrayList<EntryIdAndCallback<AgencyAndId, StopEntryImpl>>();
        private List<EntryIdAndCallback<AgencyAndId, TripEntryImpl>> _tripCallbacks = new ArrayList<EntryIdAndCallback<AgencyAndId, TripEntryImpl>>();

        private ReadHelper() {
        }

        public void handleStopEntryRead(StopEntryImpl stopEntryImpl) {
            this._stops.put(stopEntryImpl.getId(), stopEntryImpl);
        }

        public void handleTripEntryRead(TripEntryImpl tripEntryImpl) {
            this._trips.put(tripEntryImpl.getId(), tripEntryImpl);
        }

        public void addStopEntryCallback(AgencyAndId stopEntryId, EntryCallback<StopEntryImpl> callback) {
            this._stopCallbacks.add(new EntryIdAndCallback<AgencyAndId, StopEntryImpl>(stopEntryId, callback));
        }

        public void addTripEntryCallback(AgencyAndId tripEntryId, EntryCallback<TripEntryImpl> callback) {
            this._tripCallbacks.add(new EntryIdAndCallback<AgencyAndId, TripEntryImpl>(tripEntryId, callback));
        }

        public void flush() {
            Serializable entry;
            for (EntryIdAndCallback<AgencyAndId, StopEntryImpl> entryIdAndCallback : this._stopCallbacks) {
                entry = this._stops.get(entryIdAndCallback.getId());
                if (entry == null) {
                    throw new IllegalStateException("no such stop entry: " + entryIdAndCallback.getId());
                }
                entryIdAndCallback.getCallback().handle((StopEntryImpl)entry);
            }
            for (EntryIdAndCallback<AgencyAndId, Serializable> entryIdAndCallback : this._tripCallbacks) {
                entry = this._trips.get(entryIdAndCallback.getId());
                if (entry == null) {
                    throw new IllegalStateException("no such trip entry: " + entryIdAndCallback.getId());
                }
                entryIdAndCallback.getCallback().handle(entry);
            }
            this._stopCallbacks.clear();
            this._tripCallbacks.clear();
            this._stopCallbacks = null;
            this._tripCallbacks = null;
            this._stops.clear();
            this._trips.clear();
            this._stops = null;
            this._trips = null;
        }
    }

    private class StopRTreeVisitor
    implements ItemVisitor {
        private List<StopEntry> _nearbyStops = new ArrayList<StopEntry>();

        private StopRTreeVisitor() {
        }

        public List<StopEntry> getStops() {
            return this._nearbyStops;
        }

        public void visitItem(Object obj) {
            this._nearbyStops.add((StopEntry)obj);
        }
    }
}

