/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.EAccessibility;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphImpl;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyBlockStopTimeIndex;
import org.onebusaway.transit_data_federation.services.blocks.FrequencyStopTripIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;

public class StopEntryImpl
implements StopEntry,
Serializable {
    private static final long serialVersionUID = 2L;
    private final AgencyAndId _id;
    private final double _lat;
    private final double _lon;
    private EAccessibility _wheelchairBoarding = EAccessibility.UNKNOWN;
    private transient int _index;
    private transient List<BlockStopTimeIndex> _stopTimeIndices = null;
    private transient List<FrequencyBlockStopTimeIndex> _frequencyStopTimeIndices = null;
    private transient List<BlockStopSequenceIndex> _stopTripIndices = null;
    private transient List<FrequencyStopTripIndex> _frequencyStopTripIndices = null;
    private final AgencyAndId _parent;

    public StopEntryImpl(AgencyAndId id, double lat, double lon, AgencyAndId parent) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this._id = id;
        this._lat = lat;
        this._lon = lon;
        this._parent = parent;
    }

    public StopEntryImpl(AgencyAndId id, double lat, double lon) {
        this(id, lat, lon, null);
    }

    public void setWheelchairBoarding(EAccessibility wheelchairBoarding) {
        this._wheelchairBoarding = wheelchairBoarding;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public void addStopTimeIndex(BlockStopTimeIndex stopTimeIndex) {
        if (this._stopTimeIndices == null) {
            this._stopTimeIndices = new ArrayList<BlockStopTimeIndex>();
        }
        this._stopTimeIndices.add(stopTimeIndex);
    }

    public List<BlockStopTimeIndex> getStopTimeIndices() {
        if (this._stopTimeIndices == null) {
            return Collections.emptyList();
        }
        return this._stopTimeIndices;
    }

    public void addFrequencyStopTimeIndex(FrequencyBlockStopTimeIndex stopTimeIndex) {
        if (this._frequencyStopTimeIndices == null) {
            this._frequencyStopTimeIndices = new ArrayList<FrequencyBlockStopTimeIndex>();
        }
        this._frequencyStopTimeIndices.add(stopTimeIndex);
    }

    public List<FrequencyBlockStopTimeIndex> getFrequencyStopTimeIndices() {
        if (this._frequencyStopTimeIndices == null) {
            return Collections.emptyList();
        }
        return this._frequencyStopTimeIndices;
    }

    public void addBlockStopTripIndex(BlockStopSequenceIndex index) {
        if (this._stopTripIndices == null) {
            this._stopTripIndices = new ArrayList<BlockStopSequenceIndex>();
        }
        this._stopTripIndices.add(index);
    }

    public List<BlockStopSequenceIndex> getStopTripIndices() {
        if (this._stopTripIndices == null) {
            return Collections.emptyList();
        }
        return this._stopTripIndices;
    }

    public void addFrequencyStopTripIndex(FrequencyStopTripIndex index) {
        if (this._frequencyStopTripIndices == null) {
            this._frequencyStopTripIndices = new ArrayList<FrequencyStopTripIndex>();
        }
        this._frequencyStopTripIndices.add(index);
    }

    public List<FrequencyStopTripIndex> getFrequencyStopTripIndices() {
        if (this._frequencyStopTripIndices == null) {
            return Collections.emptyList();
        }
        return this._frequencyStopTripIndices;
    }

    @Override
    public AgencyAndId getId() {
        return this._id;
    }

    @Override
    public double getStopLat() {
        return this._lat;
    }

    @Override
    public double getStopLon() {
        return this._lon;
    }

    @Override
    public CoordinatePoint getStopLocation() {
        return new CoordinatePoint(this._lat, this._lon);
    }

    @Override
    public EAccessibility getWheelchairBoarding() {
        return this._wheelchairBoarding;
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    @Override
    public AgencyAndId getParent() {
        return this._parent;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StopEntry)) {
            return false;
        }
        StopEntry stop = (StopEntry)obj;
        return this._id.equals((Object)stop.getId());
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        return "StopEntry(id=" + this._id + ")";
    }

    @Override
    public int compareTo(StopEntry o) {
        return this.getIndex() - o.getIndex();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        TransitGraphImpl.handleStopEntryRead(this);
    }
}

