/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicCache;
import org.onebusaway.transit_data_federation.model.transit_graph.DynamicGraph;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DynamicGraphImpl
extends DynamicCache
implements DynamicGraph {
    private static Logger _log = LoggerFactory.getLogger(DynamicGraphImpl.class);
    private Map<AgencyAndId, BlockEntry> blockEntryById = new HashMap<AgencyAndId, BlockEntry>();
    private Map<AgencyAndId, TripEntry> tripEntryById = new HashMap<AgencyAndId, TripEntry>();
    private Map<AgencyAndId, RouteEntry> routeEntryById = new HashMap<AgencyAndId, RouteEntry>();

    @Override
    public TripEntry getTripEntryForId(AgencyAndId id) {
        return this.tripEntryById.get(id);
    }

    @Override
    public void registerTrip(TripEntry tripEntry, long currentTime) {
        if (this.needsPrune(currentTime)) {
            this.prune(currentTime);
        }
        if (!this.tripEntryById.containsKey(tripEntry.getId())) {
            this.tripEntryById.put(tripEntry.getId(), tripEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prune(long currentTime) {
        long start = System.currentTimeMillis();
        try {
            this.resetStats(currentTime);
            int effectiveTime = this.getEffectiveTime(currentTime);
            this.pruneBlockEntryById(effectiveTime);
            this.pruneTripEntryById(effectiveTime);
            this.pruneRouteEntryById(effectiveTime);
        }
        catch (Throwable t) {
            _log.error("prune exception {}", (Object)t, (Object)t);
        }
        finally {
            _log.info("cache prune complete in {}ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void pruneRouteEntryById(int effectiveTime) {
    }

    private void pruneTripEntryById(int effectiveTime) {
        Iterator<Map.Entry<AgencyAndId, TripEntry>> iterator = this.tripEntryById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AgencyAndId, TripEntry> next = iterator.next();
            if (!this.isExpired(next.getValue(), effectiveTime)) continue;
            iterator.remove();
        }
    }

    private void pruneBlockEntryById(int effectiveTime) {
        Iterator<Map.Entry<AgencyAndId, BlockEntry>> iterator = this.blockEntryById.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AgencyAndId, BlockEntry> next = iterator.next();
            if (!this.isExpired(next.getValue(), effectiveTime)) continue;
            iterator.remove();
        }
    }

    @Override
    public void updateTrip(TripEntry tripEntry) {
        this.tripEntryById.put(tripEntry.getId(), tripEntry);
    }

    @Override
    public RouteEntry getRoutEntryForId(AgencyAndId id) {
        return this.routeEntryById.get(id);
    }

    @Override
    public void registerRoute(RouteEntry routeEntry) {
        if (!this.routeEntryById.containsKey(routeEntry.getId())) {
            this.routeEntryById.put(routeEntry.getId(), routeEntry);
        }
    }

    @Override
    public BlockEntry getBlockEntryForId(AgencyAndId id) {
        return this.blockEntryById.get(id);
    }

    @Override
    public void registerBlock(BlockEntry blockEntry) {
        if (!this.blockEntryById.containsKey(blockEntry.getId())) {
            this.blockEntryById.put(blockEntry.getId(), blockEntry);
        }
    }

    @Override
    public void updateBlock(BlockEntry blockEntry) {
        this.blockEntryById.put(blockEntry.getId(), blockEntry);
    }
}

