/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.Serializable;
import java.util.List;
import org.onebusaway.transit_data_federation.services.blocks.AbstractBlockTripIndex;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class BlockTripEntryImpl
implements BlockTripEntry,
Serializable {
    private static final long serialVersionUID = 2L;
    private BlockConfigurationEntry blockConfiguration;
    private TripEntry trip;
    private short sequence;
    private short accumulatedStopTimeIndex;
    private int accumulatedSlackTime;
    private double distanceAlongBlock;
    private BlockTripEntry previousTrip;
    private BlockTripEntry nextTrip;
    private AbstractBlockTripIndex pattern;

    public void setTrip(TripEntry trip) {
        this.trip = trip;
    }

    public void setBlockConfiguration(BlockConfigurationEntry blockConfiguration) {
        this.blockConfiguration = blockConfiguration;
    }

    public void setSequence(short sequence) {
        this.sequence = sequence;
    }

    public void setAccumulatedStopTimeIndex(short accumulatedStopTimeIndex) {
        this.accumulatedStopTimeIndex = accumulatedStopTimeIndex;
    }

    public void setAccumulatedSlackTime(int accumulatedSlackTime) {
        this.accumulatedSlackTime = accumulatedSlackTime;
    }

    public void setDistanceAlongBlock(double distanceAlongBlock) {
        this.distanceAlongBlock = distanceAlongBlock;
    }

    public void setPreviousTrip(BlockTripEntry previousTrip) {
        this.previousTrip = previousTrip;
    }

    public void setNextTrip(BlockTripEntry nextTrip) {
        this.nextTrip = nextTrip;
    }

    public void setPattern(AbstractBlockTripIndex pattern) {
        this.pattern = pattern;
    }

    @Override
    public BlockConfigurationEntry getBlockConfiguration() {
        return this.blockConfiguration;
    }

    @Override
    public TripEntry getTrip() {
        return this.trip;
    }

    @Override
    public List<BlockStopTimeEntry> getStopTimes() {
        List<BlockStopTimeEntry> stopTimes = this.blockConfiguration.getStopTimes();
        int toIndex = stopTimes.size();
        if (this.nextTrip != null) {
            toIndex = this.nextTrip.getAccumulatedStopTimeIndex();
        }
        return stopTimes.subList(this.accumulatedStopTimeIndex, toIndex);
    }

    @Override
    public short getSequence() {
        return this.sequence;
    }

    @Override
    public short getAccumulatedStopTimeIndex() {
        return this.accumulatedStopTimeIndex;
    }

    @Override
    public int getAccumulatedSlackTime() {
        return this.accumulatedSlackTime;
    }

    @Override
    public double getDistanceAlongBlock() {
        return this.distanceAlongBlock;
    }

    @Override
    public BlockTripEntry getPreviousTrip() {
        return this.previousTrip;
    }

    @Override
    public BlockTripEntry getNextTrip() {
        return this.nextTrip;
    }

    @Override
    public int getArrivalTimeForIndex(int stopIndex) {
        return this.trip.getStopTimes().get(stopIndex).getArrivalTime();
    }

    @Override
    public int getDepartureTimeForIndex(int stopIndex) {
        return this.trip.getStopTimes().get(stopIndex).getDepartureTime();
    }

    @Override
    public double getDistanceAlongBlockForIndex(int stopIndex) {
        return this.distanceAlongBlock + this.trip.getStopTimes().get(stopIndex).getShapeDistTraveled();
    }

    @Override
    public AbstractBlockTripIndex getPattern() {
        return this.pattern;
    }

    public String toString() {
        return this.trip.getId().toString();
    }
}

