/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.transit_graph;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockStopTimeEntryImpl;
import org.onebusaway.transit_data_federation.impl.transit_graph.BlockTripEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.FrequencyEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;

public class BlockConfigurationEntryImpl
implements BlockConfigurationEntry,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BlockEntry block;
    private final ServiceIdActivation serviceIds;
    private final List<BlockTripEntry> trips;
    private final double totalBlockDistance;
    private final BlockStopTimeList blockStopTimes = new BlockStopTimeList();
    private final int[] tripIndices;
    private final int[] accumulatedStopTimeIndices;
    private List<FrequencyEntry> frequencies;

    private BlockConfigurationEntryImpl(Builder builder) {
        this.block = builder.block;
        this.serviceIds = builder.serviceIds;
        this.trips = builder.computeBlockTrips(this);
        this.frequencies = builder.frequencies;
        this.totalBlockDistance = builder.computeTotalBlockDistance();
        this.tripIndices = builder.computeTripIndices();
        this.accumulatedStopTimeIndices = builder.computeAccumulatedStopTimeIndices();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setFrequencies(List<FrequencyEntry> frequencies) {
        this.frequencies = frequencies;
    }

    @Override
    public BlockEntry getBlock() {
        return this.block;
    }

    @Override
    public ServiceIdActivation getServiceIds() {
        return this.serviceIds;
    }

    @Override
    public List<BlockTripEntry> getTrips() {
        return this.trips;
    }

    @Override
    public List<FrequencyEntry> getFrequencies() {
        return this.frequencies;
    }

    @Override
    public List<BlockStopTimeEntry> getStopTimes() {
        return this.blockStopTimes;
    }

    @Override
    public double getTotalBlockDistance() {
        return this.totalBlockDistance;
    }

    @Override
    public int getArrivalTimeForIndex(int index) {
        StopTimeEntry stopTime = this.getStopTimeForIndex(index);
        return stopTime.getArrivalTime();
    }

    @Override
    public int getDepartureTimeForIndex(int index) {
        StopTimeEntry stopTime = this.getStopTimeForIndex(index);
        return stopTime.getDepartureTime();
    }

    @Override
    public double getDistanceAlongBlockForIndex(int index) {
        int tripIndex = this.tripIndices[index];
        BlockTripEntry blockTrip = this.trips.get(tripIndex);
        TripEntry trip = blockTrip.getTrip();
        List<StopTimeEntry> stopTimes = trip.getStopTimes();
        int stopTimeIndex = index - this.accumulatedStopTimeIndices[tripIndex];
        StopTimeEntry stopTime = stopTimes.get(stopTimeIndex);
        return blockTrip.getDistanceAlongBlock() + stopTime.getShapeDistTraveled();
    }

    @Override
    public OccupancyStatus getOccupancyForIndex(int index) {
        StopTimeEntry stopTime = this.getStopTimeForIndex(index);
        return stopTime.getHistoricalOccupancy();
    }

    public String toString() {
        return "BlockConfiguration [block=" + this.block.getId() + " serviceIds=" + this.serviceIds + "]";
    }

    private StopTimeEntry getStopTimeForIndex(int index) {
        int tripIndex = this.tripIndices[index];
        BlockTripEntry blockTrip = this.trips.get(tripIndex);
        TripEntry trip = blockTrip.getTrip();
        List<StopTimeEntry> stopTimes = trip.getStopTimes();
        int stopTimeIndex = index - this.accumulatedStopTimeIndices[tripIndex];
        StopTimeEntry stopTime = stopTimes.get(stopTimeIndex);
        return stopTime;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BlockConfigurationEntry)) {
            return false;
        }
        BlockConfigurationEntry bce = (BlockConfigurationEntry)obj;
        return this.block.equals(bce.getBlock()) && this.serviceIds.equals(bce.getServiceIds());
    }

    public int hashCode() {
        return this.block.hashCode() + this.serviceIds.hashCode();
    }

    private class BlockStopTimeList
    extends AbstractList<BlockStopTimeEntry>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private BlockStopTimeList() {
        }

        @Override
        public int size() {
            return BlockConfigurationEntryImpl.this.tripIndices.length;
        }

        @Override
        public BlockStopTimeEntry get(int index) {
            int tripIndex = BlockConfigurationEntryImpl.this.tripIndices[index];
            BlockTripEntry blockTrip = BlockConfigurationEntryImpl.this.trips.get(tripIndex);
            TripEntry trip = blockTrip.getTrip();
            List<StopTimeEntry> stopTimes = trip.getStopTimes();
            int stopTimeIndex = index - BlockConfigurationEntryImpl.this.accumulatedStopTimeIndices[tripIndex];
            StopTimeEntry stopTime = stopTimes.get(stopTimeIndex);
            boolean hasNextStop = index + 1 < BlockConfigurationEntryImpl.this.tripIndices.length;
            return new BlockStopTimeEntryImpl(stopTime, index, blockTrip, hasNextStop);
        }
    }

    public static class Builder {
        private BlockEntry block;
        private ServiceIdActivation serviceIds;
        private List<TripEntry> trips;
        private List<FrequencyEntry> frequencies;
        private double[] tripGapDistances;

        private Builder() {
        }

        public void setBlock(BlockEntry block) {
            this.block = block;
        }

        public void setServiceIds(ServiceIdActivation serviceIds) {
            this.serviceIds = serviceIds;
        }

        public List<TripEntry> getTrips() {
            return this.trips;
        }

        public void setTrips(List<TripEntry> trips) {
            this.trips = trips;
        }

        public List<FrequencyEntry> getFrequencies() {
            return this.frequencies;
        }

        public void setFrequencies(List<FrequencyEntry> frequencies) {
            this.frequencies = frequencies;
        }

        public void setTripGapDistances(double[] tripGapDistances) {
            this.tripGapDistances = tripGapDistances;
        }

        public BlockConfigurationEntry create() {
            return new BlockConfigurationEntryImpl(this);
        }

        private double computeTotalBlockDistance() {
            double distance = 0.0;
            for (int i = 0; i < this.trips.size(); ++i) {
                TripEntry trip = this.trips.get(i);
                distance += trip.getTotalTripDistance() + this.tripGapDistances[i];
            }
            return distance;
        }

        private int[] computeTripIndices() {
            int n = 0;
            for (TripEntry trip : this.trips) {
                n += trip.getStopTimes().size();
            }
            int[] tripIndices = new int[n];
            int index = 0;
            for (int tripIndex = 0; tripIndex < this.trips.size(); ++tripIndex) {
                TripEntry trip = this.trips.get(tripIndex);
                for (int i = 0; i < trip.getStopTimes().size(); ++i) {
                    tripIndices[index++] = tripIndex;
                }
            }
            return tripIndices;
        }

        private int[] computeAccumulatedStopTimeIndices() {
            int[] accumulatedStopTimeIndices = new int[this.trips.size()];
            int n = 0;
            for (int i = 0; i < this.trips.size(); ++i) {
                accumulatedStopTimeIndices[i] = n;
                n += this.trips.get(i).getStopTimes().size();
            }
            return accumulatedStopTimeIndices;
        }

        private List<BlockTripEntry> computeBlockTrips(BlockConfigurationEntryImpl blockConfiguration) {
            ArrayList<BlockTripEntry> blockTrips = new ArrayList<BlockTripEntry>();
            short accumulatedStopTimeIndex = 0;
            int accumulatedSlackTime = 0;
            double distanceAlongBlock = 0.0;
            BlockTripEntryImpl prevTrip = null;
            StopTimeEntry prevTripStopTime = null;
            double prevTripAvgVelocity = 0.0;
            for (short i = 0; i < this.trips.size(); i = (short)(i + 1)) {
                TripEntry tripEntry = this.trips.get(i);
                List<StopTimeEntry> stopTimes = tripEntry.getStopTimes();
                if (prevTripStopTime != null) {
                    StopTimeEntry nextStopTime = stopTimes.get(0);
                    int slackTime = nextStopTime.getArrivalTime() - prevTripStopTime.getDepartureTime();
                    double distance = distanceAlongBlock - (prevTrip.getDistanceAlongBlock() + prevTripStopTime.getShapeDistTraveled()) + nextStopTime.getShapeDistTraveled();
                    if (prevTripAvgVelocity > 0.0) {
                        int timeToTravel = (int)(distance / prevTripAvgVelocity);
                        slackTime -= Math.min(timeToTravel, slackTime);
                    }
                    accumulatedSlackTime += slackTime;
                }
                BlockTripEntryImpl blockTripEntry = new BlockTripEntryImpl();
                blockTripEntry.setTrip(tripEntry);
                blockTripEntry.setBlockConfiguration(blockConfiguration);
                blockTripEntry.setSequence(i);
                blockTripEntry.setAccumulatedStopTimeIndex(accumulatedStopTimeIndex);
                blockTripEntry.setAccumulatedSlackTime(accumulatedSlackTime);
                blockTripEntry.setDistanceAlongBlock(distanceAlongBlock);
                if (prevTrip != null) {
                    prevTrip.setNextTrip(blockTripEntry);
                    blockTripEntry.setPreviousTrip(prevTrip);
                }
                blockTrips.add(blockTripEntry);
                accumulatedStopTimeIndex = (short)(accumulatedStopTimeIndex + stopTimes.size());
                if (accumulatedSlackTime < 0) {
                    throw new IllegalStateException("I didn't think this was possible, but the number of stop times in a particular block exceeded 32767 causing a wrap-around in the accumulated stop time index: blockId=" + blockConfiguration.getBlock().getId());
                }
                for (StopTimeEntry stopTime : stopTimes) {
                    accumulatedSlackTime += stopTime.getSlackTime();
                }
                prevTripAvgVelocity = this.computeAverageTripTravelVelocity(stopTimes);
                distanceAlongBlock += tripEntry.getTotalTripDistance() + this.tripGapDistances[i];
                prevTrip = blockTripEntry;
                prevTripStopTime = stopTimes.get(stopTimes.size() - 1);
            }
            blockTrips.trimToSize();
            return blockTrips;
        }

        private double computeAverageTripTravelVelocity(List<StopTimeEntry> stopTimes) {
            int accumulatedTravelTime = 0;
            double accumulatedTravelDistance = 0.0;
            StopTimeEntry prevStopTime = null;
            for (StopTimeEntry stopTime : stopTimes) {
                if (prevStopTime != null) {
                    accumulatedTravelTime += stopTime.getArrivalTime() - prevStopTime.getDepartureTime();
                    accumulatedTravelDistance += stopTime.getShapeDistTraveled() - prevStopTime.getShapeDistTraveled();
                }
                prevStopTime = stopTime;
            }
            if (accumulatedTravelTime == 0) {
                return 0.0;
            }
            return accumulatedTravelDistance / (double)accumulatedTravelTime;
        }
    }
}

