/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.shapes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.onebusaway.collections.Min;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.model.Point;
import org.onebusaway.geospatial.model.XYPoint;
import org.onebusaway.geospatial.services.GeometryLibrary;
import org.onebusaway.geospatial.services.UTMProjection;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndIndex;
import org.onebusaway.transit_data_federation.model.ShapePoints;

public class ShapePointsLibrary {
    private double _localMinimumThreshold = 50.0;

    public ShapePointsLibrary() {
    }

    public ShapePointsLibrary(double localMinimumThreshold) {
        this._localMinimumThreshold = localMinimumThreshold;
    }

    public void setLocalMinimumThreshold(double localMinimumThreshold) {
        this._localMinimumThreshold = localMinimumThreshold;
    }

    public List<XYPoint> getProjectedShapePoints(ShapePoints shapePoints, UTMProjection projection) {
        ArrayList<XYPoint> projectedShapePoints = new ArrayList<XYPoint>();
        double[] lats = shapePoints.getLats();
        double[] lons = shapePoints.getLons();
        int n = lats.length;
        for (int i = 0; i < n; ++i) {
            projectedShapePoints.add(projection.forward(new CoordinatePoint(lats[i], lons[i])));
        }
        return projectedShapePoints;
    }

    public List<PointAndIndex> computePotentialAssignments(List<XYPoint> projectedShapePoints, double[] shapePointDistance, XYPoint targetPoint, int fromIndex, int toIndex) {
        if (shapePointDistance == null) {
            return null;
        }
        Min min = new Min();
        Min localMin = new Min();
        ArrayList<PointAndIndex> localMins = new ArrayList<PointAndIndex>();
        boolean previousEndpointDistanceGreaterThanSnappedDistance = false;
        double previousEndpointDistance = Double.POSITIVE_INFINITY;
        for (int i = fromIndex; i < toIndex - 1; ++i) {
            XYPoint from = projectedShapePoints.get(i);
            XYPoint to = projectedShapePoints.get(i + 1);
            XYPoint location = (XYPoint)GeometryLibrary.projectPointToSegment((Point)targetPoint, (Point)from, (Point)to);
            double d = location.getDistance((Point)targetPoint);
            double distanceAlongShape = shapePointDistance[i] + location.getDistance((Point)from);
            PointAndIndex pindex = new PointAndIndex(location, i, d, distanceAlongShape);
            min.add(d, (Object)pindex);
            if (d <= this._localMinimumThreshold) {
                if (previousEndpointDistanceGreaterThanSnappedDistance && d < previousEndpointDistance && !localMin.isEmpty()) {
                    localMins.add((PointAndIndex)localMin.getMinElement());
                    localMin = new Min();
                }
                localMin.add(d, (Object)pindex);
            } else if (!localMin.isEmpty()) {
                localMins.add((PointAndIndex)localMin.getMinElement());
                localMin = new Min();
            }
            previousEndpointDistance = to.getDistance((Point)targetPoint);
            previousEndpointDistanceGreaterThanSnappedDistance = previousEndpointDistance > d;
        }
        if (min.isEmpty()) {
            return Collections.emptyList();
        }
        if (!localMin.isEmpty()) {
            localMins.add((PointAndIndex)localMin.getMinElement());
        }
        if (localMins.isEmpty()) {
            localMins.addAll(min.getMinElements());
        }
        return localMins;
    }
}

