/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.shapes;

import org.onebusaway.collections.Min;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.transit_data_federation.impl.shapes.AbstractShapePointIndex;
import org.onebusaway.transit_data_federation.impl.shapes.PointAndOrientation;
import org.onebusaway.transit_data_federation.model.ShapePoints;

public class LocationShapePointIndex
extends AbstractShapePointIndex {
    private double _lat;
    private double _lon;

    public LocationShapePointIndex(double lat, double lon) {
        this._lat = lat;
        this._lon = lon;
    }

    @Override
    public int getIndex(ShapePoints points) {
        Min m = new Min();
        int n = points.getSize();
        double[] lats = points.getLats();
        double[] lons = points.getLons();
        for (int i = 0; i < n; ++i) {
            double d = LocationShapePointIndex.distance(this._lat, this._lon, lats[i], lons[i]);
            m.add(d, (Object)i);
        }
        return (Integer)m.getMinElement();
    }

    @Override
    public CoordinatePoint getPoint(ShapePoints points) {
        return new CoordinatePoint(this._lat, this._lon);
    }

    @Override
    public PointAndOrientation getPointAndOrientation(ShapePoints points) {
        return new PointAndOrientation(this._lat, this._lon, 0.0);
    }

    private static double distance(double lat1, double lon1, double lat2, double lon2) {
        double dLat = lat1 - lat2;
        double dLon = lon1 - lon2;
        return Math.sqrt(dLat * dLat + dLon * dLon);
    }
}

