/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.siri;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.datatype.Duration;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.impl.ServiceAlertLocalizedString;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertSituationConsequenceClause;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.alerts.service.ServiceAlertsService;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.siri.AffectedApplicationStructure;
import org.onebusaway.siri.OneBusAwayAffects;
import org.onebusaway.siri.OneBusAwayAffectsStructure;
import org.onebusaway.siri.OneBusAwayConsequence;
import org.onebusaway.siri.core.ESiriModuleType;
import org.onebusaway.transit_data.model.service_alerts.ECause;
import org.onebusaway.transit_data.model.service_alerts.EEffect;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.transit_data_federation.impl.realtime.siri.SiriEndpointDetails;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import uk.org.siri.siri.AbstractServiceDeliveryStructure;
import uk.org.siri.siri.AffectedCallStructure;
import uk.org.siri.siri.AffectedOperatorStructure;
import uk.org.siri.siri.AffectedStopPointStructure;
import uk.org.siri.siri.AffectedVehicleJourneyStructure;
import uk.org.siri.siri.AffectsScopeStructure;
import uk.org.siri.siri.BlockRefStructure;
import uk.org.siri.siri.DefaultedTextStructure;
import uk.org.siri.siri.EntryQualifierStructure;
import uk.org.siri.siri.ExtensionsStructure;
import uk.org.siri.siri.FramedVehicleJourneyRefStructure;
import uk.org.siri.siri.HalfOpenTimestampRangeStructure;
import uk.org.siri.siri.LocationStructure;
import uk.org.siri.siri.OperatorRefStructure;
import uk.org.siri.siri.PtConsequenceStructure;
import uk.org.siri.siri.PtConsequencesStructure;
import uk.org.siri.siri.PtSituationElementStructure;
import uk.org.siri.siri.ServiceConditionEnumeration;
import uk.org.siri.siri.ServiceDelivery;
import uk.org.siri.siri.SeverityEnumeration;
import uk.org.siri.siri.SituationExchangeDeliveryStructure;
import uk.org.siri.siri.StopPointRefStructure;
import uk.org.siri.siri.VehicleActivityStructure;
import uk.org.siri.siri.VehicleJourneyRefStructure;
import uk.org.siri.siri.VehicleMonitoringDeliveryStructure;
import uk.org.siri.siri.VehicleRefStructure;
import uk.org.siri.siri.WorkflowStatusEnumeration;

@Component
public class SiriService {
    private static final Logger _log = LoggerFactory.getLogger(SiriService.class);
    private TransitGraphDao _transitGraphDao;
    private ServiceAlertsService _serviceAlertsService;
    private VehicleLocationListener _vehicleLocationListener;
    private BlockCalendarService _blockCalendarService;
    private int _blockInstanceSearchWindow = 30;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setServiceAlertService(ServiceAlertsService serviceAlertsService) {
        this._serviceAlertsService = serviceAlertsService;
    }

    @Autowired
    @Qualifier(value="vehicleStatusServiceImpl")
    public void set(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    public void setBlockInstanceSearchWindow(int blockInstanceSearchWindow) {
        this._blockInstanceSearchWindow = blockInstanceSearchWindow;
    }

    public synchronized void handleServiceDelivery(ServiceDelivery serviceDelivery, AbstractServiceDeliveryStructure deliveryForModule, ESiriModuleType moduleType, SiriEndpointDetails endpointDetails) {
        switch (moduleType) {
            case VEHICLE_MONITORING: {
                this.handleVehicleMonitoring(serviceDelivery, (VehicleMonitoringDeliveryStructure)deliveryForModule, endpointDetails);
                break;
            }
            case SITUATION_EXCHANGE: {
                this.handleSituationExchange(serviceDelivery, (SituationExchangeDeliveryStructure)deliveryForModule, endpointDetails);
            }
        }
    }

    private void handleVehicleMonitoring(ServiceDelivery serviceDelivery, VehicleMonitoringDeliveryStructure deliveryForModule, SiriEndpointDetails endpointDetails) {
        ArrayList<VehicleLocationRecord> records = new ArrayList<VehicleLocationRecord>();
        Date now = new Date();
        long timeFrom = now.getTime() - (long)(this._blockInstanceSearchWindow * 60 * 1000);
        long timeTo = now.getTime() + (long)(this._blockInstanceSearchWindow * 60 * 1000);
        for (VehicleActivityStructure vehicleActivity : deliveryForModule.getVehicleActivity()) {
            List<BlockInstance> instances;
            TripEntry trip;
            VehicleRefStructure vehicleRef;
            VehicleActivityStructure.MonitoredVehicleJourney mvj;
            Duration delay;
            Date time = vehicleActivity.getRecordedAtTime();
            if (time == null) {
                time = now;
            }
            if ((delay = (mvj = vehicleActivity.getMonitoredVehicleJourney()).getDelay()) == null || (vehicleRef = mvj.getVehicleRef()) == null || vehicleRef.getValue() == null) continue;
            BlockEntry block = this.getBlockForMonitoredVehicleJourney(mvj, endpointDetails);
            if (block == null && (trip = this.getTripForMonitoredVehicleJourney(mvj, endpointDetails)) != null) {
                block = trip.getBlock();
            }
            if (block == null || (instances = this._blockCalendarService.getActiveBlocks(block.getId(), timeFrom, timeTo)).size() != 1) continue;
            BlockInstance instance = instances.get(0);
            VehicleLocationRecord r = new VehicleLocationRecord();
            r.setTimeOfRecord(time.getTime());
            r.setServiceDate(instance.getServiceDate());
            r.setBlockId(block.getId());
            String agencyId = block.getId().getAgencyId();
            r.setVehicleId(new AgencyAndId(agencyId, vehicleRef.getValue()));
            r.setScheduleDeviation((double)(delay.getTimeInMillis(now) / 1000L));
            LocationStructure location = mvj.getVehicleLocation();
            if (location != null) {
                r.setCurrentLocationLat(location.getLatitude().doubleValue());
                r.setCurrentLocationLon(location.getLongitude().doubleValue());
            }
            records.add(r);
        }
        if (!records.isEmpty()) {
            this._vehicleLocationListener.handleVehicleLocationRecords(records);
        }
    }

    private BlockEntry getBlockForMonitoredVehicleJourney(VehicleActivityStructure.MonitoredVehicleJourney mvj, SiriEndpointDetails endpointDetails) {
        BlockRefStructure blockRef = mvj.getBlockRef();
        if (blockRef == null || blockRef.getValue() == null) {
            return null;
        }
        for (String agencyId : endpointDetails.getDefaultAgencyIds()) {
            AgencyAndId blockId = new AgencyAndId(agencyId, blockRef.getValue());
            BlockEntry blockEntry = this._transitGraphDao.getBlockEntryForId(blockId);
            if (blockEntry == null) continue;
            return blockEntry;
        }
        try {
            AgencyAndId blockId = AgencyAndId.convertFromString((String)blockRef.getValue());
            return this._transitGraphDao.getBlockEntryForId(blockId);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private TripEntry getTripForMonitoredVehicleJourney(VehicleActivityStructure.MonitoredVehicleJourney mvj, SiriEndpointDetails endpointDetails) {
        FramedVehicleJourneyRefStructure fvjRef = mvj.getFramedVehicleJourneyRef();
        if (fvjRef == null || fvjRef.getDatedVehicleJourneyRef() == null) {
            return null;
        }
        for (String agencyId : endpointDetails.getDefaultAgencyIds()) {
            AgencyAndId tripId = new AgencyAndId(agencyId, fvjRef.getDatedVehicleJourneyRef());
            TripEntry tripEntry = this._transitGraphDao.getTripEntryForId(tripId);
            if (tripEntry == null) continue;
            return tripEntry;
        }
        try {
            AgencyAndId tripId = AgencyAndId.convertFromString((String)fvjRef.getDatedVehicleJourneyRef());
            return this._transitGraphDao.getTripEntryForId(tripId);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private void handleSituationExchange(ServiceDelivery serviceDelivery, SituationExchangeDeliveryStructure sxDelivery, SiriEndpointDetails endpointDetails) {
        SituationExchangeDeliveryStructure.Situations situations = sxDelivery.getSituations();
        if (situations == null) {
            return;
        }
        ArrayList<ServiceAlertRecord> serviceAlertsToUpdate = new ArrayList<ServiceAlertRecord>();
        ArrayList<AgencyAndId> serviceAlertIdsToRemove = new ArrayList<AgencyAndId>();
        for (PtSituationElementStructure ptSituation : situations.getPtSituationElement()) {
            boolean remove;
            ServiceAlertRecord serviceAlert = this.getPtSituationAsServiceAlert(ptSituation, endpointDetails);
            WorkflowStatusEnumeration progress = ptSituation.getProgress();
            boolean bl = remove = progress != null && (progress == WorkflowStatusEnumeration.CLOSING || progress == WorkflowStatusEnumeration.CLOSED);
            if (remove) {
                AgencyAndId situationId = ServiceAlertLibrary.agencyAndId((String)serviceAlert.getAgencyId(), (String)serviceAlert.getServiceAlertId());
                serviceAlertIdsToRemove.add(situationId);
                continue;
            }
            serviceAlertsToUpdate.add(serviceAlert);
        }
        String defaultAgencyId = null;
        if (!CollectionsLibrary.isEmpty(endpointDetails.getDefaultAgencyIds())) {
            defaultAgencyId = endpointDetails.getDefaultAgencyIds().get(0);
        }
        for (ServiceAlertRecord serviceAlert : serviceAlertsToUpdate) {
            serviceAlert.setAgencyId(defaultAgencyId);
            this._serviceAlertsService.createOrUpdateServiceAlert(serviceAlert);
        }
        this._serviceAlertsService.removeServiceAlerts(serviceAlertIdsToRemove);
    }

    private ServiceAlertRecord getPtSituationAsServiceAlert(PtSituationElementStructure ptSituation, SiriEndpointDetails endpointDetails) {
        ServiceAlertRecord serviceAlert = new ServiceAlertRecord();
        EntryQualifierStructure serviceAlertNumber = ptSituation.getSituationNumber();
        String situationId = serviceAlertNumber.getValue();
        if (!endpointDetails.getDefaultAgencyIds().isEmpty()) {
            String agencyId = endpointDetails.getDefaultAgencyIds().get(0);
            serviceAlert.setServiceAlertId(situationId);
            serviceAlert.setAgencyId(agencyId);
        } else {
            AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)situationId);
            serviceAlert.setAgencyId(ServiceAlertLibrary.id((AgencyAndId)id).getAgencyId());
            serviceAlert.setServiceAlertId(situationId);
        }
        this.handleDescriptions(ptSituation, serviceAlert);
        this.handleOtherFields(ptSituation, serviceAlert);
        this.handlReasons(ptSituation, serviceAlert);
        this.handleAffects(ptSituation, serviceAlert);
        this.handleConsequences(ptSituation, serviceAlert);
        return serviceAlert;
    }

    private void handleDescriptions(PtSituationElementStructure ptSituation, ServiceAlertRecord serviceAlert) {
        ServiceAlertLocalizedString summary = this.translation(ptSituation.getSummary());
        if (serviceAlert.getSummaries() == null) {
            serviceAlert.setSummaries(new HashSet());
        }
        if (summary != null) {
            serviceAlert.getSummaries().add(summary);
        }
        ServiceAlertLocalizedString description = this.translation(ptSituation.getDescription());
        if (serviceAlert.getDescriptions() == null) {
            serviceAlert.setDescriptions(new HashSet());
        }
        if (description != null) {
            serviceAlert.getDescriptions().add(description);
        }
    }

    private void handleOtherFields(PtSituationElementStructure ptSituation, ServiceAlertRecord serviceAlert) {
        SeverityEnumeration severity = ptSituation.getSeverity();
        if (severity != null) {
            ESeverity severityEnum = ESeverity.valueOfTpegCode((String)severity.value());
            serviceAlert.setSeverity(severityEnum);
        }
        if (ptSituation.getPublicationWindow() != null) {
            HalfOpenTimestampRangeStructure window = ptSituation.getPublicationWindow();
            ServiceAlertTimeRange range = new ServiceAlertTimeRange();
            if (window.getStartTime() != null && window.getStartTime().getTime() > 0L) {
                range.setFromValue(Long.valueOf(window.getStartTime().getTime()));
            }
            if (window.getEndTime() != null && window.getEndTime().getTime() > 0L) {
                range.setToValue(Long.valueOf(window.getEndTime().getTime()));
            }
            if (serviceAlert.getActiveWindows() == null) {
                serviceAlert.setActiveWindows(new HashSet());
            }
            if (range.getFromValue() != null || range.getToValue() != null) {
                serviceAlert.getActiveWindows().add(range);
            }
        }
    }

    private void handlReasons(PtSituationElementStructure ptSituation, ServiceAlertRecord serviceAlert) {
        ECause cause = this.getReasonAsCause(ptSituation);
        if (cause != null) {
            serviceAlert.setCause(cause);
        }
    }

    private ECause getReasonAsCause(PtSituationElementStructure ptSituation) {
        if (ptSituation.getEnvironmentReason() != null) {
            return ECause.WEATHER;
        }
        if (ptSituation.getEquipmentReason() != null) {
            switch (ptSituation.getEquipmentReason()) {
                case CONSTRUCTION_WORK: {
                    return ECause.CONSTRUCTION;
                }
                case CLOSED_FOR_MAINTENANCE: 
                case MAINTENANCE_WORK: 
                case EMERGENCY_ENGINEERING_WORK: 
                case LATE_FINISH_TO_ENGINEERING_WORK: 
                case REPAIR_WORK: {
                    return ECause.MAINTENANCE;
                }
            }
            return ECause.TECHNICAL_PROBLEM;
        }
        if (ptSituation.getPersonnelReason() != null) {
            switch (ptSituation.getPersonnelReason()) {
                case INDUSTRIAL_ACTION: 
                case UNOFFICIAL_INDUSTRIAL_ACTION: {
                    return ECause.STRIKE;
                }
            }
            return ECause.OTHER_CAUSE;
        }
        if (ptSituation.getMiscellaneousReason() != null) {
            switch (ptSituation.getMiscellaneousReason()) {
                case ACCIDENT: 
                case COLLISION: {
                    return ECause.ACCIDENT;
                }
                case DEMONSTRATION: 
                case MARCH: {
                    return ECause.DEMONSTRATION;
                }
                case PERSON_ILL_ON_VEHICLE: 
                case FATALITY: {
                    return ECause.MEDICAL_EMERGENCY;
                }
                case POLICE_REQUEST: 
                case BOMB_ALERT: 
                case CIVIL_EMERGENCY: 
                case EMERGENCY_SERVICES: 
                case EMERGENCY_SERVICES_CALL: {
                    return ECause.POLICE_ACTIVITY;
                }
            }
        }
        return null;
    }

    protected void handleAffects(PtSituationElementStructure ptSituation, ServiceAlertRecord serviceAlert) {
        OneBusAwayAffects obaAffects;
        OneBusAwayAffectsStructure.Applications applications;
        Object ext;
        ExtensionsStructure extension;
        AffectsScopeStructure.VehicleJourneys vjs;
        AffectsScopeStructure.StopPoints stopPoints;
        ServiceAlertsSituationAffectsClause affects;
        AffectsScopeStructure affectsStructure = ptSituation.getAffects();
        if (affectsStructure == null) {
            return;
        }
        AffectsScopeStructure.Operators operators = affectsStructure.getOperators();
        if (operators != null && !CollectionsLibrary.isEmpty((Collection)operators.getAffectedOperator())) {
            for (AffectedOperatorStructure operator : operators.getAffectedOperator()) {
                OperatorRefStructure operatorRef = operator.getOperatorRef();
                if (operatorRef == null || operatorRef.getValue() == null) continue;
                String agencyId = operatorRef.getValue();
                affects = new ServiceAlertsSituationAffectsClause();
                affects.setAgencyId(agencyId);
                if (serviceAlert.getAllAffects() == null) {
                    serviceAlert.setAllAffects(new HashSet());
                }
                serviceAlert.getAllAffects().add(affects);
            }
        }
        if ((stopPoints = affectsStructure.getStopPoints()) != null && !CollectionsLibrary.isEmpty((Collection)stopPoints.getAffectedStopPoint())) {
            for (AffectedStopPointStructure stopPoint : stopPoints.getAffectedStopPoint()) {
                StopPointRefStructure stopRef = stopPoint.getStopPointRef();
                if (stopRef == null || stopRef.getValue() == null) continue;
                AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)stopRef.getValue());
                ServiceAlertsSituationAffectsClause affects2 = new ServiceAlertsSituationAffectsClause();
                affects2.setStopId(stopId.getId());
                affects2.setAgencyId(stopId.getAgencyId());
                if (serviceAlert.getAllAffects() == null) {
                    serviceAlert.setAllAffects(new HashSet());
                }
                serviceAlert.getAllAffects().add(affects2);
            }
        }
        if ((vjs = affectsStructure.getVehicleJourneys()) != null && !CollectionsLibrary.isEmpty((Collection)vjs.getAffectedVehicleJourney())) {
            for (AffectedVehicleJourneyStructure vj : vjs.getAffectedVehicleJourney()) {
                AgencyAndId tripId;
                boolean hasStopRefs;
                affects = new ServiceAlertsSituationAffectsClause();
                if (vj.getLineRef() != null) {
                    AgencyAndId routeId = AgencyAndIdLibrary.convertFromString((String)vj.getLineRef().getValue());
                    affects.setRouteId(routeId.getId());
                    affects.setAgencyId(routeId.getAgencyId());
                }
                if (vj.getDirectionRef() != null) {
                    affects.setDirectionId(vj.getDirectionRef().getValue());
                }
                List tripRefs = vj.getVehicleJourneyRef();
                AffectedVehicleJourneyStructure.Calls stopRefs = vj.getCalls();
                boolean hasTripRefs = !CollectionsLibrary.isEmpty((Collection)tripRefs);
                boolean bl = hasStopRefs = stopRefs != null && !CollectionsLibrary.isEmpty((Collection)stopRefs.getCall());
                if (serviceAlert.getAllAffects() == null) {
                    serviceAlert.setAllAffects(new HashSet());
                }
                if (!hasTripRefs && !hasStopRefs) {
                    if (affects.getRouteId() == null) continue;
                    serviceAlert.getAllAffects().add(affects);
                    continue;
                }
                if (hasTripRefs && hasStopRefs) {
                    for (VehicleJourneyRefStructure vjRef : vj.getVehicleJourneyRef()) {
                        tripId = AgencyAndIdLibrary.convertFromString((String)vjRef.getValue());
                        affects.setTripId(tripId.getId());
                        affects.setAgencyId(tripId.getAgencyId());
                        for (AffectedCallStructure call : stopRefs.getCall()) {
                            AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)call.getStopPointRef().getValue());
                            affects.setStopId(stopId.getId());
                            affects.setAgencyId(stopId.getAgencyId());
                            serviceAlert.getAllAffects().add(affects);
                        }
                    }
                    continue;
                }
                if (hasTripRefs) {
                    for (VehicleJourneyRefStructure vjRef : vj.getVehicleJourneyRef()) {
                        tripId = AgencyAndIdLibrary.convertFromString((String)vjRef.getValue());
                        affects.setTripId(tripId.getId());
                        affects.setAgencyId(tripId.getAgencyId());
                        serviceAlert.getAllAffects().add(affects);
                    }
                    continue;
                }
                for (AffectedCallStructure call : stopRefs.getCall()) {
                    AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)call.getStopPointRef().getValue());
                    affects.setStopId(stopId.getId());
                    affects.setAgencyId(stopId.getAgencyId());
                    serviceAlert.getAllAffects().add(affects);
                }
            }
        }
        if ((extension = affectsStructure.getExtensions()) != null && extension.getAny() != null && (ext = extension.getAny()) instanceof OneBusAwayAffects && (applications = (obaAffects = (OneBusAwayAffects)ext).getApplications()) != null && !CollectionsLibrary.isEmpty((Collection)applications.getAffectedApplication())) {
            List apps = applications.getAffectedApplication();
            if (serviceAlert.getAllAffects() == null) {
                serviceAlert.setAllAffects(new HashSet());
            }
            for (AffectedApplicationStructure sApp : apps) {
                ServiceAlertsSituationAffectsClause affects3 = new ServiceAlertsSituationAffectsClause();
                affects3.setApplicationId(sApp.getApiKey());
                serviceAlert.getAllAffects().add(affects3);
            }
        }
    }

    private void handleConsequences(PtSituationElementStructure ptSituation, ServiceAlertRecord serviceAlert) {
        PtConsequencesStructure consequences = ptSituation.getConsequences();
        if (consequences == null || consequences.getConsequence() == null) {
            return;
        }
        for (PtConsequenceStructure consequence : consequences.getConsequence()) {
            OneBusAwayConsequence obaConsequence;
            Object obj;
            ExtensionsStructure extensions;
            ServiceAlertSituationConsequenceClause builder = new ServiceAlertSituationConsequenceClause();
            if (consequence.getCondition() != null) {
                builder.setEffect(this.getConditionAsEffect(consequence.getCondition()));
            }
            if ((extensions = consequence.getExtensions()) != null && (obj = extensions.getAny()) instanceof OneBusAwayConsequence && (obaConsequence = (OneBusAwayConsequence)obj).getDiversionPath() != null) {
                builder.setDetourPath(obaConsequence.getDiversionPath());
            }
            if (serviceAlert.getConsequences() == null) {
                serviceAlert.setConsequences(new HashSet());
            }
            if (builder.getDetourPath() == null && builder.getEffect() == null) continue;
            serviceAlert.getConsequences().add(builder);
        }
    }

    private EEffect getConditionAsEffect(ServiceConditionEnumeration condition) {
        switch (condition) {
            case CANCELLED: 
            case NO_SERVICE: {
                return EEffect.NO_SERVICE;
            }
            case DELAYED: {
                return EEffect.SIGNIFICANT_DELAYS;
            }
            case DIVERTED: {
                return EEffect.DETOUR;
            }
            case ADDITIONAL_SERVICE: 
            case EXTENDED_SERVICE: 
            case SHUTTLE_SERVICE: 
            case SPECIAL_SERVICE: 
            case REPLACEMENT_SERVICE: {
                return EEffect.ADDITIONAL_SERVICE;
            }
            case DISRUPTED: 
            case INTERMITTENT_SERVICE: 
            case SHORT_FORMED_SERVICE: {
                return EEffect.REDUCED_SERVICE;
            }
            case ALTERED: 
            case ARRIVES_EARLY: 
            case REPLACEMENT_TRANSPORT: 
            case SPLITTING_TRAIN: {
                return EEffect.MODIFIED_SERVICE;
            }
            case ON_TIME: 
            case FULL_LENGTH_SERVICE: 
            case NORMAL_SERVICE: {
                return EEffect.OTHER_EFFECT;
            }
            case UNDEFINED_SERVICE_INFORMATION: 
            case UNKNOWN: {
                return EEffect.UNKNOWN_EFFECT;
            }
        }
        _log.warn("unknown condition: " + condition);
        return EEffect.UNKNOWN_EFFECT;
    }

    private ServiceAlertLocalizedString translation(DefaultedTextStructure text) {
        if (text == null) {
            return null;
        }
        String value = text.getValue();
        if (value == null) {
            return null;
        }
        ServiceAlertLocalizedString translation = new ServiceAlertLocalizedString();
        translation.setValue(value);
        if (text.getLang() != null) {
            translation.setLanguage(text.getLang());
        }
        return translation;
    }
}

