/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.orbcad;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehiclePhase;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.transit_data_federation.impl.realtime.orbcad.OrbcadRecord;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocationService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(value="org.onebusaway.transit_data_federation.impl.realtime.orbcad:name=OrbcadRecordFtpSource")
public abstract class AbstractOrbcadRecordSource
implements MonitoredDataSource {
    private static final int REFRESH_INTERVAL_IN_SECONDS = 30;
    private static Logger _log = LoggerFactory.getLogger(AbstractOrbcadRecordSource.class);
    protected ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private List<VehicleLocationRecord> _records = new ArrayList<VehicleLocationRecord>();
    private int _refreshInterval = 30;
    private long _lastRefresh = 0L;
    private VehicleLocationListener _vehicleLocationListener;
    private Map<String, List<String>> _blockIdMapping = new HashMap<String, List<String>>();
    private BlockCalendarService _blockCalendarService;
    private ScheduledBlockLocationService _scheduledBlockLocationService;
    protected List<String> _agencyIds;
    private File _blockIdMappingFile;
    private double _motionThreshold = 30.0;
    private Map<AgencyAndId, VehicleLocationRecord> _lastRecordByVehicleId = new HashMap<AgencyAndId, VehicleLocationRecord>();
    private transient int _recordsTotal = 0;
    private transient int _recordsWithoutScheduleDeviation = 0;
    private transient int _recordsWithoutBlockId = 0;
    private transient int _recordsWithoutBlockIdInGraph = 0;
    private transient int _recordsWithoutServiceDate = 0;
    private transient int _recordsValid = 0;
    private transient long _latestUpdate = 0L;
    private MonitoredResult _monitoredResult;
    private MonitoredResult _currentResult = new MonitoredResult();
    private String _feedId = null;

    public void setRefreshInterval(int refreshIntervalInSeconds) {
        this._refreshInterval = refreshIntervalInSeconds;
    }

    public void setAgencyId(String agencyId) {
        this._agencyIds = Arrays.asList(agencyId);
    }

    public void setAgencyIds(List<String> agencyIds) {
        this._agencyIds = agencyIds;
    }

    public List<String> getAgencyIds() {
        return this._agencyIds;
    }

    public void setBlockIdMappingFile(File blockIdMappingFile) {
        this._blockIdMappingFile = blockIdMappingFile;
    }

    @Autowired
    public void setVehicleLocationListener(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setScheduledBlockLocationService(ScheduledBlockLocationService scheduledBlockLocationService) {
        this._scheduledBlockLocationService = scheduledBlockLocationService;
    }

    @Override
    public MonitoredResult getMonitoredResult() {
        return this._monitoredResult;
    }

    @Override
    public String getFeedId() {
        return this._feedId;
    }

    public void setFeedId(String id) {
        this._feedId = id;
    }

    @ManagedAttribute
    public int getRecordsTotal() {
        return this._recordsTotal;
    }

    @ManagedAttribute
    public int getRecordWithoutScheduleDeviation() {
        return this._recordsWithoutScheduleDeviation;
    }

    @ManagedAttribute
    public int getRecordsWithoutBlockId() {
        return this._recordsWithoutBlockId;
    }

    @ManagedAttribute
    public int getRecordsWithoutBlockIdInGraph() {
        return this._recordsWithoutBlockIdInGraph;
    }

    @ManagedAttribute
    public int getRecordsWithoutServiceDate() {
        return this._recordsWithoutServiceDate;
    }

    @ManagedAttribute
    public int getRecordsValid() {
        return this._recordsValid;
    }

    protected void start() throws SocketException, IOException {
        this.loadBlockIdMapping();
        this.setup();
        this._executor.scheduleAtFixedRate(new AvlRefreshTask(), 5L, this._refreshInterval / 2, TimeUnit.SECONDS);
    }

    protected void stop() throws IOException {
        this._executor.shutdown();
    }

    protected void setup() {
    }

    protected abstract void handleRefresh() throws IOException;

    private void loadBlockIdMapping() throws FileNotFoundException, IOException {
        try {
            if (this._blockIdMappingFile == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(this._blockIdMappingFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                int index = line.indexOf(44);
                String from = line.substring(0, index);
                String to = line.substring(index + 1);
                List<String> toValues = this._blockIdMapping.get(from);
                if (toValues == null) {
                    toValues = new ArrayList<String>();
                    this._blockIdMapping.put(from, toValues);
                }
                toValues.add(to);
            }
            reader.close();
        }
        catch (Throwable ex) {
            _log.warn("error loading block id mapping from file " + this._blockIdMapping, ex);
        }
    }

    private BlockInstance getBlockInstanceForRecord(OrbcadRecord record) {
        long recordTime = record.getTime() * 1000L;
        long timeFrom = recordTime - 1800000L;
        long timeTo = recordTime + 1800000L;
        List<AgencyAndId> blockIds = this.getBlockIdsForRecord(record);
        ArrayList<BlockInstance> allInstances = new ArrayList<BlockInstance>();
        for (AgencyAndId blockId : blockIds) {
            List<BlockInstance> instances = this._blockCalendarService.getActiveBlocks(blockId, timeFrom, timeTo);
            allInstances.addAll(instances);
        }
        if (allInstances.size() != 1) {
            return null;
        }
        return (BlockInstance)allInstances.get(0);
    }

    private List<AgencyAndId> getBlockIdsForRecord(OrbcadRecord record) {
        ArrayList<AgencyAndId> blockIds = new ArrayList<AgencyAndId>();
        String rawBlockId = Integer.toString(record.getBlock());
        List<String> rawBlockIds = this._blockIdMapping.get(rawBlockId);
        if (rawBlockIds == null) {
            rawBlockIds = Arrays.asList(rawBlockId);
        }
        for (String agencyId : this._agencyIds) {
            for (String rawId : rawBlockIds) {
                blockIds.add(new AgencyAndId(agencyId, rawId));
            }
        }
        return blockIds;
    }

    protected class RecordHandler
    implements EntityHandler {
        protected RecordHandler() {
        }

        public void handleEntity(Object bean) {
            int effectiveScheduleTime;
            int adjustedScheduleTime;
            ScheduledBlockLocation location;
            OrbcadRecord record = (OrbcadRecord)bean;
            ++AbstractOrbcadRecordSource.this._recordsTotal;
            AbstractOrbcadRecordSource.this._currentResult.addRecordTotal();
            if (!record.hasScheduleDeviation()) {
                ++AbstractOrbcadRecordSource.this._recordsWithoutScheduleDeviation;
                return;
            }
            if (record.getBlock() == 0) {
                ++AbstractOrbcadRecordSource.this._recordsWithoutBlockId;
                return;
            }
            BlockInstance blockInstance = AbstractOrbcadRecordSource.this.getBlockInstanceForRecord(record);
            if (blockInstance == null) {
                ++AbstractOrbcadRecordSource.this._recordsWithoutServiceDate;
                return;
            }
            BlockConfigurationEntry blockConfig = blockInstance.getBlock();
            BlockEntry block = blockConfig.getBlock();
            AgencyAndId blockId = block.getId();
            VehicleLocationRecord message = new VehicleLocationRecord();
            message.setBlockId(blockId);
            message.setServiceDate(blockInstance.getServiceDate());
            message.setTimeOfRecord(record.getTime() * 1000L);
            if (message.getTimeOfRecord() > AbstractOrbcadRecordSource.this._latestUpdate) {
                AbstractOrbcadRecordSource.this._latestUpdate = message.getTimeOfRecord();
            }
            message.setTimeOfLocationUpdate(message.getTimeOfRecord());
            message.setScheduleDeviation((double)(-record.getScheduleDeviation()));
            message.setVehicleId(new AgencyAndId(blockId.getAgencyId(), Integer.toString(record.getVehicleId())));
            if (record.hasLat() && record.hasLon()) {
                message.setCurrentLocationLat(record.getLat());
                message.setCurrentLocationLon(record.getLon());
                AbstractOrbcadRecordSource.this._currentResult.addLatLon(record.getLat(), record.getLon());
            }
            if ((location = AbstractOrbcadRecordSource.this._scheduledBlockLocationService.getScheduledBlockLocationFromScheduledTime(blockConfig, adjustedScheduleTime = (effectiveScheduleTime = (int)(record.getTime() - blockInstance.getServiceDate() / 1000L)) - record.getScheduleDeviation())) != null) {
                message.setDistanceAlongBlock(location.getDistanceAlongBlock());
                BlockTripEntry activeTrip = location.getActiveTrip();
                if (activeTrip != null) {
                    message.setTripId(activeTrip.getTrip().getId());
                    this.addTimepointRecords(message, activeTrip, blockInstance.getServiceDate());
                    AbstractOrbcadRecordSource.this._currentResult.addMatchedTripId(activeTrip.getTrip().getId().toString());
                } else {
                    AbstractOrbcadRecordSource.this._currentResult.addUnmatchedTripId(blockId.toString());
                }
                if (location.getDistanceAlongBlock() == 0.0) {
                    VehicleLocationRecord lastRecord = AbstractOrbcadRecordSource.this._lastRecordByVehicleId.get(message.getVehicleId());
                    boolean inMotion = true;
                    if (lastRecord != null && lastRecord.isCurrentLocationSet() && message.isCurrentLocationSet()) {
                        double d = SphericalGeometryLibrary.distance((double)lastRecord.getCurrentLocationLat(), (double)lastRecord.getCurrentLocationLon(), (double)message.getCurrentLocationLat(), (double)message.getCurrentLocationLon());
                        boolean bl = inMotion = d > AbstractOrbcadRecordSource.this._motionThreshold;
                    }
                    if (inMotion) {
                        message.setPhase(EVehiclePhase.DEADHEAD_BEFORE);
                    } else {
                        message.setPhase(EVehiclePhase.LAYOVER_BEFORE);
                    }
                }
            }
            AbstractOrbcadRecordSource.this._records.add(message);
            ++AbstractOrbcadRecordSource.this._recordsValid;
            AbstractOrbcadRecordSource.this._lastRecordByVehicleId.put(message.getVehicleId(), message);
        }

        private void addTimepointRecords(VehicleLocationRecord message, BlockTripEntry activeTrip, long serviceDate) {
            if (activeTrip == null) {
                return;
            }
            if (activeTrip.getStopTimes() == null) {
                return;
            }
            List<BlockStopTimeEntry> stopTimes = activeTrip.getStopTimes();
            for (BlockStopTimeEntry stopTime : stopTimes) {
                long scheduleTime = serviceDate + (long)(stopTime.getStopTime().getDepartureTime() * 1000);
                long now = message.getTimeOfRecord();
                long delay = (long)message.getScheduleDeviation();
                long predictedTime = delay * 1000L + scheduleTime;
                if (predictedTime < now) continue;
                TimepointPredictionRecord tpr = new TimepointPredictionRecord();
                tpr.setTimepointId(stopTime.getStopTime().getStop().getId());
                tpr.setTripId(activeTrip.getTrip().getId());
                tpr.setTimepointScheduledTime(scheduleTime);
                tpr.setTimepointPredictedArrivalTime(predictedTime);
                tpr.setTimepointPredictedDepartureTime(predictedTime);
                if (message.getTimepointPredictions() == null) {
                    message.setTimepointPredictions(new ArrayList());
                }
                message.getTimepointPredictions().add(tpr);
            }
        }
    }

    protected class AvlRefreshTask
    implements Runnable {
        protected AvlRefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                _log.debug("checking if we need to refresh");
                AvlRefreshTask avlRefreshTask = this;
                synchronized (avlRefreshTask) {
                    long t = SystemTime.currentTimeMillis();
                    if (AbstractOrbcadRecordSource.this._lastRefresh + (long)(AbstractOrbcadRecordSource.this._refreshInterval * 1000) > t) {
                        return;
                    }
                    AbstractOrbcadRecordSource.this._lastRefresh = t;
                }
                _log.debug("refresh requested");
                this.preHandleRefresh();
                AbstractOrbcadRecordSource.this.handleRefresh();
                AbstractOrbcadRecordSource.this._currentResult.setLastUpdate(AbstractOrbcadRecordSource.this._latestUpdate);
                this.postHandleRefresh();
                try {
                    AbstractOrbcadRecordSource.this._vehicleLocationListener.handleVehicleLocationRecords(AbstractOrbcadRecordSource.this._records);
                }
                catch (Throwable ex) {
                    _log.warn("error passing schedule adherence records to listener", ex);
                }
                AbstractOrbcadRecordSource.this._records.clear();
                _log.debug("refresh complete");
            }
            catch (Throwable ex) {
                _log.warn("error refreshing data", ex);
            }
        }

        private void preHandleRefresh() {
            AbstractOrbcadRecordSource.this._currentResult = new MonitoredResult();
            AbstractOrbcadRecordSource.this._currentResult.setAgencyIds(AbstractOrbcadRecordSource.this._agencyIds);
        }

        private void postHandleRefresh() {
            _log.info("Agencies " + AbstractOrbcadRecordSource.this._agencyIds + " have active vehicles=" + AbstractOrbcadRecordSource.this._currentResult.getMatchedTripIds().size() + " for updates=" + AbstractOrbcadRecordSource.this._currentResult.getRecordsTotal() + "  with most recent timestamp " + new Date(AbstractOrbcadRecordSource.this._latestUpdate));
            if (AbstractOrbcadRecordSource.this._currentResult.getRecordsTotal() > 0) {
                AbstractOrbcadRecordSource.this._monitoredResult = AbstractOrbcadRecordSource.this._currentResult;
            }
        }
    }
}

