/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.history;

import java.io.Serializable;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.onebusaway.gtfs.model.AgencyAndId;

@Entity
@Table(name="oba_schedule_deviation_history")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
public class ScheduleDeviationHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    @AttributeOverrides(value={@AttributeOverride(name="agencyId", column=@Column(name="trip_agencyId", length=50)), @AttributeOverride(name="id", column=@Column(name="trip_id"))})
    private final AgencyAndId tripId;
    private double[] scheduleTimes;
    private final double[][] scheduleDeviations;

    public ScheduleDeviationHistory(AgencyAndId tripId, double[] scheduleTimes, double[][] scheduleDeviations) {
        this.tripId = tripId;
        this.scheduleTimes = scheduleTimes;
        this.scheduleDeviations = scheduleDeviations;
    }

    ScheduleDeviationHistory() {
        this.tripId = null;
        this.scheduleTimes = null;
        this.scheduleDeviations = null;
    }

    public AgencyAndId getTripId() {
        return this.tripId;
    }

    public int getNumberOfSamples() {
        return this.scheduleDeviations.length;
    }

    public double[] getScheduleTimes() {
        return this.scheduleTimes;
    }

    public double[][] getScheduleDeviations() {
        return this.scheduleDeviations;
    }
}

