/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.history;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.Range;
import org.onebusaway.csv_entities.CsvEntityReader;
import org.onebusaway.csv_entities.DelimiterTokenizerStrategy;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.csv_entities.TokenizerStrategy;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.AgencyAndIdInstance;
import org.onebusaway.transit_data_federation.impl.realtime.history.BlockLocationArchiveRecord;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationHistoryService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BlockLocationHistoryServiceImpl
implements BlockLocationHistoryService {
    private TransitGraphDao _transitGraphDao;
    private File _dataDir;

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    public void setDataDir(File dataDir) {
        this._dataDir = dataDir;
    }

    @Override
    public Map<AgencyAndIdInstance, List<BlockLocationArchiveRecord>> getHistoryForTripId(AgencyAndId tripId) {
        TripEntry trip = this._transitGraphDao.getTripEntryForId(tripId);
        if (trip == null) {
            return null;
        }
        BlockEntry block = trip.getBlock();
        List<File> files = this.getFilesForBlockId(block.getId());
        CsvEntityReader reader = new CsvEntityReader();
        reader.setTokenizerStrategy((TokenizerStrategy)new DelimiterTokenizerStrategy("\t"));
        EntityHandlerImpl handler = new EntityHandlerImpl(tripId);
        reader.addEntityHandler((EntityHandler)handler);
        try {
            for (File file : files) {
                InputStream in = this.openFileForInput(file);
                reader.readEntities(BlockLocationArchiveRecord.class, in);
                in.close();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        Map<AgencyAndIdInstance, List<BlockLocationArchiveRecord>> recordsByInstance = handler.getRecordsByInstance();
        for (List<BlockLocationArchiveRecord> records : recordsByInstance.values()) {
            Collections.sort(records, new DistanceAlongBlockComparator());
        }
        return recordsByInstance;
    }

    private InputStream openFileForInput(File path) throws IOException {
        InputStream in = new FileInputStream(path);
        if (path.getName().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    private List<File> getFilesForBlockId(AgencyAndId blockId) {
        ArrayList<File> files = new ArrayList<File>();
        for (File dateDir : this._dataDir.listFiles()) {
            File dataFile = new File(dateDir, AgencyAndIdLibrary.convertToString((AgencyAndId)blockId) + ".gz");
            if (!dataFile.exists()) continue;
            files.add(dataFile);
        }
        return files;
    }

    private static class DistanceAlongBlockComparator
    implements Comparator<BlockLocationArchiveRecord> {
        private DistanceAlongBlockComparator() {
        }

        @Override
        public int compare(BlockLocationArchiveRecord o1, BlockLocationArchiveRecord o2) {
            return Double.compare(o1.getDistanceAlongBlock(), o2.getDistanceAlongBlock());
        }
    }

    private class EntityHandlerImpl
    implements EntityHandler {
        private Range _distanceAlongBlockRange = new Range();
        private Range _scheduleDeviationRange = new Range();
        private Map<AgencyAndIdInstance, List<BlockLocationArchiveRecord>> _recordsByInstance = new FactoryMap(new ArrayList());
        private final AgencyAndId _tripId;

        public EntityHandlerImpl(AgencyAndId tripId) {
            this._tripId = tripId;
        }

        public Range getDistanceAlongBlockRange() {
            return this._distanceAlongBlockRange;
        }

        public Range getScheduleDeviationRange() {
            return this._scheduleDeviationRange;
        }

        public Map<AgencyAndIdInstance, List<BlockLocationArchiveRecord>> getRecordsByInstance() {
            return this._recordsByInstance;
        }

        public void handleEntity(Object bean) {
            BlockLocationArchiveRecord record = (BlockLocationArchiveRecord)bean;
            if (!this._tripId.equals((Object)record.getTripId())) {
                return;
            }
            AgencyAndIdInstance instance = new AgencyAndIdInstance(record.getTripId(), record.getServiceDate());
            this._recordsByInstance.get(instance).add(record);
            this._distanceAlongBlockRange.addValue(record.getDistanceAlongBlock().doubleValue());
            this._scheduleDeviationRange.addValue(record.getScheduleDeviation().doubleValue());
        }
    }
}

