/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import com.google.transit.realtime.GtfsRealtimeNYCT;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedStopInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.NyctTripService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NyctTripServiceImpl
implements NyctTripService {
    private static Logger _log = LoggerFactory.getLogger(NyctTripServiceImpl.class);
    private static final String DEFAULT_AGENCY_ID = "MTASBWY";
    private String _defaultAgencyId = "MTASBWY";
    private static final Pattern _rtTripPattern = Pattern.compile("([A-Z0-9]+_)?(?<originDepartureTime>[0-9-]{6})_?(?<route>[A-Z0-9]+)\\.+(?<direction>[NS]?)(?<network>[A-Z0-9 -]*)$");

    @Override
    public AddedTripInfo parse(GtfsRealtime.TripUpdate tu, GtfsRealtimeNYCT.NyctTripDescriptor nyctTripDescriptor, long currentTime) {
        String tripId = tu.getTrip().getTripId();
        Matcher matcher = _rtTripPattern.matcher(tripId);
        if (matcher.find()) {
            String networkId;
            String directionId;
            int originDepartureTime = Integer.parseInt(matcher.group("originDepartureTime"), 10) * 60 / 100;
            String pathId = StringUtils.rightPad((String)matcher.group("route"), (int)3, (char)'.') + matcher.group("direction");
            String routeId = this.routeFromTripUpdate(tu);
            if (routeId == null) {
                routeId = matcher.group("route");
            }
            if ((directionId = matcher.group("direction")).length() == 0) {
                directionId = null;
            }
            if ((networkId = matcher.group("network")).length() == 0) {
                networkId = null;
            }
            AddedTripInfo addedTrip = new AddedTripInfo();
            addedTrip.setScheduleRelationshipValue("ADDED");
            addedTrip.setAgencyId(this.getDefaultAgency());
            addedTrip.setTripStartTime(originDepartureTime);
            addedTrip.setServiceDate(this.parseTimeFromUpdate(tu, currentTime));
            addedTrip.setRouteId(routeId);
            addedTrip.setTripId(tripId);
            addedTrip.setDirectionId(directionId);
            if (nyctTripDescriptor.hasTrainId()) {
                addedTrip.setVehicleId(nyctTripDescriptor.getTrainId());
            }
            int index = -1;
            for (GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate : tu.getStopTimeUpdateList()) {
                ++index;
                AddedStopInfo stopInfo = new AddedStopInfo();
                if (stopTimeUpdate.hasStopId()) {
                    stopInfo.setStopId(stopTimeUpdate.getStopId());
                }
                if (stopTimeUpdate.hasArrival() && stopTimeUpdate.getArrival().getTime() > 0L) {
                    stopInfo.setArrivalTime(stopTimeUpdate.getArrival().getTime() * 1000L);
                    if (index == tu.getStopTimeUpdateCount() - 1) {
                        stopInfo.setDepartureTime(stopTimeUpdate.getArrival().getTime() * 1000L);
                    }
                }
                if (stopTimeUpdate.hasDeparture() && stopTimeUpdate.getDeparture().getTime() > 0L) {
                    stopInfo.setDepartureTime(stopTimeUpdate.getDeparture().getTime() * 1000L);
                }
                if (stopTimeUpdate.hasExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate)) {
                    GtfsRealtimeNYCT.NyctStopTimeUpdate stopTimeUpdateExtension = (GtfsRealtimeNYCT.NyctStopTimeUpdate)stopTimeUpdate.getExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate);
                    if (stopTimeUpdateExtension.hasActualTrack()) {
                        stopInfo.setActualTrack(stopTimeUpdateExtension.getActualTrack());
                    }
                    if (stopTimeUpdateExtension.hasScheduledTrack()) {
                        stopInfo.setScheduledTrack(stopTimeUpdateExtension.getScheduledTrack());
                    }
                }
                if (stopInfo.getArrivalTime() <= 0L && stopInfo.getDepartureTime() <= 0L) {
                    _log.error("invalid stop for update {}", (Object)stopTimeUpdate);
                    continue;
                }
                addedTrip.addStopTime(stopInfo);
            }
            return addedTrip;
        }
        return null;
    }

    private long parseTimeFromUpdate(GtfsRealtime.TripUpdate tu, long currentTime) {
        String startDate = tu.getTrip().getStartDate();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        try {
            return sdf.parse(startDate).getTime();
        }
        catch (ParseException e) {
            _log.error("invalid date {}", (Object)startDate);
            return AddedTripInfo.getStartOfDay(new Date(currentTime)).getTime();
        }
    }

    private String routeFromTripUpdate(GtfsRealtime.TripUpdate tu) {
        if (tu.hasTrip() && tu.getTrip().hasRouteId()) {
            return tu.getTrip().getRouteId();
        }
        return null;
    }

    private String getDefaultAgency() {
        return this._defaultAgencyId;
    }

    public void setDefaultAgencyId(String defaultAgencyId) {
        this._defaultAgencyId = defaultAgencyId;
    }
}

