/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.common.collect.ArrayListMultimap;
import com.google.transit.realtime.GtfsRealtime;
import com.google.transit.realtime.GtfsRealtimeCrowding;
import com.google.transit.realtime.GtfsRealtimeMTARR;
import com.google.transit.realtime.GtfsRealtimeNYCT;
import com.google.transit.realtime.GtfsRealtimeOneBusAway;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.collections.Min;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.realtime.api.OccupancyStatus;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockDescriptor;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockServiceDate;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.CombinedTripUpdatesAndVehiclePosition;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeServiceSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.StopModificationStrategy;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicTripEntryImpl;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsRealtimeTripLibrary {
    private static final Logger _log = LoggerFactory.getLogger(GtfsRealtimeTripLibrary.class);
    private static Pattern _pattern = Pattern.compile("^(-{0,1}\\d+):(\\d{2}):(\\d{2})$");
    private GtfsRealtimeEntitySource _entitySource;
    private GtfsRealtimeServiceSource _serviceSource;
    private long _currentTime = 0L;
    private boolean _validateCurrentTime = true;
    private StopModificationStrategy _stopModificationStrategy = null;
    private boolean _scheduleAdherenceFromLocation = false;
    private boolean _useLabelAsVehicleId = false;
    private boolean _filterUnassigned = false;

    public void setValidateCurrentTime(boolean validate) {
        this._validateCurrentTime = validate;
    }

    private boolean validateCurrentTime() {
        return this._validateCurrentTime;
    }

    public void setEntitySource(GtfsRealtimeEntitySource entitySource) {
        this._entitySource = entitySource;
    }

    public void setServiceSource(GtfsRealtimeServiceSource serviceSource) {
        this._serviceSource = serviceSource;
    }

    public long getCurrentTime() {
        return this._currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.setCurrentTime(currentTime, 0);
    }

    public void setCurrentTime(long currentTime, int originOffsetHours) {
        if (originOffsetHours != 0) {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date(currentTime));
            c.roll(10, originOffsetHours);
            this._currentTime = c.getTimeInMillis();
            _log.info("currentTime set to " + new Date(this._currentTime) + " from offset " + originOffsetHours);
        } else {
            this._currentTime = currentTime;
        }
    }

    public void setStopModificationStrategy(StopModificationStrategy strategy) {
        this._stopModificationStrategy = strategy;
    }

    public void setScheduleAdherenceFromLocation(boolean scheduleAdherenceFromLocation) {
        this._scheduleAdherenceFromLocation = scheduleAdherenceFromLocation;
    }

    public void setUseLabelAsVehicleId(boolean useLabelAsVehicleId) {
        this._useLabelAsVehicleId = useLabelAsVehicleId;
    }

    public void setFilterUnassigned(boolean flag) {
        this._filterUnassigned = flag;
    }

    public List<CombinedTripUpdatesAndVehiclePosition> groupTripUpdatesAndVehiclePositions(GtfsRealtime.FeedMessage tripUpdateMessage, GtfsRealtime.FeedMessage vehiclePositionsMessage) {
        return this.groupTripUpdatesAndVehiclePositions(null, tripUpdateMessage, vehiclePositionsMessage);
    }

    public List<CombinedTripUpdatesAndVehiclePosition> groupTripUpdatesAndVehiclePositions(MonitoredResult result, GtfsRealtime.FeedMessage tripUpdateMessage, GtfsRealtime.FeedMessage vehiclePositionsMessage) {
        try {
            return this.groupTripUpdatesAndVehiclePositionsInternal(result, tripUpdateMessage, vehiclePositionsMessage);
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return new ArrayList<CombinedTripUpdatesAndVehiclePosition>();
        }
    }

    public List<CombinedTripUpdatesAndVehiclePosition> groupTripUpdatesAndVehiclePositionsInternal(MonitoredResult result, GtfsRealtime.FeedMessage tripUpdateMessage, GtfsRealtime.FeedMessage vehiclePositionsMessage) {
        CombinedTripUpdatesAndVehiclePosition update;
        String vehicleId;
        BlockDescriptor bd;
        ArrayList<CombinedTripUpdatesAndVehiclePosition> updates = new ArrayList<CombinedTripUpdatesAndVehiclePosition>();
        ArrayListMultimap tripUpdatesByVehicleId = ArrayListMultimap.create();
        HashMap<String, GtfsRealtime.VehiclePosition> vehiclePositionsByVehicleId = new HashMap<String, GtfsRealtime.VehiclePosition>();
        AssignmentInfo assignmentInfo = this.getAssignmentInfo(tripUpdateMessage, vehiclePositionsMessage);
        ArrayListMultimap anonymousTripUpdatesByBlock = ArrayListMultimap.create();
        HashMap<BlockDescriptor, GtfsRealtime.VehiclePosition> anonymousVehiclePositionsByBlock = new HashMap<BlockDescriptor, GtfsRealtime.VehiclePosition>();
        HashSet<BlockDescriptor> badAnonymousVehiclePositions = new HashSet<BlockDescriptor>();
        for (GtfsRealtime.FeedEntity feedEntity : tripUpdateMessage.getEntityList()) {
            TripEntry tripEntry;
            long time;
            if (!feedEntity.hasTripUpdate()) continue;
            GtfsRealtime.TripUpdate tu = feedEntity.getTripUpdate();
            bd = null;
            if (tu.hasTrip() && "DUPLICATED".equals(tu.getTrip().getScheduleRelationship().toString())) {
                AddedTripInfo addedTripInfo = this._serviceSource.getDuplicatedTripService().handleDuplicatedDescriptor(tu);
                bd = this._serviceSource.getDynamicTripBuilder().createBlockDescriptor(addedTripInfo, this.getCurrentTime());
                if (bd == null) continue;
                anonymousTripUpdatesByBlock.put((Object)bd, (Object)tu);
                continue;
            }
            if (this.getVehicleId(tu) != null) {
                String vehicleId2 = this.getVehicleId(tu);
                tripUpdatesByVehicleId.put((Object)vehicleId2, (Object)this.addStartDateTime(tu));
                continue;
            }
            GtfsRealtime.TripDescriptor td = tu.getTrip();
            long l = time = tu.hasTimestamp() ? this.ensureMillis(tu.getTimestamp()) : this.currentTime();
            if (bd == null) {
                bd = this.getTripDescriptorAsBlockDescriptor(result, td, time, null);
            }
            if (bd == null) {
                bd = this.handleDynamicTripUpdate(tu);
                if (bd == null) continue;
                if (bd.getVehicleId() != null) {
                    tripUpdatesByVehicleId.put((Object)bd.getVehicleId(), (Object)tu);
                } else {
                    anonymousTripUpdatesByBlock.put((Object)bd, (Object)tu);
                }
            }
            if ((tripEntry = this._entitySource.getTrip(td.getTripId())) != null && tripEntry.getBlock() != null) {
                String blockId = tripEntry.getBlock().getId().toString();
                if (assignmentInfo.preferredVehicleByBlockId.containsKey(blockId)) {
                    String preferredVehicleId = assignmentInfo.preferredVehicleByBlockId.get(blockId);
                    _log.debug("adding anonymous trip update {} into vehicle {}", (Object)td.getTripId(), (Object)preferredVehicleId);
                    tripUpdatesByVehicleId.put((Object)preferredVehicleId, (Object)tu);
                    continue;
                }
                anonymousTripUpdatesByBlock.put((Object)bd, (Object)tu);
                continue;
            }
            anonymousTripUpdatesByBlock.put((Object)bd, (Object)tu);
        }
        for (GtfsRealtime.FeedEntity feedEntity : vehiclePositionsMessage.getEntityList()) {
            long time;
            GtfsRealtime.TripDescriptor td;
            BlockDescriptor bd2;
            if (!feedEntity.hasVehicle()) continue;
            GtfsRealtime.VehiclePosition vp = feedEntity.getVehicle();
            if (vp.hasVehicle() && vp.getVehicle().hasId()) {
                vehicleId = this.getVehicleId(vp);
                if (!vehiclePositionsByVehicleId.containsKey(vehicleId)) {
                    vehiclePositionsByVehicleId.put(vehicleId, vp);
                    continue;
                }
                _log.warn("Multiple updates for vehicle {}; taking newest.", (Object)vehicleId);
                GtfsRealtime.VehiclePosition otherUpdate = (GtfsRealtime.VehiclePosition)vehiclePositionsByVehicleId.get(vehicleId);
                long otherTimestamp = this.ensureMillis(otherUpdate.getTimestamp());
                if (this.ensureMillis(vp.getTimestamp()) <= otherTimestamp) continue;
                vehiclePositionsByVehicleId.put(vehicleId, vp);
                continue;
            }
            if (!vp.hasTrip() || (bd2 = this.getTripDescriptorAsBlockDescriptor(result, td = vp.getTrip(), time = vp.hasTimestamp() ? this.ensureMillis(vp.getTimestamp()) : this.currentTime(), null)) == null) continue;
            if (!anonymousVehiclePositionsByBlock.containsKey(bd2)) {
                anonymousVehiclePositionsByBlock.put(bd2, vp);
                continue;
            }
            _log.debug("Multiple anonymous VehiclePositions for trip {}; giving up.", (Object)td.getTripId());
            badAnonymousVehiclePositions.add(bd2);
        }
        for (BlockDescriptor blockDescriptor : badAnonymousVehiclePositions) {
            anonymousVehiclePositionsByBlock.remove(blockDescriptor);
        }
        for (Map.Entry entry : tripUpdatesByVehicleId.asMap().entrySet()) {
            update = new CombinedTripUpdatesAndVehiclePosition();
            vehicleId = (String)entry.getKey();
            Collection tripUpdates = (Collection)entry.getValue();
            GtfsRealtime.TripUpdate firstTrip = (GtfsRealtime.TripUpdate)tripUpdates.iterator().next();
            long time = firstTrip.hasTimestamp() ? this.ensureMillis(firstTrip.getTimestamp()) : this.currentTime();
            update.block = this.getTripDescriptorAsBlockDescriptor(result, firstTrip.getTrip(), time, vehicleId);
            if (this.isNycDynamicTrip(firstTrip)) {
                update.block = this.handleDynamicTripUpdate(firstTrip);
            }
            update.setTripUpdates(new ArrayList<GtfsRealtime.TripUpdate>(tripUpdates));
            if (vehiclePositionsByVehicleId.containsKey(vehicleId)) {
                update.vehiclePosition = (GtfsRealtime.VehiclePosition)vehiclePositionsByVehicleId.get(vehicleId);
            }
            updates.add(update);
        }
        for (Map.Entry entry : anonymousTripUpdatesByBlock.asMap().entrySet()) {
            update = new CombinedTripUpdatesAndVehiclePosition();
            update.block = bd = (BlockDescriptor)entry.getKey();
            update.setTripUpdates(new ArrayList<GtfsRealtime.TripUpdate>((Collection)entry.getValue()));
            if (update.getTripUpdatesSize() == 1 && anonymousVehiclePositionsByBlock.containsKey(bd)) {
                update.vehiclePosition = (GtfsRealtime.VehiclePosition)anonymousVehiclePositionsByBlock.get(bd);
            }
            updates.add(update);
        }
        for (CombinedTripUpdatesAndVehiclePosition combinedTripUpdatesAndVehiclePosition : updates) {
            GtfsRealtime.TripUpdate tu;
            if (combinedTripUpdatesAndVehiclePosition.block == null || combinedTripUpdatesAndVehiclePosition.block.getVehicleId() != null) continue;
            String vehicleId3 = null;
            Iterator<GtfsRealtime.TripUpdate> iterator = combinedTripUpdatesAndVehiclePosition.getTripUpdates().iterator();
            while (iterator.hasNext() && (vehicleId3 = this.getVehicleId(tu = iterator.next())) == null) {
            }
            if (vehicleId3 == null && combinedTripUpdatesAndVehiclePosition.vehiclePosition != null && combinedTripUpdatesAndVehiclePosition.vehiclePosition.hasVehicle() && combinedTripUpdatesAndVehiclePosition.vehiclePosition.getVehicle().hasId()) {
                vehicleId3 = this.getVehicleId(combinedTripUpdatesAndVehiclePosition.vehiclePosition);
            }
            if (vehicleId3 == null || combinedTripUpdatesAndVehiclePosition.block == null) continue;
            combinedTripUpdatesAndVehiclePosition.block.setVehicleId(vehicleId3);
        }
        return updates;
    }

    long ensureMillis(long timestamp) {
        long diff = System.currentTimeMillis() / 1000L - timestamp;
        if (Math.abs(diff) > 3153600000L) {
            return timestamp;
        }
        return timestamp * 1000L;
    }

    private BlockDescriptor handleDynamicTripUpdate(GtfsRealtime.TripUpdate tu) {
        try {
            AddedTripInfo addedTripInfo;
            GtfsRealtime.TripDescriptor td = tu.getTrip();
            if (td.hasExtension(GtfsRealtimeNYCT.nyctTripDescriptor)) {
                GtfsRealtimeNYCT.NyctTripDescriptor nyctTripDescriptor = (GtfsRealtimeNYCT.NyctTripDescriptor)td.getExtension(GtfsRealtimeNYCT.nyctTripDescriptor);
                _log.debug("parsing trip {}", (Object)td.getTripId());
                AddedTripInfo addedTripInfo2 = this._serviceSource.getAddedTripService().handleNyctDescriptor(this._serviceSource, tu, nyctTripDescriptor, this._currentTime);
                if (addedTripInfo2 == null) {
                    return null;
                }
                long tripStartTimeMillis = addedTripInfo2.getServiceDate() + (long)(addedTripInfo2.getTripStartTime() * 1000);
                if (this._filterUnassigned && nyctTripDescriptor.hasIsAssigned() && !nyctTripDescriptor.getIsAssigned()) {
                    return null;
                }
                if (nyctTripDescriptor.hasIsAssigned() && !nyctTripDescriptor.getIsAssigned() && tripStartTimeMillis < this._currentTime) {
                    return null;
                }
                return this._serviceSource.getDynamicTripBuilder().createBlockDescriptor(addedTripInfo2, this.getCurrentTime());
            }
            if (td.getScheduleRelationship().equals((Object)GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED) && (addedTripInfo = this._serviceSource.getAddedTripService().handleAddedDescriptor(this._serviceSource, this._entitySource.getAgencyIds().get(0), tu, this._currentTime)) != null) {
                return this._serviceSource.getDynamicTripBuilder().createBlockDescriptor(addedTripInfo, this.getCurrentTime());
            }
            return null;
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return null;
        }
    }

    private GtfsRealtime.TripUpdate addStartDateTime(GtfsRealtime.TripUpdate tu) {
        if (!tu.hasTrip() || !tu.getTrip().hasTripId()) {
            throw new IllegalStateException("unidentifiable trip " + tu);
        }
        if (tu.getTrip().hasStartTime()) {
            return tu;
        }
        if (this.isNycDynamicTrip(tu)) {
            return tu;
        }
        TripEntry trip = this._entitySource.getTrip(tu.getTrip().getTripId());
        if (trip == null || trip.getStopTimes() == null || trip.getStopTimes().isEmpty()) {
            _log.error("no stoptimes for trip {} on agencies {}, cannot determine start time", (Object)tu.getTrip().getTripId(), this._entitySource.getAgencyIds());
            return tu;
        }
        StopTimeEntry stopTimeEntry = trip.getStopTimes().get(0);
        int arrivalTime = stopTimeEntry.getArrivalTime();
        ServiceDate serviceDate = null;
        String dateString = null;
        if (tu.getTrip().hasStartDate()) {
            dateString = tu.getTrip().getStartDate();
        }
        if (dateString == null || dateString.length() == 0) {
            dateString = "00000000";
        }
        try {
            serviceDate = ServiceDate.parseString((String)dateString);
        }
        catch (ParseException e) {
            _log.error("invalid date format |" + tu.getTrip().getStartDate() + "| for trip |" + tu.getTrip().getTripId() + "|");
            return tu;
        }
        Date startTime = new Date(serviceDate.getAsDate().getTime() + (long)(arrivalTime * 1000));
        SimpleDateFormat sdfTime = new SimpleDateFormat("hh:mm:ss");
        GtfsRealtime.TripDescriptor.Builder tdBuilder = tu.getTrip().toBuilder();
        tdBuilder.setStartTime(sdfTime.format(startTime));
        GtfsRealtime.TripUpdate.Builder builder = tu.toBuilder();
        return builder.setTrip(tdBuilder.build()).build();
    }

    private AssignmentInfo getAssignmentInfo(GtfsRealtime.FeedMessage tripUpdateMessage, GtfsRealtime.FeedMessage vehiclePositionsMessage) {
        HashMap<String, String> preferredTripByVehicleId = new HashMap<String, String>();
        HashMap<String, String> preferredVehicleByBlockId = new HashMap<String, String>();
        if (vehiclePositionsMessage != null) {
            for (GtfsRealtime.FeedEntity fe : vehiclePositionsMessage.getEntityList()) {
                if (!fe.hasVehicle() || !fe.hasVehicle() || !fe.getVehicle().hasVehicle() || !fe.getVehicle().getVehicle().hasId() || !fe.getVehicle().hasTrip()) continue;
                String vehicleId = fe.getVehicle().getVehicle().getId();
                String tripId = fe.getVehicle().getTrip().getTripId();
                if (preferredTripByVehicleId.containsKey(vehicleId)) {
                    _log.warn("vehicle " + vehicleId + " on trip " + tripId + " already reported on" + (String)preferredTripByVehicleId.get(vehicleId));
                    continue;
                }
                preferredTripByVehicleId.put(vehicleId, tripId);
                TripEntry tripEntry = this._entitySource.getTrip(tripId);
                if (tripEntry == null || tripEntry.getBlock() == null) continue;
                String blockId = tripEntry.getBlock().getId().toString();
                preferredVehicleByBlockId.put(blockId, vehicleId);
            }
        }
        return new AssignmentInfo(preferredTripByVehicleId, preferredVehicleByBlockId);
    }

    public VehicleLocationRecord createVehicleLocationRecordForUpdate(CombinedTripUpdatesAndVehiclePosition update) {
        return this.createVehicleLocationRecordForUpdate(null, update);
    }

    public VehicleLocationRecord createVehicleLocationRecordForUpdate(MonitoredResult result, CombinedTripUpdatesAndVehiclePosition update) {
        VehicleLocationRecord record = new VehicleLocationRecord();
        record.setTimeOfRecord(this.currentTime());
        BlockDescriptor blockDescriptor = update.block;
        if (update.block == null) {
            return null;
        }
        record.setMutated(update.block.getMutated());
        String vehicleId = update.block.getVehicleId();
        record.setBlockId(blockDescriptor.getBlockInstance().getBlock().getBlock().getId());
        record.setStatus(blockDescriptor.getScheduleRelationship().toString());
        if ("ADDED".equals(update.block.getScheduleRelationship().toString()) || "DUPLICATED".equals(update.block.getScheduleRelationship().toString()) || this.isNycDynamicTrip(update)) {
            this.applyDynamicTripUpdatesToRecord(result, blockDescriptor, update.getTripUpdates(), record, vehicleId);
        } else {
            this.applyTripUpdatesToRecord(result, blockDescriptor, update.getTripUpdates(), record, vehicleId);
        }
        if (update.vehiclePosition != null) {
            this.applyVehiclePositionToRecord(result, blockDescriptor, update.vehiclePosition, record);
        }
        if (record.getVehicleId() == null) {
            record.setVehicleId(record.getBlockId());
        }
        if (result != null) {
            if (record.getTripId() != null) {
                if (record.getStatus().equals("ADDED")) {
                    result.addAddedTripId(record.getTripId().toString());
                } else if (record.getStatus().equals("DUPLICATED")) {
                    result.addDuplicatedTripId(record.getTripId().toString());
                } else if (record.getStatus().equals("CANCELED")) {
                    result.addCancelledTripId(record.getTripId().toString());
                } else if (this.isTripActive(update)) {
                    result.addMatchedTripId(record.getTripId().toString());
                }
            } else if (record.getBlockId() != null) {
                if (record.getStatus().equals("CANCELED")) {
                    result.addCancelledTripId(record.getBlockId().toString());
                } else if (this.isTripActive(update)) {
                    result.addMatchedTripId(record.getBlockId().toString());
                }
            } else if (this.isTripActive(update)) {
                result.addMatchedTripId(record.getBlockId().toString());
            }
        }
        if (blockDescriptor.getVehicleId() != null) {
            String agencyId = record.getBlockId().getAgencyId();
            try {
                AgencyAndId vehicleAgencyAndId = AgencyAndIdLibrary.convertFromString((String)blockDescriptor.getVehicleId());
                record.setVehicleId(vehicleAgencyAndId);
            }
            catch (IllegalStateException ise) {
                record.setVehicleId(new AgencyAndId(agencyId, blockDescriptor.getVehicleId()));
            }
        }
        return record;
    }

    private boolean isTripActive(CombinedTripUpdatesAndVehiclePosition update) {
        if (update.getTripUpdates().isEmpty()) {
            return false;
        }
        long windowFuture = 3600L;
        GtfsRealtime.TripUpdate tripUpdate = update.getTripUpdates().get(0);
        int tripUpdateCount = update.getTripUpdates().get(0).getStopTimeUpdateCount();
        if (tripUpdateCount == 0) {
            return false;
        }
        long firstPrediction = -1L;
        long lastPrediction = -1L;
        GtfsRealtime.TripUpdate.StopTimeUpdate firstStopTime = tripUpdate.getStopTimeUpdate(0);
        GtfsRealtime.TripUpdate.StopTimeUpdate lastStopTime = tripUpdate.getStopTimeUpdate(tripUpdateCount - 1);
        if (firstStopTime.hasArrival()) {
            firstPrediction = firstStopTime.getArrival().getTime();
        } else if (firstStopTime.hasDeparture()) {
            firstPrediction = firstStopTime.getDeparture().getTime();
        }
        if (lastStopTime.hasDeparture()) {
            lastPrediction = lastStopTime.getDeparture().getTime();
        } else if (lastStopTime.hasArrival()) {
            lastPrediction = lastStopTime.getArrival().getTime();
        }
        if (firstPrediction < 0L || lastPrediction < 0L) {
            return false;
        }
        long currentTime = this.currentTime() / 1000L;
        boolean active = currentTime + windowFuture > firstPrediction && lastPrediction > currentTime;
        return active;
    }

    private boolean isNycDynamicTrip(CombinedTripUpdatesAndVehiclePosition update) {
        if (!update.getTripUpdates().isEmpty() && update.getTripUpdates().get(0).hasTrip()) {
            return this.isNycDynamicTrip(update.getTripUpdates().get(0));
        }
        return false;
    }

    private boolean isNycDynamicTrip(GtfsRealtime.TripUpdate tu) {
        if (tu.hasTrip()) {
            if (tu.getTrip().hasExtension(GtfsRealtimeNYCT.nyctTripDescriptor)) {
                return true;
            }
            if (tu.getTrip().hasScheduleRelationship()) {
                return tu.getTrip().getScheduleRelationship().equals((Object)GtfsRealtime.TripDescriptor.ScheduleRelationship.ADDED) || tu.getTrip().getScheduleRelationship().equals((Object)GtfsRealtime.TripDescriptor.ScheduleRelationship.DUPLICATED);
            }
        }
        return false;
    }

    private void applyDynamicTripUpdatesToRecord(MonitoredResult result, BlockDescriptor blockDescriptor, List<GtfsRealtime.TripUpdate> tripUpdates, VehicleLocationRecord record, String vehicleId) {
        try {
            boolean isDuplicated = blockDescriptor.getScheduleRelationship().equals((Object)BlockDescriptor.ScheduleRelationship.DUPLICATED);
            String agencyId = blockDescriptor.getBlockInstance().getBlock().getBlock().getId().getAgencyId();
            record.setStatus(blockDescriptor.getScheduleRelationship().toString());
            record.setServiceDate(blockDescriptor.getBlockInstance().getServiceDate());
            record.setTimeOfRecord(this.currentTime());
            if (blockDescriptor.getVehicleId() != null) {
                record.setVehicleId(new AgencyAndId(agencyId, blockDescriptor.getVehicleId()));
            }
            if (blockDescriptor.getStartTime() != null) {
                record.setBlockStartTime(blockDescriptor.getStartTime().intValue());
            } else {
                record.setBlockStartTime(this.getFirstStpTime(blockDescriptor));
            }
            ArrayList<TimepointPredictionRecord> timepointPredictions = new ArrayList<TimepointPredictionRecord>();
            for (GtfsRealtime.TripUpdate tripUpdate : tripUpdates) {
                if (record.getTripId() == null) {
                    if (isDuplicated) {
                        record.setTripId(new AgencyAndId(agencyId, this.markDuplicated(tripUpdate.getTrip().getTripId())));
                    } else {
                        record.setTripId(new AgencyAndId(agencyId, tripUpdate.getTrip().getTripId()));
                    }
                }
                int sequence = 0;
                for (GtfsRealtime.TripUpdate.StopTimeUpdate stu : tripUpdate.getStopTimeUpdateList()) {
                    GtfsRealtimeNYCT.NyctStopTimeUpdate ext;
                    TimepointPredictionRecord tpr = new TimepointPredictionRecord();
                    AgencyAndId correctedStopId = this.enforceWrongWayConcurrency(blockDescriptor, new AgencyAndId(agencyId, tripUpdate.getTrip().getTripId()), new AgencyAndId(agencyId, stu.getStopId()));
                    tpr.setTimepointId(correctedStopId);
                    StopEntry testStop = this._entitySource.getStop(tpr.getTimepointId());
                    if (testStop == null) {
                        _log.debug("discarding stu for unknown stop {}", (Object)tpr.getTimepointId());
                        continue;
                    }
                    if (isDuplicated) {
                        tpr.setTripId(new AgencyAndId(agencyId, this.markDuplicated(tripUpdate.getTrip().getTripId())));
                    } else {
                        tpr.setTripId(new AgencyAndId(agencyId, tripUpdate.getTrip().getTripId()));
                    }
                    tpr.setStopSequence(-1);
                    ++sequence;
                    switch (stu.getScheduleRelationship()) {
                        case SCHEDULED: {
                            tpr.setScheduleRealtionship(TimepointPredictionRecord.ScheduleRelationship.SCHEDULED.getValue());
                            break;
                        }
                        case SKIPPED: {
                            tpr.setScheduleRealtionship(TimepointPredictionRecord.ScheduleRelationship.SKIPPED.getValue());
                            break;
                        }
                        default: {
                            tpr.setScheduleRealtionship(TimepointPredictionRecord.ScheduleRelationship.SCHEDULED.getValue());
                        }
                    }
                    if (stu.hasArrival() && stu.getArrival().hasTime()) {
                        tpr.setTimepointPredictedArrivalTime(stu.getArrival().getTime() * 1000L);
                    }
                    if (stu.hasDeparture() && stu.getDeparture().hasTime()) {
                        tpr.setTimepointPredictedDepartureTime(stu.getDeparture().getTime() * 1000L);
                    }
                    if (stu.hasExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate)) {
                        ext = (GtfsRealtimeNYCT.NyctStopTimeUpdate)stu.getExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate);
                        if (ext.hasScheduledTrack()) {
                            tpr.setScheduledTrack(ext.getScheduledTrack());
                        }
                        if (ext.hasActualTrack()) {
                            tpr.setActualTrack(ext.getActualTrack());
                        }
                    }
                    if (stu.hasExtension(GtfsRealtimeMTARR.mtaRailroadStopTimeUpdate)) {
                        ext = (GtfsRealtimeMTARR.MtaRailroadStopTimeUpdate)stu.getExtension(GtfsRealtimeMTARR.mtaRailroadStopTimeUpdate);
                        if (ext.hasTrack()) {
                            tpr.setActualTrack(ext.getTrack());
                        }
                        if (ext.hasTrainStatus()) {
                            tpr.setStatus(ext.getTrainStatus());
                        }
                    }
                    timepointPredictions.add(tpr);
                }
                record.setTimepointPredictions(timepointPredictions);
                record.setScheduleDeviation(this.calculateScheduleDeviation(blockDescriptor.getBlockInstance(), timepointPredictions));
            }
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
        }
    }

    private AgencyAndId enforceWrongWayConcurrency(BlockDescriptor blockDescriptor, AgencyAndId tripId, AgencyAndId stopId) {
        for (BlockTripEntry blockTripEntry : blockDescriptor.getBlockInstance().getBlock().getTrips()) {
            if (!blockTripEntry.getTrip().getId().equals((Object)tripId)) continue;
            AgencyAndId routeId = blockTripEntry.getTrip().getRoute().getId();
            String directionId = blockTripEntry.getTrip().getDirectionId();
            StopDirectionSwap stopDirectionSwap = this._serviceSource.getStopSwapService().findStopDirectionSwap(routeId, directionId, stopId);
            if (stopDirectionSwap == null) {
                return stopId;
            }
            return stopDirectionSwap.getToStop();
        }
        return stopId;
    }

    private String markDuplicated(String tripId) {
        return tripId + "_Dup";
    }

    private int getFirstStpTime(BlockDescriptor blockDescriptor) {
        if (blockDescriptor.getBlockInstance() != null && !blockDescriptor.getBlockInstance().getBlock().getTrips().isEmpty() && !blockDescriptor.getBlockInstance().getBlock().getTrips().get(0).getStopTimes().isEmpty()) {
            return blockDescriptor.getBlockInstance().getBlock().getTrips().get(0).getStopTimes().get(0).getStopTime().getDepartureTime();
        }
        return -1;
    }

    private double calculateScheduleDeviation(BlockInstance blockInstance, List<TimepointPredictionRecord> timepointPredictions) {
        AgencyAndId stopTimeStopId;
        int predictionSize = timepointPredictions.size();
        int stopTimesSize = blockInstance.getBlock().getTrips().get(0).getStopTimes().size();
        if (predictionSize < 1) {
            _log.debug("not enough data to calculate deviation");
            return 0.0;
        }
        TimepointPredictionRecord timepointPredictionRecord = timepointPredictions.get(predictionSize - 1);
        BlockStopTimeEntry blockStopTimeEntry = blockInstance.getBlock().getTrips().get(0).getStopTimes().get(stopTimesSize - 1);
        AgencyAndId predictionStopId = timepointPredictionRecord.getTimepointId();
        if (predictionStopId.equals((Object)(stopTimeStopId = blockStopTimeEntry.getStopTime().getStop().getId()))) {
            if (timepointPredictionRecord.getTimepointPredictedArrivalTime() > 0L) {
                return this.calculateScheduleDeviation(blockInstance.getServiceDate(), timepointPredictionRecord.getTimepointPredictedArrivalTime(), blockStopTimeEntry.getStopTime().getArrivalTime());
            }
            if (timepointPredictionRecord.getTimepointPredictedDepartureTime() > 0L) {
                return this.calculateScheduleDeviation(blockInstance.getServiceDate(), timepointPredictionRecord.getTimepointPredictedDepartureTime(), blockStopTimeEntry.getStopTime().getDepartureTime());
            }
        }
        for (BlockStopTimeEntry stopTime : blockInstance.getBlock().getTrips().get(0).getStopTimes()) {
            stopTimeStopId = stopTime.getStopTime().getStop().getId();
            for (TimepointPredictionRecord timepointPrediction : timepointPredictions) {
                predictionStopId = timepointPrediction.getTimepointId();
                if (!stopTimeStopId.equals((Object)predictionStopId)) continue;
                if (timepointPrediction.getTimepointPredictedArrivalTime() > 0L) {
                    return this.calculateScheduleDeviation(blockInstance.getServiceDate(), timepointPredictionRecord.getTimepointPredictedArrivalTime(), blockStopTimeEntry.getStopTime().getArrivalTime());
                }
                if (timepointPrediction.getTimepointPredictedDepartureTime() <= 0L) continue;
                return this.calculateScheduleDeviation(blockInstance.getServiceDate(), timepointPredictionRecord.getTimepointPredictedDepartureTime(), blockStopTimeEntry.getStopTime().getDepartureTime());
            }
        }
        return 0.0;
    }

    private double calculateScheduleDeviation(long serviceDate, long predictionMillis, int stopTimeSeconds) {
        long stopTime = serviceDate + (long)(stopTimeSeconds * 1000);
        double deviation = predictionMillis / 1000L - stopTime / 1000L;
        return deviation;
    }

    private BlockDescriptor getTripDescriptorAsBlockDescriptor(MonitoredResult result, GtfsRealtime.TripDescriptor trip, long currentTime, String vehicleId) {
        try {
            if (!trip.hasTripId()) {
                return null;
            }
            TripEntry tripEntry = this._entitySource.getTrip(trip.getTripId());
            if (tripEntry == null) {
                if (result != null) {
                    _log.debug("discarding: reporting unmatched trip with id=" + trip.getTripId());
                    result.addUnmatchedTripId(trip.getTripId());
                } else {
                    _log.debug("discarding: no trip found with id=" + trip.getTripId());
                }
                return null;
            }
            BlockServiceDate _blockserviceDate = this._serviceSource.getBlockFinder().getBlockServiceDateFromTrip(tripEntry, currentTime);
            if (_blockserviceDate == null) {
                _log.error("could not determine service date for trip {}", (Object)trip.getTripId());
                return null;
            }
            BlockInstance instance = _blockserviceDate.getBlockInstance();
            ServiceDate serviceDate = _blockserviceDate.getServiceDate();
            Integer startTime = _blockserviceDate.getTripStartTime();
            BlockDescriptor blockDescriptor = new BlockDescriptor();
            blockDescriptor.setBlockInstance(instance);
            blockDescriptor.setStartDate(serviceDate);
            blockDescriptor.setStartTime(startTime);
            if (trip.hasScheduleRelationship()) {
                if (this.isDynamicTrip(tripEntry)) {
                    blockDescriptor.setScheduleRelationship(BlockDescriptor.ScheduleRelationship.ADDED);
                } else {
                    blockDescriptor.setScheduleRelationshipValue(trip.getScheduleRelationship().toString());
                }
            } else if (this.isDynamicTrip(tripEntry)) {
                blockDescriptor.setScheduleRelationship(BlockDescriptor.ScheduleRelationship.ADDED);
            }
            blockDescriptor.setVehicleId(vehicleId);
            return blockDescriptor;
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return null;
        }
    }

    private boolean isDynamicTrip(TripEntry trip) {
        return trip instanceof DynamicTripEntryImpl;
    }

    private void applyTripUpdatesToRecord(MonitoredResult result, BlockDescriptor blockDescriptor, List<GtfsRealtime.TripUpdate> tripUpdates, VehicleLocationRecord record, String vehicleId) {
        try {
            BlockInstance instance = blockDescriptor.getBlockInstance();
            BlockConfigurationEntry blockConfiguration = instance.getBlock();
            List<BlockTripEntry> blockTrips = blockConfiguration.getTrips();
            Map tempTripUpdatesByTripId = MappingLibrary.mapToValueList(tripUpdates, (String)"trip.tripId");
            Map<String, List> tripUpdatesByTripId = new HashMap();
            if (this._entitySource.getTripIdRegexes() != null) {
                Iterator iterator = tempTripUpdatesByTripId.keySet().iterator();
                while (iterator.hasNext()) {
                    String existingTripId;
                    String newTripId = existingTripId = (String)iterator.next();
                    for (String tripIdRegex : this._entitySource.getTripIdRegexes()) {
                        newTripId = newTripId.replaceAll(tripIdRegex, "");
                    }
                    tripUpdatesByTripId.put(newTripId, (List)tempTripUpdatesByTripId.get(existingTripId));
                }
            } else {
                tripUpdatesByTripId = tempTripUpdatesByTripId;
            }
            long t = this.currentTime();
            int currentTime = (int)((t - instance.getServiceDate()) / 1000L);
            BestScheduleDeviation best = new BestScheduleDeviation();
            long lastStopScheduleTime = Long.MIN_VALUE;
            boolean singleTimepointRecord = false;
            ArrayList<TimepointPredictionRecord> timepointPredictions = new ArrayList<TimepointPredictionRecord>();
            for (BlockTripEntry blockTrip : blockTrips) {
                Object tripUpdate2;
                TripEntry trip = blockTrip.getTrip();
                AgencyAndId tripId = trip.getId();
                List updatesForTrip = (List)tripUpdatesByTripId.get(tripId.getId());
                if (updatesForTrip != null) {
                    for (Object tripUpdate2 : updatesForTrip) {
                        if (tripUpdate2.hasDelay()) {
                            best.delta = 0;
                            best.isInPast = false;
                            best.scheduleDeviation = tripUpdate2.getDelay();
                            best.tripId = tripId;
                            best.tripUpdateHasDelay = true;
                        }
                        if (tripUpdate2.hasTimestamp()) {
                            best.timestamp = this.ensureMillis(tripUpdate2.getTimestamp());
                        }
                        if (tripId != null) {
                            best.isCanceled = tripUpdate2.getTrip().getScheduleRelationship().equals((Object)GtfsRealtime.TripDescriptor.ScheduleRelationship.CANCELED);
                            record.setStatus(tripUpdate2.getTrip().getScheduleRelationship().toString());
                            _log.debug("schedule=" + tripUpdate2.getTrip().getScheduleRelationship() + "; isCanceled=" + best.isCanceled);
                        }
                        for (GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate : tripUpdate2.getStopTimeUpdateList()) {
                            long timepointPredictedTime;
                            BlockStopTimeEntry blockStopTime = this.getBlockStopTimeForStopTimeUpdate(result, (GtfsRealtime.TripUpdate)tripUpdate2, stopTimeUpdate, blockTrip.getStopTimes(), instance.getServiceDate());
                            List<BlockStopTimeEntry> stopTimes = blockTrip.getStopTimes();
                            for (BlockStopTimeEntry bste : stopTimes) {
                                long scheduleTime = instance.getServiceDate() + (long)(bste.getStopTime().getArrivalTime() * 1000);
                                if (scheduleTime <= lastStopScheduleTime) continue;
                                lastStopScheduleTime = scheduleTime;
                            }
                            if (blockStopTime == null) continue;
                            StopTimeEntry stopTime = blockStopTime.getStopTime();
                            TimepointPredictionRecord tpr = new TimepointPredictionRecord();
                            tpr.setTimepointId(stopTime.getStop().getId());
                            tpr.setTripId(stopTime.getTrip().getId());
                            if (!stopTimeUpdate.getScheduleRelationship().equals((Object)GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED)) {
                                tpr.setTimepointScheduledTime(instance.getServiceDate() + (long)(stopTime.getArrivalTime() * 1000));
                            }
                            if (stopTimeUpdate.hasStopSequence()) {
                                tpr.setStopSequence(stopTimeUpdate.getStopSequence());
                            }
                            if (stopTimeUpdate.getScheduleRelationship().equals((Object)GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED)) {
                                tpr.setScheduleRealtionship(1);
                                timepointPredictions.add(tpr);
                                _log.debug("SKIPPED stop:" + tpr.getTimepointId() + "  seq: " + tpr.getStopSequence() + " trip: " + tpr.getTripId());
                            } else {
                                tpr.setScheduleRealtionship(0);
                            }
                            if (stopTimeUpdate.getScheduleRelationship().equals((Object)GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SKIPPED)) continue;
                            int currentArrivalTime = this.computeArrivalTime(stopTime, stopTimeUpdate, instance.getServiceDate());
                            int currentDepartureTime = this.computeDepartureTime(stopTime, stopTimeUpdate, instance.getServiceDate());
                            if (currentArrivalTime >= 0) {
                                this.updateBestScheduleDeviation(currentTime, stopTime.getArrivalTime(), currentArrivalTime, best, tripId, vehicleId);
                                timepointPredictedTime = instance.getServiceDate() + (long)currentArrivalTime * 1000L;
                                tpr.setTimepointPredictedArrivalTime(timepointPredictedTime);
                            }
                            if (currentDepartureTime >= 0) {
                                this.updateBestScheduleDeviation(currentTime, stopTime.getDepartureTime(), currentDepartureTime, best, tripId, vehicleId);
                                timepointPredictedTime = instance.getServiceDate() + (long)currentDepartureTime * 1000L;
                                tpr.setTimepointPredictedDepartureTime(timepointPredictedTime);
                            }
                            if (tpr.getTimepointPredictedArrivalTime() != -1L || tpr.getTimepointPredictedDepartureTime() != -1L) {
                                timepointPredictions.add(tpr);
                            }
                            if (stopTimeUpdate.hasExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate)) {
                                GtfsRealtimeNYCT.NyctStopTimeUpdate ext = (GtfsRealtimeNYCT.NyctStopTimeUpdate)stopTimeUpdate.getExtension(GtfsRealtimeNYCT.nyctStopTimeUpdate);
                                if (ext.hasScheduledTrack()) {
                                    tpr.setScheduledTrack(ext.getScheduledTrack());
                                }
                                if (ext.hasActualTrack()) {
                                    tpr.setActualTrack(ext.getActualTrack());
                                }
                            }
                            if (!stopTimeUpdate.hasExtension(GtfsRealtimeMTARR.mtaRailroadStopTimeUpdate)) continue;
                            GtfsRealtimeMTARR.MtaRailroadStopTimeUpdate ext = (GtfsRealtimeMTARR.MtaRailroadStopTimeUpdate)stopTimeUpdate.getExtension(GtfsRealtimeMTARR.mtaRailroadStopTimeUpdate);
                            if (ext.hasTrack()) {
                                tpr.setActualTrack(ext.getTrack());
                            }
                            if (!ext.hasTrainStatus()) continue;
                            tpr.setStatus(ext.getTrainStatus());
                        }
                    }
                }
                if (timepointPredictions.size() == 1 && tripUpdates.get(0).getStopTimeUpdateList().size() == 1) {
                    singleTimepointRecord = true;
                }
                if ((timepointPredictions.size() <= 0 || !best.tripUpdateHasDelay) && !singleTimepointRecord) continue;
                HashSet<AgencyAndId> records = new HashSet<AgencyAndId>();
                tripUpdate2 = timepointPredictions.iterator();
                while (tripUpdate2.hasNext()) {
                    TimepointPredictionRecord tpr = (TimepointPredictionRecord)tripUpdate2.next();
                    records.add(tpr.getTimepointId());
                }
                long tprStartTime = GtfsRealtimeTripLibrary.getEarliestTimeInRecords(timepointPredictions);
                for (StopTimeEntry stopTime : trip.getStopTimes()) {
                    long time;
                    if (records.contains(stopTime.getStop().getId())) continue;
                    long predictionOffset = instance.getServiceDate() + (long)best.scheduleDeviation * 1000L;
                    long predictedDepartureTime = (long)stopTime.getDepartureTime() * 1000L + predictionOffset;
                    long predictedArrivalTime = (long)stopTime.getArrivalTime() * 1000L + predictionOffset;
                    long scheduledArrivalTime = instance.getServiceDate() + (long)(stopTime.getArrivalTime() * 1000);
                    long l = time = best.timestamp != 0L ? best.timestamp : this.currentTime();
                    if ((predictedDepartureTime <= time || predictedDepartureTime >= tprStartTime) && (!singleTimepointRecord || predictedDepartureTime <= time || scheduledArrivalTime > lastStopScheduleTime)) continue;
                    TimepointPredictionRecord tpr = new TimepointPredictionRecord();
                    tpr.setTimepointId(stopTime.getStop().getId());
                    tpr.setTripId(stopTime.getTrip().getId());
                    tpr.setStopSequence(stopTime.getGtfsSequence());
                    tpr.setTimepointPredictedArrivalTime(predictedArrivalTime);
                    tpr.setTimepointPredictedDepartureTime(predictedDepartureTime);
                    tpr.setTimepointScheduledTime(scheduledArrivalTime);
                    tpr.setScheduleRealtionship(0);
                    timepointPredictions.add(tpr);
                }
            }
            record.setServiceDate(instance.getServiceDate());
            if (blockDescriptor.getStartTime() != null) {
                record.setBlockStartTime(blockDescriptor.getStartTime().intValue());
            }
            if (blockDescriptor.getScheduleRelationship() != null) {
                record.setStatus(blockDescriptor.getScheduleRelationship().toString());
            }
            if (!best.isCanceled) {
                record.setScheduleDeviation((double)best.scheduleDeviation);
            }
            if (best.timestamp != 0L) {
                record.setTimeOfRecord(best.timestamp);
            }
            record.setTimepointPredictions(timepointPredictions);
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
        }
    }

    private BlockStopTimeEntry getBlockStopTimeForStopTimeUpdate(MonitoredResult result, GtfsRealtime.TripUpdate tripUpdate, GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate, List<BlockStopTimeEntry> stopTimes, long serviceDate) {
        if (stopTimeUpdate.hasStopSequence()) {
            int stopSequence = stopTimeUpdate.getStopSequence();
            Map sequenceToStopTime = MappingLibrary.mapToValue(stopTimes, (String)"stopTime.gtfsSequence");
            if (sequenceToStopTime.containsKey(stopSequence)) {
                BlockStopTimeEntry blockStopTime = (BlockStopTimeEntry)sequenceToStopTime.get(stopSequence);
                if (!stopTimeUpdate.hasStopId()) {
                    if (result != null) {
                        result.addMatchedStopId(blockStopTime.getStopTime().getStop().getId().getId());
                    }
                    return blockStopTime;
                }
                String stopTimeUpdateStopId = this.convertStopId(stopTimeUpdate.getStopId());
                if (blockStopTime.getStopTime().getStop().getId().getId().equals(stopTimeUpdateStopId)) {
                    if (result != null) {
                        result.addMatchedStopId(blockStopTime.getStopTime().getStop().getId().getId());
                    }
                    return blockStopTime;
                }
            } else {
                _log.debug("StopTimeSequence is out of bounds: stopSequence=" + stopSequence + " tripUpdate=\n" + tripUpdate);
            }
        }
        if (stopTimeUpdate.hasStopId()) {
            int time = this.getTimeForStopTimeUpdate(stopTimeUpdate, serviceDate);
            String stopId = this.convertStopId(stopTimeUpdate.getStopId());
            Min bestMatches = new Min();
            for (BlockStopTimeEntry blockStopTime : stopTimes) {
                if (!blockStopTime.getStopTime().getStop().getId().getId().equals(stopId)) continue;
                StopTimeEntry stopTime = blockStopTime.getStopTime();
                int departureDelta = Math.abs(stopTime.getDepartureTime() - time);
                int arrivalDelta = Math.abs(stopTime.getArrivalTime() - time);
                bestMatches.add((double)departureDelta, (Object)blockStopTime);
                bestMatches.add((double)arrivalDelta, (Object)blockStopTime);
            }
            if (!bestMatches.isEmpty()) {
                if (result != null) {
                    result.addMatchedStopId(this.convertStopId(stopId));
                }
                return (BlockStopTimeEntry)bestMatches.getMinElement();
            }
        }
        if (result != null) {
            result.addUnmatchedStopId(this.convertStopId(stopTimeUpdate.getStopId()));
        }
        return null;
    }

    private String convertStopId(String stopId) {
        if (this._stopModificationStrategy == null) {
            return stopId;
        }
        return this._stopModificationStrategy.convertStopId(stopId);
    }

    private int getTimeForStopTimeUpdate(GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate, long serviceDate) {
        long t = this.currentTime();
        if (stopTimeUpdate.hasArrival()) {
            GtfsRealtime.TripUpdate.StopTimeEvent arrival = stopTimeUpdate.getArrival();
            if (arrival.hasTime()) {
                return (int)(arrival.getTime() - serviceDate / 1000L);
            }
            if (arrival.hasDelay()) {
                return (int)((t - serviceDate) / 1000L - (long)arrival.getDelay());
            }
        }
        if (stopTimeUpdate.hasDeparture()) {
            GtfsRealtime.TripUpdate.StopTimeEvent departure = stopTimeUpdate.getDeparture();
            if (departure.hasTime()) {
                return (int)(departure.getTime() - serviceDate / 1000L);
            }
            if (departure.hasDelay()) {
                return (int)((t - serviceDate) / 1000L - (long)departure.getDelay());
            }
        }
        _log.debug("expected at least an arrival or departure time or delay for update: " + stopTimeUpdate);
        return -1;
    }

    private int computeArrivalTime(StopTimeEntry stopTime, GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate, long serviceDate) {
        if (!stopTimeUpdate.hasArrival()) {
            return -1;
        }
        GtfsRealtime.TripUpdate.StopTimeEvent arrival = stopTimeUpdate.getArrival();
        if (arrival.hasTime()) {
            return (int)(arrival.getTime() - serviceDate / 1000L);
        }
        if (arrival.hasDelay()) {
            return stopTime.getArrivalTime() + arrival.getDelay();
        }
        return -1;
    }

    private int computeDepartureTime(StopTimeEntry stopTime, GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate, long serviceDate) {
        if (!stopTimeUpdate.hasDeparture()) {
            return -1;
        }
        GtfsRealtime.TripUpdate.StopTimeEvent departure = stopTimeUpdate.getDeparture();
        if (departure.hasTime()) {
            return (int)(departure.getTime() - serviceDate / 1000L);
        }
        if (departure.hasDelay()) {
            return stopTime.getDepartureTime() + departure.getDelay();
        }
        return -1;
    }

    private void updateBestScheduleDeviation(int currentTime, int expectedStopTime, int actualStopTime, BestScheduleDeviation best, AgencyAndId tripId, String vehicleId) {
        if (best.tripUpdateHasDelay) {
            return;
        }
        int delta = Math.abs(currentTime - actualStopTime);
        boolean isInPast = currentTime > actualStopTime;
        int scheduleDeviation = actualStopTime - expectedStopTime;
        if (delta < best.delta || !isInPast && best.isInPast) {
            best.delta = delta;
            best.isInPast = isInPast;
            best.scheduleDeviation = scheduleDeviation;
            best.tripId = tripId;
        }
    }

    private void applyVehiclePositionToRecord(MonitoredResult result, BlockDescriptor blockDescriptor, GtfsRealtime.VehiclePosition vehiclePosition, VehicleLocationRecord record) {
        GtfsRealtime.Position position = vehiclePosition.getPosition();
        if (vehiclePosition.hasTimestamp()) {
            record.setTimeOfLocationUpdate(this.ensureMillis(vehiclePosition.getTimestamp()));
        }
        record.setCurrentLocationLat((double)position.getLatitude());
        record.setCurrentLocationLon((double)position.getLongitude());
        if (result != null) {
            result.addLatLon(position.getLatitude(), position.getLongitude());
        }
        if (this._scheduleAdherenceFromLocation) {
            CoordinatePoint location = new CoordinatePoint((double)position.getLatitude(), (double)position.getLongitude());
            double totalDistance = blockDescriptor.getBlockInstance().getBlock().getTotalBlockDistance();
            long timestamp = vehiclePosition.hasTimestamp() ? record.getTimeOfLocationUpdate() : record.getTimeOfRecord();
            ScheduledBlockLocation loc = this._serviceSource.getBlockGeospatialService().getBestScheduledBlockLocationForLocation(blockDescriptor.getBlockInstance(), location, timestamp, 0.0, totalDistance);
            long serviceDateTime = record.getServiceDate();
            long effectiveScheduleTime = (long)loc.getScheduledTime() + serviceDateTime / 1000L;
            double deviation = timestamp / 1000L - effectiveScheduleTime;
            double oldDeviation = record.getScheduleDeviation();
            record.setScheduleDeviation(deviation);
            _log.debug("deviation reset to {} from {} for vehicle {}", new Object[]{deviation, oldDeviation, vehiclePosition.getVehicle().getId()});
        }
        if (vehiclePosition.getVehicle().hasExtension(GtfsRealtimeOneBusAway.obaVehicleDescriptor)) {
            GtfsRealtimeOneBusAway.OneBusAwayVehicleDescriptor vehicleDescriptor = (GtfsRealtimeOneBusAway.OneBusAwayVehicleDescriptor)vehiclePosition.getVehicle().getExtension(GtfsRealtimeOneBusAway.obaVehicleDescriptor);
            for (String feature : vehicleDescriptor.getVehicleFeatureList()) {
                record.addVehicleFeature(feature);
            }
        }
    }

    private static long getEarliestTimeInRecords(Collection<TimepointPredictionRecord> records) {
        long min = Long.MAX_VALUE;
        for (TimepointPredictionRecord tpr : records) {
            if (tpr.getTimepointPredictedArrivalTime() != -1L) {
                min = Math.min(min, tpr.getTimepointPredictedArrivalTime());
                continue;
            }
            if (tpr.getTimepointPredictedDepartureTime() == -1L) continue;
            min = Math.min(min, tpr.getTimepointPredictedDepartureTime());
        }
        return min;
    }

    private long currentTime() {
        if (this._currentTime != 0L) {
            if (this.validateCurrentTime() && Math.abs(this._currentTime - SystemTime.currentTimeMillis()) > 3600000L) {
                _log.error("timestamp invalid at " + new Date(this._currentTime) + ", overriding with system time");
                this._currentTime = SystemTime.currentTimeMillis();
            }
            return this._currentTime;
        }
        return SystemTime.currentTimeMillis();
    }

    private String getVehicleId(GtfsRealtime.TripUpdate tu) {
        GtfsRealtimeNYCT.NyctTripDescriptor nyctTripDescriptor;
        if (tu.hasVehicle() && tu.getVehicle().hasId() && StringUtils.isNotBlank((String)tu.getVehicle().getId())) {
            if (this._useLabelAsVehicleId && tu.hasVehicle() && tu.getVehicle().hasLabel()) {
                return tu.getVehicle().getLabel();
            }
            return tu.getVehicle().getId();
        }
        if (tu.hasTrip() && tu.getTrip().hasExtension(GtfsRealtimeNYCT.nyctTripDescriptor) && (nyctTripDescriptor = (GtfsRealtimeNYCT.NyctTripDescriptor)tu.getTrip().getExtension(GtfsRealtimeNYCT.nyctTripDescriptor)).hasTrainId()) {
            return nyctTripDescriptor.getTrainId();
        }
        return null;
    }

    private String getVehicleId(GtfsRealtime.VehiclePosition vp) {
        if (this._useLabelAsVehicleId && vp.hasVehicle() && vp.getVehicle().hasLabel()) {
            return vp.getVehicle().getLabel();
        }
        return vp.getVehicle().getId();
    }

    public VehicleOccupancyRecord createVehicleOccupancyRecordForUpdate(MonitoredResult result, CombinedTripUpdatesAndVehiclePosition update) {
        if (update == null) {
            return null;
        }
        if (update.vehiclePosition == null) {
            return null;
        }
        if (update.vehiclePosition.hasOccupancyStatus()) {
            VehicleOccupancyRecord vor = this.initalizeVehicleOccupancyRecord(update);
            try {
                vor.setOccupancyStatus(OccupancyStatus.valueOf((String)update.vehiclePosition.getOccupancyStatus().name()));
            }
            catch (IllegalArgumentException iae) {
                _log.debug("unknown occupancy value: " + iae);
            }
            if (vor.getOccupancyStatus() == null) {
                _log.warn("unmatched occupancy status " + update.vehiclePosition.getOccupancyStatus().name());
                return null;
            }
            return vor;
        }
        if (update.vehiclePosition.hasExtension(GtfsRealtimeCrowding.crowdingDescriptor)) {
            GtfsRealtimeCrowding.CrowdingDescriptor crowdingDescriptor = (GtfsRealtimeCrowding.CrowdingDescriptor)update.vehiclePosition.getExtension(GtfsRealtimeCrowding.crowdingDescriptor);
            VehicleOccupancyRecord vor = this.initalizeVehicleOccupancyRecord(update);
            if (crowdingDescriptor.hasEstimatedCount()) {
                vor.setRawCount(Integer.valueOf(crowdingDescriptor.getEstimatedCount()));
            }
            if (crowdingDescriptor.hasEstimatedCapacity()) {
                vor.setCapacity(Integer.valueOf(crowdingDescriptor.getEstimatedCapacity()));
            }
            return vor;
        }
        return null;
    }

    private VehicleOccupancyRecord initalizeVehicleOccupancyRecord(CombinedTripUpdatesAndVehiclePosition update) {
        VehicleOccupancyRecord vor = new VehicleOccupancyRecord();
        try {
            vor.setVehicleId(AgencyAndIdLibrary.convertFromString((String)update.block.getVehicleId()));
        }
        catch (IllegalStateException ise) {
            vor.setVehicleId(new AgencyAndId(update.block.getBlockInstance().getBlock().getBlock().getId().getAgencyId(), update.block.getVehicleId()));
        }
        TripEntry firstTrip = null;
        if (update.vehiclePosition.hasTrip() && update.vehiclePosition.getTrip().hasTripId()) {
            firstTrip = this._entitySource.getTrip(update.vehiclePosition.getTrip().getTripId());
        }
        if (firstTrip == null) {
            firstTrip = this._entitySource.getTrip(update.getTripUpdates().get(0).getTrip().getTripId());
        }
        if (firstTrip != null && firstTrip.getRoute() != null) {
            vor.setRouteId(AgencyAndIdLibrary.convertToString((AgencyAndId)firstTrip.getRoute().getId()));
            vor.setDirectionId(firstTrip.getDirectionId());
        }
        return vor;
    }

    private static class AssignmentInfo {
        private Map<String, String> preferredTripByVehicleId;
        private Map<String, String> preferredVehicleByBlockId;

        public AssignmentInfo(Map<String, String> preferredTripByVehicleId, Map<String, String> preferredVehicleByBlockId) {
            this.preferredTripByVehicleId = preferredTripByVehicleId;
            this.preferredVehicleByBlockId = preferredVehicleByBlockId;
        }
    }

    private static class BestScheduleDeviation {
        public int delta = Integer.MAX_VALUE;
        public int scheduleDeviation = 0;
        public boolean isInPast = true;
        public boolean tripUpdateHasDelay = false;
        public long timestamp = 0L;
        public AgencyAndId tripId = null;
        public boolean isCanceled = false;

        private BestScheduleDeviation() {
        }
    }
}

