/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.transit.realtime.GtfsRealtime;
import com.google.transit.realtime.GtfsRealtimeCrowding;
import com.google.transit.realtime.GtfsRealtimeMTARR;
import com.google.transit.realtime.GtfsRealtimeNYCT;
import com.google.transit.realtime.GtfsRealtimeOneBusAway;
import com.google.transit.realtime.GtfsRealtimeServiceStatus;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.alerts.impl.ServiceAlertLocalizedString;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertSituationConsequenceClause;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.alerts.service.ServiceAlerts;
import org.onebusaway.alerts.service.ServiceAlertsService;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.realtime.api.VehicleOccupancyListener;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.model.service_alerts.ECause;
import org.onebusaway.transit_data.model.service_alerts.ESeverity;
import org.onebusaway.transit_data_federation.impl.RouteReplacementServiceImpl;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockDescriptor;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.CombinedTripUpdatesAndVehiclePosition;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DataSourceMonitor;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DuplicatedTripServiceImpl;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DynamicTripBuilder;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeAlertLibrary;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeCancelService;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeServiceSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeTripLibrary;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredDataSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.StopModificationStrategy;
import org.onebusaway.transit_data_federation.impl.transit_graph.StopTimeEntriesFactory;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.ConsolidatedStopsService;
import org.onebusaway.transit_data_federation.services.StopSwapService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockGeospatialService;
import org.onebusaway.transit_data_federation.services.blocks.BlockIndexService;
import org.onebusaway.transit_data_federation.services.blocks.DynamicBlockIndexService;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.shapes.ShapePointService;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class GtfsRealtimeSource
implements MonitoredDataSource {
    public static final String GTFS_CONNECT_TIMEOUT = "gtfs.connect_timeout";
    public static final String GTFS_READ_TIMEOUT = "gtfs.read_timeout";
    private static final Logger _log = LoggerFactory.getLogger(GtfsRealtimeSource.class);
    private static final ExtensionRegistry _registry = ExtensionRegistry.newInstance();
    private VehicleLocationListener _vehicleLocationListener;
    private VehicleOccupancyListener _vehicleOccupancyListener;
    private ServiceAlertsService _serviceAlertService;
    private ScheduledExecutorService _scheduledExecutorService;
    private ConsolidatedStopsService _consolidatedStopsService;
    private ScheduledFuture<?> _refreshTask;
    private DataSourceMonitor _monitor;
    private URL _tripUpdatesUrl;
    private String _sftpTripUpdatesUrl;
    private URL _vehiclePositionsUrl;
    private String _sftpVehiclePositionsUrl;
    private URL _alertsUrl;
    private URL _alertCollectionUrl;
    private String _sftpAlertsUrl;
    private int _refreshInterval = 30;
    private Integer _maxDeltaLocationMeters = null;
    private boolean _showNegativeScheduledArrivals = true;
    private Map<String, String> _headersMap;
    private Map _alertAgencyIdMap;
    private List<String> _agencyIds = new ArrayList<String>();
    private List<String> _tripIdRegexs = null;
    private Map<AgencyAndId, Date> _lastVehicleUpdate = new HashMap<AgencyAndId, Date>();
    private Map<AgencyAndId, ServiceAlerts.ServiceAlert> _alertsById = new HashMap<AgencyAndId, ServiceAlerts.ServiceAlert>();
    private GtfsRealtimeEntitySource _entitySource = new GtfsRealtimeEntitySource();
    private GtfsRealtimeServiceSource _serviceSource = new GtfsRealtimeServiceSource();
    private GtfsRealtimeTripLibrary _tripsLibrary;
    private GtfsRealtimeAlertLibrary _alertLibrary;
    private MonitoredResult _monitoredResult = new MonitoredResult();
    private String _feedId = null;
    private StopModificationStrategy _stopModificationStrategy = null;
    private boolean _scheduleAdherenceFromLocation = false;
    private boolean _enabled = true;
    private boolean _useLabelAsId = false;
    private boolean _ignoreAlertTripId = false;
    private String _alertSourcePrefix = null;
    private boolean _validateCurrentTime = false;
    private boolean _filterUnassigned = false;
    private List<AgencyAndId> _routeIdsToCancel = null;
    private GtfsRealtimeCancelService _cancelService;

    @Autowired
    public void setAgencyService(AgencyService agencyService) {
        this._serviceSource.setAgencyService(agencyService);
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._entitySource.setTransitGraphDao(transitGraphDao);
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._serviceSource.setBlockCalendarService(blockCalendarService);
    }

    @Autowired
    public void setBlockLocationService(BlockLocationService blockLocationService) {
        this._serviceSource.setBlockLocationService(blockLocationService);
    }

    @Autowired
    public void setConsolidatedStopsService(ConsolidatedStopsService service) {
        this._consolidatedStopsService = service;
    }

    @Autowired
    @Qualifier(value="dynamicBlockIndexServiceImpl")
    public void setDynamicBlockIndexService(DynamicBlockIndexService dynamicBlockIndexService) {
        this._serviceSource.setDynamicBlockIndexService(dynamicBlockIndexService);
    }

    @Autowired
    public void setDataSourceMonitor(DataSourceMonitor monitor) {
        this._monitor = monitor;
    }

    @Autowired
    public void setNarrativeService(NarrativeService service) {
        this._serviceSource.setNarrativeService(service);
    }

    @Autowired
    public void setVehicleLocationListener(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    @Autowired
    public void setVehicleOccupancyListener(VehicleOccupancyListener vehicleOccupancyListener) {
        this._vehicleOccupancyListener = vehicleOccupancyListener;
    }

    @Autowired
    public void setServiceAlertService(ServiceAlertsService serviceAlertService) {
        this._serviceAlertService = serviceAlertService;
    }

    @Autowired
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutorService = scheduledExecutorService;
    }

    @Autowired
    public void setBlockGeospatialService(BlockGeospatialService blockGeospatialService) {
        this._serviceSource.setBlockGeospatialService(blockGeospatialService);
    }

    @Autowired
    public void setStopTimeEntriesFactory(StopTimeEntriesFactory stopTimeEntriesFactory) {
        this._serviceSource.setStopTimeEntriesFactory(stopTimeEntriesFactory);
    }

    @Autowired
    public void setShapePointService(ShapePointService service) {
        this._serviceSource.setShapePointService(service);
    }

    @Autowired
    public void setStopSwapService(StopSwapService service) {
        this._serviceSource.setStopSwapServce(service);
    }

    @Autowired
    public void setBlockIndexService(BlockIndexService service) {
        this._serviceSource.setBlockIndexService(service);
    }

    public void setStopModificationStrategy(StopModificationStrategy strategy) {
        this._stopModificationStrategy = strategy;
    }

    public void setTripUpdatesUrl(URL tripUpdatesUrl) {
        this._tripUpdatesUrl = tripUpdatesUrl;
    }

    public URL getTripUpdatesUrl() {
        return this._tripUpdatesUrl;
    }

    public void setSftpTripUpdatesUrl(String sftpTripUpdatesUrl) {
        this._sftpTripUpdatesUrl = sftpTripUpdatesUrl;
    }

    public void setVehiclePositionsUrl(URL vehiclePositionsUrl) {
        this._vehiclePositionsUrl = vehiclePositionsUrl;
    }

    public URL getVehiclePositionsUrl() {
        return this._vehiclePositionsUrl;
    }

    public void setSftpVehiclePositionsUrl(String sftpVehiclePositionsUrl) {
        this._sftpVehiclePositionsUrl = sftpVehiclePositionsUrl;
    }

    public void setAlertsUrl(URL alertsUrl) {
        this._alertsUrl = alertsUrl;
    }

    public void setAlertCollectionUrl(URL alertCollectionUrl) {
        this._alertCollectionUrl = alertCollectionUrl;
    }

    public URL getAlertsUrl() {
        return this._alertsUrl;
    }

    public URL getAlertCollectionUrl() {
        return this._alertCollectionUrl;
    }

    public void setSftpAlertsUrl(String sftpAlertsUrl) {
        this._sftpAlertsUrl = sftpAlertsUrl;
    }

    public void setRefreshInterval(int refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    public int getRefreshInterval() {
        return this._refreshInterval;
    }

    public void setMaxDeltaLocationMeters(Integer max) {
        this._maxDeltaLocationMeters = max;
    }

    public Integer getMaxDeltaLocationMeters() {
        return this._maxDeltaLocationMeters;
    }

    public void setHeadersMap(Map<String, String> headersMap) {
        this._headersMap = headersMap;
    }

    public void setAlertAgencyIdMap(Map alertAgencyIdMap) {
        this._alertAgencyIdMap = alertAgencyIdMap;
    }

    public void setAgencyId(String agencyId) {
        this._agencyIds.add(agencyId);
    }

    public void setAgencyIds(List<String> agencyIds) {
        this._agencyIds.addAll(agencyIds);
    }

    public void setTripIdRegexes(List<String> tripIdRegexes) {
        this._tripIdRegexs = tripIdRegexes;
    }

    public void setShowNegativeScheduledArrivals(boolean _showNegativeScheduledArrivals) {
        this._showNegativeScheduledArrivals = _showNegativeScheduledArrivals;
    }

    public boolean getShowNegativeScheduledArrivals() {
        return this._showNegativeScheduledArrivals;
    }

    public List<String> getAgencyIds() {
        return this._agencyIds;
    }

    public void setMonitoredResult(MonitoredResult result) {
        this._monitoredResult = result;
    }

    @Override
    public MonitoredResult getMonitoredResult() {
        return this._monitoredResult;
    }

    @Override
    public String getFeedId() {
        if (this._feedId == null) {
            this._feedId = this._agencyIds.toString();
        }
        return this._feedId;
    }

    public void setFeedId(String id) {
        this._feedId = id;
    }

    public void setScheduleAdherenceFromLocation(boolean scheduleAdherenceFromLocation) {
        this._scheduleAdherenceFromLocation = scheduleAdherenceFromLocation;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public void setUseLabelAsId(boolean useLabelAsId) {
        this._useLabelAsId = useLabelAsId;
    }

    public void setIgnoreAlertTripId(boolean ignore) {
        this._ignoreAlertTripId = ignore;
    }

    public GtfsRealtimeTripLibrary getGtfsRealtimeTripLibrary() {
        return this._tripsLibrary;
    }

    public String getAlertSourcePrefix() {
        return this._alertSourcePrefix;
    }

    public void setAlertSourcePrefix(String prefix) {
        this._alertSourcePrefix = prefix;
    }

    public void setRouteIdsToCancel(List<String> routeAgencyIds) {
        if (routeAgencyIds != null) {
            this._routeIdsToCancel = new ArrayList<AgencyAndId>();
            for (String routeAgencyId : routeAgencyIds) {
                try {
                    this._routeIdsToCancel.add(AgencyAndId.convertFromString((String)routeAgencyId));
                }
                catch (IllegalStateException ise) {
                    _log.error("invalid routeId {}", (Throwable)ise);
                }
            }
        }
    }

    public void setFilterUnassigned(boolean flag) {
        this._filterUnassigned = flag;
    }

    @Autowired
    public void setGtfsRealtimeCancelService(GtfsRealtimeCancelService service) {
        this._cancelService = service;
    }

    @PostConstruct
    public void start() {
        if (this._agencyIds.isEmpty()) {
            _log.info("no agency ids specified for GtfsRealtimeSource, so defaulting to full agency id set");
            List<String> agencyIds = this._serviceSource.getAgencyService().getAllAgencyIds();
            this._agencyIds.addAll(agencyIds);
            if (this._agencyIds.size() > 3) {
                _log.warn("The default agency id set is quite large (n=" + this._agencyIds.size() + ").  You might consider specifying the applicable agencies for your GtfsRealtimeSource.");
            }
        }
        this._entitySource.setAgencyIds(this._agencyIds);
        this._entitySource.setTripIdRegexs(this._tripIdRegexs);
        this._entitySource.setConsolidatedStopService(this._consolidatedStopsService);
        this._tripsLibrary = new GtfsRealtimeTripLibrary();
        this._tripsLibrary.setEntitySource(this._entitySource);
        this._tripsLibrary.setServiceSource(this._serviceSource);
        if (this._stopModificationStrategy != null) {
            this._tripsLibrary.setStopModificationStrategy(this._stopModificationStrategy);
        }
        this._tripsLibrary.setScheduleAdherenceFromLocation(this._scheduleAdherenceFromLocation);
        this._tripsLibrary.setUseLabelAsVehicleId(this._useLabelAsId);
        this._tripsLibrary.setValidateCurrentTime(this._validateCurrentTime);
        this._tripsLibrary.setFilterUnassigned(this._filterUnassigned);
        DuplicatedTripServiceImpl duplicatedTripService = new DuplicatedTripServiceImpl();
        duplicatedTripService.setGtfsRealtimeEntitySource(this._entitySource);
        this._serviceSource.setDuplicatedTripService(duplicatedTripService);
        DynamicTripBuilder tripBuilder = new DynamicTripBuilder();
        tripBuilder.setServiceSource(this._serviceSource);
        tripBuilder.setEntityource(this._entitySource);
        this._serviceSource.setDynamicTripBuilder(tripBuilder);
        this._alertLibrary = new GtfsRealtimeAlertLibrary();
        this._alertLibrary.setEntitySource(this._entitySource);
        if (this._refreshInterval > 0) {
            this._refreshTask = this._scheduledExecutorService.scheduleAtFixedRate(new RefreshTask(), 0L, this._refreshInterval, TimeUnit.SECONDS);
        }
    }

    public void reset() {
        this._lastVehicleUpdate.clear();
    }

    @PreDestroy
    public void stop() {
        if (this._refreshTask != null) {
            this._refreshTask.cancel(true);
            this._refreshTask = null;
        }
    }

    public void refresh() throws IOException {
        if (!this.graphReady()) {
            _log.warn("skipping update " + this.getAgencyIds() + ", bundle not ready");
            return;
        }
        GtfsRealtime.FeedMessage tripUpdates = this._sftpTripUpdatesUrl != null ? this.readOrReturnDefault(this._sftpTripUpdatesUrl) : this.readOrReturnDefault(this._tripUpdatesUrl);
        GtfsRealtime.FeedMessage vehiclePositions = this._sftpVehiclePositionsUrl != null ? this.readOrReturnDefault(this._sftpVehiclePositionsUrl) : this.readOrReturnDefault(this._vehiclePositionsUrl);
        GtfsRealtime.FeedMessage alerts = this._sftpAlertsUrl != null ? this.readOrReturnDefault(this._sftpAlertsUrl) : this.readOrReturnDefault(this._alertsUrl);
        ServiceAlerts.ServiceAlertsCollection alertCollection = this.readOrReturnDefaultCollection(this._alertCollectionUrl);
        MonitoredResult result = new MonitoredResult();
        result.setAgencyIds(this._agencyIds);
        result.setFeedId(this.getFeedId());
        if (this._routeIdsToCancel != null) {
            long currentTime = this._tripsLibrary.getCurrentTime();
            if (currentTime == 0L) {
                currentTime = System.currentTimeMillis();
            }
            this._cancelService.cancelServiceForRoutes(this._routeIdsToCancel, currentTime);
        }
        this.handleUpdates(result, tripUpdates, vehiclePositions, alerts, alertCollection);
        this._monitoredResult = result;
    }

    private ServiceAlerts.ServiceAlertsCollection readOrReturnDefaultCollection(URL alertCollectionUrl) throws IOException {
        return this.readAlertCollectionFromUrl(alertCollectionUrl);
    }

    protected boolean graphReady() {
        return this._entitySource.isGraphReady();
    }

    private synchronized void handleUpdates(MonitoredResult result, GtfsRealtime.FeedMessage tripUpdates, GtfsRealtime.FeedMessage vehiclePositions, GtfsRealtime.FeedMessage alerts, ServiceAlerts.ServiceAlertsCollection alertCollection) {
        long time = tripUpdates.getHeader().getTimestamp() * 1000L;
        this._tripsLibrary.setCurrentTime(this._tripsLibrary.ensureMillis(time));
        List<CombinedTripUpdatesAndVehiclePosition> combinedUpdates = this._tripsLibrary.groupTripUpdatesAndVehiclePositions(result, tripUpdates, vehiclePositions);
        result.setRecordsTotal(combinedUpdates.size());
        this.handleCombinedUpdatesLogged(result, combinedUpdates);
        this.cacheVehicleLocations(vehiclePositions);
        this.handleAlerts(alerts);
        this.handleAlertCollection(alertCollection);
    }

    private void cacheVehicleLocations(GtfsRealtime.FeedMessage vehiclePositions) {
        for (GtfsRealtime.FeedEntity entity : vehiclePositions.getEntityList()) {
            if (!entity.hasVehicle()) continue;
            GtfsRealtime.VehiclePosition vehicle = entity.getVehicle();
            this._vehicleLocationListener.handleRawPosition(new AgencyAndId(this.getAgencyIds().get(0), vehicle.getVehicle().getId()), (double)vehicle.getPosition().getLatitude(), (double)vehicle.getPosition().getLongitude(), vehicle.getTimestamp());
        }
    }

    void handleCombinedUpdatesLogged(MonitoredResult result, List<CombinedTripUpdatesAndVehiclePosition> updates) {
        try {
            this.handleCombinedUpdates(result, updates);
        }
        catch (Throwable t) {
            _log.error("handleCombinedUpdates source-exception: {}", (Object)t, (Object)t);
        }
    }

    void handleCombinedUpdates(MonitoredResult result, List<CombinedTripUpdatesAndVehiclePosition> updates) {
        AgencyAndId vehicleId;
        long methodStarTime = System.currentTimeMillis();
        if (this._tripUpdatesUrl == null) {
            return;
        }
        HashSet<AgencyAndId> seenVehicles = new HashSet<AgencyAndId>();
        try {
            for (CombinedTripUpdatesAndVehiclePosition update : updates) {
                boolean isDynamicTrip;
                String metricTripId = null;
                if (update.getTripUpdates() != null && update.getTripUpdatesSize() > 0 && update.getTripUpdates().get(0).hasTrip()) {
                    metricTripId = update.getTripUpdates().get(0).getTrip().getTripId();
                }
                if (update.block == null) {
                    _log.error("null block {} for agencies {}, bailing...", metricTripId, this._agencyIds);
                    result.addUnmatchedTripId(metricTripId);
                    continue;
                }
                BlockDescriptor.ScheduleRelationship scheduleRelationship = update.block.getScheduleRelationship();
                if (scheduleRelationship == null) {
                    _log.error("no schedule relationship for update {}", (Object)update);
                    result.addUnmatchedTripId(metricTripId);
                    continue;
                }
                boolean bl = isDynamicTrip = "ADDED".equals(scheduleRelationship.name()) || "DUPLICATED".equals(scheduleRelationship.name());
                VehicleLocationRecord record = this._tripsLibrary.createVehicleLocationRecordForUpdate(result, update);
                if (record == null) continue;
                if (isDynamicTrip) {
                    if (this._monitoredResult.getLastUpdate() < record.getTimeOfRecord()) {
                        this._monitoredResult.setLastUpdate(record.getTimeOfRecord());
                    }
                    this._serviceSource.getDynamicBlockIndexService().register(update.block.getBlockInstance(), record.getTimeOfRecord());
                }
                if (record.getTripId() != null) {
                    result.addUnmatchedTripId(record.getTripId().toString());
                }
                vehicleId = record.getVehicleId();
                if (!isDynamicTrip && this.blockNotActive(record)) {
                    _log.debug("discarding v: " + vehicleId + " as block not active");
                    result.addUnmatchedTripId(metricTripId);
                    continue;
                }
                if (!isDynamicTrip && !this.isValidLocation(record, update)) {
                    _log.debug("discarding v: " + vehicleId + " as location is bad");
                    result.addUnmatchedTripId(metricTripId);
                    continue;
                }
                seenVehicles.add(vehicleId);
                VehicleOccupancyRecord vor = this._tripsLibrary.createVehicleOccupancyRecordForUpdate(result, update);
                Date timestamp = new Date(this.getGtfsRealtimeTripLibrary().ensureMillis(record.getTimeOfRecord()));
                Date prev = this._lastVehicleUpdate.get(vehicleId);
                if (prev == null || prev.before(timestamp)) {
                    _log.debug("matched vehicle " + vehicleId + " on block=" + record.getBlockId() + " with scheduleDeviation=" + record.getScheduleDeviation());
                    this._vehicleLocationListener.handleVehicleLocationRecord(record);
                    if (vor != null) {
                        this._vehicleOccupancyListener.handleVehicleOccupancyRecord(vor);
                    }
                    this._lastVehicleUpdate.put(vehicleId, timestamp);
                    continue;
                }
                _log.debug("discarding: update for vehicle " + vehicleId + " as timestamp in past (" + (timestamp.getTime() - prev.getTime()) + "ms)");
            }
        }
        catch (Throwable t) {
            _log.error("fatal exception {}", (Object)t, (Object)t);
        }
        Calendar c = Calendar.getInstance();
        if (this.getGtfsRealtimeTripLibrary() != null) {
            c.setTime(new Date(this.getGtfsRealtimeTripLibrary().getCurrentTime()));
        }
        c.add(12, -15);
        Date staleRecordThreshold = c.getTime();
        long newestUpdate = 0L;
        Iterator<Map.Entry<AgencyAndId, Date>> it = this._lastVehicleUpdate.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<AgencyAndId, Date> entry = it.next();
            vehicleId = entry.getKey();
            Date lastUpdateTime = entry.getValue();
            if (lastUpdateTime != null && lastUpdateTime.getTime() > newestUpdate) {
                newestUpdate = lastUpdateTime.getTime();
            }
            if (seenVehicles.contains(vehicleId) || !lastUpdateTime.before(staleRecordThreshold)) continue;
            _log.debug("removing stale vehicleId=" + vehicleId);
            it.remove();
        }
        result.setLastUpdate(newestUpdate);
        if (this._monitor != null) {
            this._monitor.logUpdate(result);
        }
        long methodEndTime = System.currentTimeMillis();
        _log.info("Agency " + this.getFeedId() + " has active vehicles=" + seenVehicles.size() + ", matched=" + result.getMatchedTripIds().size() + " (" + result.getUnmatchedTripIds().size() + "), added=" + result.getAddedTripIds().size() + ", duplicated=" + result.getDuplicatedTripIds().size() + ", cancelled=" + result.getCancelledTripIds().size() + " for updates=" + updates.size() + " with most recent timestamp " + new Date(newestUpdate) + " in " + (methodEndTime - methodStarTime) + "ms");
    }

    private boolean isValidLocation(VehicleLocationRecord record, CombinedTripUpdatesAndVehiclePosition update) {
        if (this._maxDeltaLocationMeters == null) {
            return true;
        }
        CoordinatePoint reported = new CoordinatePoint((double)update.vehiclePosition.getPosition().getLatitude(), (double)update.vehiclePosition.getPosition().getLongitude());
        BlockLocation blockLocation = this._serviceSource.getBlockLocationService().getScheduledLocationForBlockInstance(update.block.getBlockInstance(), record.getTimeOfRecord());
        if (blockLocation == null) {
            return true;
        }
        CoordinatePoint calculated = blockLocation.getLocation();
        double delta = SphericalGeometryLibrary.distanceFaster((double)reported.getLat(), (double)reported.getLon(), (double)calculated.getLat(), (double)calculated.getLon());
        if (delta < (double)this._maxDeltaLocationMeters.intValue()) {
            return true;
        }
        _log.info("dropped vehicle {} has distance of {} with deviation {} when limit is {}", new Object[]{record.getVehicleId(), delta, record.getScheduleDeviation(), this._maxDeltaLocationMeters});
        return false;
    }

    private boolean blockNotActive(VehicleLocationRecord record) {
        if (record.isScheduleDeviationSet() && Math.abs(record.getScheduleDeviation()) > 3600.0) {
            _log.debug("discarding v: " + record.getVehicleId() + " for schDev=" + record.getScheduleDeviation());
            return true;
        }
        return false;
    }

    private void handleAlertCollection(ServiceAlerts.ServiceAlertsCollection alertsCollection) {
        if (this._alertCollectionUrl == null) {
            return;
        }
        if (alertsCollection == null) {
            _log.info("handleAlertCollection nothing to do");
            return;
        }
        HashSet<AgencyAndId> currentAlerts = new HashSet<AgencyAndId>();
        HashSet<ServiceAlertRecord> toAdd = new HashSet<ServiceAlertRecord>();
        HashSet<ServiceAlertRecord> toUpdate = new HashSet<ServiceAlertRecord>();
        long start = System.currentTimeMillis();
        _log.info("[" + this.getFeedId() + "] handleAlertCollection running....");
        ArrayList<AgencyAndId> idsInCollection = new ArrayList<AgencyAndId>();
        for (ServiceAlerts.ServiceAlert alert : alertsCollection.getServiceAlertsList()) {
            AgencyAndId id = new AgencyAndId(alert.getId().getAgencyId(), alert.getId().getId());
            idsInCollection.add(id);
            this.handleSingleAlert(id, alert.toBuilder(), currentAlerts, toAdd, toUpdate, alert);
        }
        this._serviceAlertService.createOrUpdateServiceAlerts(this.getAgencyIds().get(0), new ArrayList(toAdd));
        this._serviceAlertService.createOrUpdateServiceAlerts(this.getAgencyIds().get(0), new ArrayList(toUpdate));
        HashSet<AgencyAndId> toBeDeleted = new HashSet<AgencyAndId>();
        for (ServiceAlertRecord sa : this._serviceAlertService.getAllServiceAlerts()) {
            AgencyAndId testId = new AgencyAndId(sa.getAgencyId(), sa.getServiceAlertId());
            if (sa.getSource() != null && (sa.getSource().equals(this.getFeedId()) || this._alertSourcePrefix != null && sa.getSource().contains(this._alertSourcePrefix))) {
                try {
                    if (!currentAlerts.contains(testId)) {
                        _log.debug("[" + this.getFeedId() + "] cleaning up alert id " + testId + " with source=" + sa.getSource());
                        toBeDeleted.add(testId);
                        continue;
                    }
                    if (!this.getAgencyIds().contains(testId.getAgencyId()) || idsInCollection.contains(testId)) continue;
                    toBeDeleted.add(testId);
                }
                catch (Exception e) {
                    _log.error("invalid AgencyAndId " + sa.getServiceAlertId());
                }
                continue;
            }
            if (!this.getAgencyIds().contains(testId.getAgencyId()) || idsInCollection.contains(testId)) continue;
            toBeDeleted.add(testId);
        }
        this._serviceAlertService.removeServiceAlerts(new ArrayList(toBeDeleted));
        this._serviceAlertService.cleanup();
        _log.info("[" + this.getFeedId() + "] handleAlertCollection complete with " + currentAlerts.size() + " active alerts and " + toBeDeleted.size() + " deleted in " + (System.currentTimeMillis() - start) + " ms");
    }

    private void handleSingleAlert(AgencyAndId id, ServiceAlerts.ServiceAlert.Builder serviceAlertBuilder, Set<AgencyAndId> currentAlerts, Set<ServiceAlertRecord> toAdd, Set<ServiceAlertRecord> toUpdate, ServiceAlerts.ServiceAlert alert) {
        ServiceAlerts.ServiceAlert serviceAlert = alert;
        ServiceAlerts.ServiceAlert existingAlert = this._alertsById.get(id);
        ServiceAlertRecord existingRecord = this._serviceAlertService.getServiceAlertForId(new AgencyAndId(id.getAgencyId(), id.getId()));
        if (existingAlert == null || !existingAlert.equals((Object)serviceAlert)) {
            ServiceAlertLocalizedString string;
            this._alertsById.put(id, serviceAlert);
            ServiceAlertRecord serviceAlertRecord = new ServiceAlertRecord();
            if (serviceAlert.hasSource()) {
                serviceAlertRecord.setSource(serviceAlert.getSource());
            } else {
                serviceAlertRecord.setSource(this.getFeedId());
            }
            serviceAlertRecord.setConsequenceMessage(serviceAlert.getConsequenceMessage());
            serviceAlertRecord.setAgencyId(id.getAgencyId());
            serviceAlertRecord.setServiceAlertId(id.getId());
            serviceAlertRecord.setActiveWindows(new HashSet());
            if (serviceAlert.getActiveWindowList() != null) {
                for (ServiceAlerts.TimeRange timeRange : serviceAlert.getActiveWindowList()) {
                    ServiceAlertTimeRange serviceAlertTimeRange = new ServiceAlertTimeRange();
                    if (timeRange.hasStart() && timeRange.getStart() > 0L) {
                        serviceAlertTimeRange.setFromValue(Long.valueOf(timeRange.getStart()));
                    }
                    if (timeRange.hasEnd() && timeRange.getEnd() > 0L) {
                        serviceAlertTimeRange.setToValue(Long.valueOf(timeRange.getEnd()));
                    }
                    serviceAlertRecord.getActiveWindows().add(serviceAlertTimeRange);
                }
            }
            serviceAlertRecord.setAllAffects(new HashSet());
            if (serviceAlert.getAffectsList() != null) {
                for (ServiceAlerts.Affects affects : serviceAlertBuilder.getAffectsList()) {
                    ServiceAlertsSituationAffectsClause serviceAlertsSituationAffectsClause = new ServiceAlertsSituationAffectsClause();
                    if (!StringUtils.isBlank((String)affects.getAgencyId())) {
                        serviceAlertsSituationAffectsClause.setAgencyId(affects.getAgencyId());
                    }
                    if (!StringUtils.isBlank((String)affects.getApplicationId())) {
                        serviceAlertsSituationAffectsClause.setApplicationId(affects.getApplicationId());
                    }
                    if (!StringUtils.isBlank((String)affects.getDirectionId())) {
                        serviceAlertsSituationAffectsClause.setDirectionId(affects.getDirectionId());
                    }
                    if (affects.getRouteId() != null && affects.getRouteId().hasId()) {
                        serviceAlertsSituationAffectsClause.setRouteId(new AgencyAndId(affects.getRouteId().getAgencyId(), affects.getRouteId().getId()).toString());
                    }
                    if (affects.getStopId().getId() != null && affects.getStopId().hasId()) {
                        serviceAlertsSituationAffectsClause.setStopId(new AgencyAndId(affects.getStopId().getAgencyId(), affects.getStopId().getId()).toString());
                    }
                    if (!this._ignoreAlertTripId && affects.getTripId() != null && affects.getTripId().hasId()) {
                        serviceAlertsSituationAffectsClause.setTripId(new AgencyAndId(affects.getTripId().getAgencyId(), affects.getTripId().getId()).toString());
                    }
                    serviceAlertRecord.getAllAffects().add(serviceAlertsSituationAffectsClause);
                }
            }
            serviceAlertRecord.setCause(this.getECause(serviceAlert.getCause()));
            serviceAlertRecord.setConsequences(new HashSet());
            if (serviceAlert.getConsequenceList() != null) {
                for (ServiceAlerts.Consequence consequence : serviceAlert.getConsequenceList()) {
                    ServiceAlertSituationConsequenceClause serviceAlertSituationConsequenceClause = new ServiceAlertSituationConsequenceClause();
                    serviceAlertSituationConsequenceClause.setDetourPath(consequence.getDetourPath());
                    serviceAlertSituationConsequenceClause.setDetourStopIds(new HashSet());
                    if (consequence.getDetourStopIdsList() != null) {
                        for (ServiceAlerts.Id stopId : consequence.getDetourStopIdsList()) {
                            serviceAlertSituationConsequenceClause.getDetourStopIds().add(stopId.getId());
                        }
                    }
                    serviceAlertRecord.getConsequences().add(serviceAlertSituationConsequenceClause);
                }
            }
            serviceAlertRecord.setCreationTime(serviceAlert.getCreationTime());
            serviceAlertRecord.setDescriptions(new HashSet());
            if (serviceAlert.getDescription() != null) {
                for (ServiceAlerts.TranslatedString.Translation translation : serviceAlert.getDescription().getTranslationList()) {
                    string = new ServiceAlertLocalizedString();
                    string.setValue(translation.getText());
                    string.setLanguage(translation.getLanguage());
                    serviceAlertRecord.getDescriptions().add(string);
                }
            }
            serviceAlertRecord.setModifiedTime(serviceAlert.getModifiedTime());
            serviceAlertRecord.setPublicationWindows(new HashSet());
            serviceAlertRecord.setSeverity(this.getESeverity(serviceAlert.getSeverity()));
            serviceAlertRecord.setSummaries(new HashSet());
            if (serviceAlert.getSummary() != null) {
                for (ServiceAlerts.TranslatedString.Translation translation : serviceAlert.getSummary().getTranslationList()) {
                    string = new ServiceAlertLocalizedString();
                    string.setValue(translation.getText());
                    string.setLanguage(translation.getLanguage());
                    serviceAlertRecord.getSummaries().add(string);
                }
            }
            serviceAlertRecord.setUrls(new HashSet());
            if (serviceAlert.getUrl() != null) {
                for (ServiceAlerts.TranslatedString.Translation translation : serviceAlert.getUrl().getTranslationList()) {
                    string = new ServiceAlertLocalizedString();
                    string.setValue(translation.getText());
                    string.setLanguage(translation.getLanguage());
                    serviceAlertRecord.getUrls().add(string);
                }
            }
            if (existingAlert == null) {
                _log.debug("creating alert " + serviceAlertRecord.getAgencyId() + ":" + serviceAlertRecord.getServiceAlertId());
                toAdd.add(serviceAlertRecord);
            } else {
                _log.debug("updating alert " + serviceAlertRecord.getAgencyId() + ":" + serviceAlertRecord.getServiceAlertId());
                toUpdate.add(serviceAlertRecord);
            }
            currentAlerts.add(new AgencyAndId(serviceAlertRecord.getAgencyId(), serviceAlertRecord.getServiceAlertId()));
        } else {
            _log.debug("not updating alert " + id);
            currentAlerts.add(id);
        }
    }

    private void handleAlerts(GtfsRealtime.FeedMessage alerts) {
        if (this._alertsUrl == null) {
            return;
        }
        if (!alerts.hasHeader() || !alerts.getHeader().hasTimestamp()) {
            _log.error("missing alert header for " + this.getFeedId() + ", assuming connection issue and aborting");
            return;
        }
        HashSet<AgencyAndId> currentAlerts = new HashSet<AgencyAndId>();
        HashSet<ServiceAlertRecord> toAdd = new HashSet<ServiceAlertRecord>();
        HashSet<ServiceAlertRecord> toUpdate = new HashSet<ServiceAlertRecord>();
        long start = System.currentTimeMillis();
        _log.info("[" + this.getFeedId() + "] handleAlerts running....");
        for (GtfsRealtime.FeedEntity entity : alerts.getEntityList()) {
            GtfsRealtime.Alert alert = entity.getAlert();
            if (alert == null) {
                _log.warn("expected a FeedEntity with an Alert");
                continue;
            }
            AgencyAndId id = this.createId(entity.getId());
            if (entity.getIsDeleted()) {
                this._alertsById.remove(id);
                this._serviceAlertService.removeServiceAlert(id);
                continue;
            }
            ServiceAlerts.ServiceAlert.Builder serviceAlertBuilder = this._alertLibrary.getAlertAsServiceAlert(id, alert, this._alertAgencyIdMap, this._ignoreAlertTripId);
            ServiceAlerts.ServiceAlert serviceAlert = serviceAlertBuilder.build();
            ServiceAlerts.ServiceAlert existingAlert = this._alertsById.get(id);
            this.handleSingleAlert(id, serviceAlertBuilder, currentAlerts, toAdd, toUpdate, serviceAlert);
        }
        this._serviceAlertService.createOrUpdateServiceAlerts(this.getAgencyIds().get(0), new ArrayList(toAdd));
        this._serviceAlertService.createOrUpdateServiceAlerts(this.getAgencyIds().get(0), new ArrayList(toUpdate));
        HashSet<AgencyAndId> toBeDeleted = new HashSet<AgencyAndId>();
        for (ServiceAlertRecord sa : this._serviceAlertService.getAllServiceAlerts()) {
            if (sa.getSource() == null || !sa.getSource().equals(this.getFeedId())) continue;
            try {
                AgencyAndId testId = new AgencyAndId(sa.getAgencyId(), sa.getServiceAlertId());
                if (!currentAlerts.contains(testId) && (this.getFeedId().equals(sa.getSource()) || this._alertSourcePrefix != null && sa.getSource().contains(this._alertSourcePrefix))) {
                    _log.debug("[" + this.getFeedId() + "] cleaning up alert id " + testId + " with source=" + sa.getSource());
                    toBeDeleted.add(testId);
                    continue;
                }
                _log.debug("[" + this.getFeedId() + "] appears to still be valid with id=" + testId + ", (" + ((ServiceAlertsSituationAffectsClause)sa.getAllAffects().iterator().next()).getRouteId() + ")");
            }
            catch (Exception e) {
                _log.error("invalid AgencyAndId " + sa.getServiceAlertId());
            }
        }
        this._serviceAlertService.removeServiceAlerts(new ArrayList(toBeDeleted));
        this._serviceAlertService.cleanup();
        _log.info("[" + this.getFeedId() + "] handleAlerts complete with " + currentAlerts.size() + " active alerts and " + toBeDeleted.size() + " deleted in " + (System.currentTimeMillis() - start) + " ms");
    }

    private ESeverity getESeverity(ServiceAlerts.ServiceAlert.Severity severity) {
        if (severity == ServiceAlerts.ServiceAlert.Severity.NO_IMPACT) {
            return ESeverity.NO_IMPACT;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.NORMAL) {
            return ESeverity.NORMAL;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.SEVERE) {
            return ESeverity.SEVERE;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.SLIGHT) {
            return ESeverity.SLIGHT;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.UNKNOWN) {
            return ESeverity.UNKNOWN;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.VERY_SEVERE) {
            return ESeverity.VERY_SEVERE;
        }
        if (severity == ServiceAlerts.ServiceAlert.Severity.VERY_SLIGHT) {
            return ESeverity.VERY_SLIGHT;
        }
        return ESeverity.UNKNOWN;
    }

    private ECause getECause(ServiceAlerts.ServiceAlert.Cause cause) {
        if (cause == ServiceAlerts.ServiceAlert.Cause.UNKNOWN_CAUSE) {
            return ECause.UNKNOWN_CAUSE;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.OTHER_CAUSE) {
            return ECause.OTHER_CAUSE;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.TECHNICAL_PROBLEM) {
            return ECause.TECHNICAL_PROBLEM;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.STRIKE) {
            return ECause.STRIKE;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.DEMONSTRATION) {
            return ECause.DEMONSTRATION;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.ACCIDENT) {
            return ECause.ACCIDENT;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.HOLIDAY) {
            return ECause.HOLIDAY;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.WEATHER) {
            return ECause.WEATHER;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.MAINTENANCE) {
            return ECause.MAINTENANCE;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.CONSTRUCTION) {
            return ECause.CONSTRUCTION;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.POLICE_ACTIVITY) {
            return ECause.POLICE_ACTIVITY;
        }
        if (cause == ServiceAlerts.ServiceAlert.Cause.MEDICAL_EMERGENCY) {
            return ECause.MEDICAL_EMERGENCY;
        }
        return ECause.UNKNOWN_CAUSE;
    }

    private AgencyAndId createId(String id) {
        return new AgencyAndId(this._agencyIds.get(0), id);
    }

    private GtfsRealtime.FeedMessage readOrReturnDefault(URL url) throws IOException {
        if (url == null) {
            return this.getDefaultFeedMessage();
        }
        return this.readFeedFromUrl(url);
    }

    private GtfsRealtime.FeedMessage readOrReturnDefault(String url) throws IOException {
        return this.readFeedFromUrl(url);
    }

    private GtfsRealtime.FeedMessage getDefaultFeedMessage() {
        GtfsRealtime.FeedMessage.Builder builder = GtfsRealtime.FeedMessage.newBuilder();
        GtfsRealtime.FeedHeader.Builder header = GtfsRealtime.FeedHeader.newBuilder();
        header.setGtfsRealtimeVersion("2.0");
        builder.setHeader(header);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GtfsRealtime.FeedMessage readFeedFromUrl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (System.getProperty(GTFS_CONNECT_TIMEOUT) != null) {
            urlConnection.setConnectTimeout(Integer.parseInt(System.getProperty(GTFS_CONNECT_TIMEOUT)));
        }
        if (System.getProperty(GTFS_READ_TIMEOUT) != null) {
            urlConnection.setReadTimeout(Integer.parseInt(System.getProperty(GTFS_READ_TIMEOUT)));
        }
        this.setHeadersToUrlConnection(urlConnection);
        InputStream in = null;
        try {
            in = urlConnection.getInputStream();
            GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom((InputStream)in, (ExtensionRegistryLite)_registry);
            return feedMessage;
        }
        catch (IOException ex) {
            _log.error("connection issue with url " + url + ", ex=" + ex);
            GtfsRealtime.FeedMessage feedMessage = this.getDefaultFeedMessage();
            return feedMessage;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                _log.error("error closing url stream " + url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceAlerts.ServiceAlertsCollection readAlertCollectionFromUrl(URL url) throws IOException {
        if (url == null) {
            return ServiceAlerts.ServiceAlertsCollection.newBuilder().build();
        }
        URLConnection urlConnection = url.openConnection();
        if (System.getProperty(GTFS_CONNECT_TIMEOUT) != null) {
            urlConnection.setConnectTimeout(Integer.parseInt(System.getProperty(GTFS_CONNECT_TIMEOUT)));
        }
        if (System.getProperty(GTFS_READ_TIMEOUT) != null) {
            urlConnection.setReadTimeout(Integer.parseInt(System.getProperty(GTFS_READ_TIMEOUT)));
        }
        this.setHeadersToUrlConnection(urlConnection);
        InputStream in = null;
        try {
            in = urlConnection.getInputStream();
            ServiceAlerts.ServiceAlertsCollection serviceAlertsCollection = ServiceAlerts.ServiceAlertsCollection.parseFrom((InputStream)in, (ExtensionRegistryLite)_registry);
            return serviceAlertsCollection;
        }
        catch (IOException ex) {
            _log.error("connection issue with url " + url + ", ex=" + ex);
            ServiceAlerts.ServiceAlertsCollection serviceAlertsCollection = this.getDefaultServiceAlertsCollection();
            return serviceAlertsCollection;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                _log.error("error closing url stream " + url);
            }
        }
    }

    private ServiceAlerts.ServiceAlertsCollection getDefaultServiceAlertsCollection() {
        ServiceAlerts.ServiceAlertsCollection.Builder builder = ServiceAlerts.ServiceAlertsCollection.newBuilder();
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GtfsRealtime.FeedMessage readFeedFromUrl(String url) throws IOException {
        Session session = null;
        Channel channel = null;
        ChannelSftp downloadChannelSftp = null;
        InputStream in = null;
        JSch jsch = new JSch();
        int idx = url.indexOf("//") + 2;
        int idx2 = url.indexOf(":", idx);
        String user = url.substring(idx, idx2);
        idx = idx2 + 1;
        idx2 = url.indexOf("@");
        String pw = url.substring(idx, idx2);
        url = url.substring(idx2 + 1);
        idx = url.indexOf(":");
        String host = url.substring(0, idx);
        String rdir = "";
        idx = url.indexOf("/") + 1;
        idx2 = url.lastIndexOf("/");
        if (idx2 > idx) {
            rdir = url.substring(idx, idx2);
        } else {
            idx2 = idx - 1;
        }
        String rfile = url.substring(idx2 + 1);
        try {
            session = jsch.getSession(user, host, 22);
            session.setPassword(pw);
            session.setConfig("StrictHostKeyChecking", "no");
            session.connect(10000);
            channel = session.openChannel("sftp");
            channel.connect();
            downloadChannelSftp = (ChannelSftp)channel;
            downloadChannelSftp.cd(downloadChannelSftp.getHome() + "/" + rdir);
            File downloadFile = new File(downloadChannelSftp.getHome() + "/" + rfile);
            in = downloadChannelSftp.get(downloadFile.getName());
            GtfsRealtime.FeedMessage feedMessage = GtfsRealtime.FeedMessage.parseFrom((InputStream)in, (ExtensionRegistryLite)_registry);
            return feedMessage;
        }
        catch (JSchException ex) {
            _log.error("connection issue with sftp url " + url);
            GtfsRealtime.FeedMessage feedMessage = this.getDefaultFeedMessage();
            return feedMessage;
        }
        catch (SftpException e) {
            _log.error("connection issue with sftp");
            e.printStackTrace();
            GtfsRealtime.FeedMessage feedMessage = this.getDefaultFeedMessage();
            return feedMessage;
        }
        finally {
            try {
                if (channel != null) {
                    channel.disconnect();
                }
                if (session != null) {
                    session.disconnect();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                _log.error("error closing url stream " + url);
            }
        }
    }

    private void setHeadersToUrlConnection(URLConnection urlConnection) {
        if (this._headersMap != null) {
            for (Map.Entry<String, String> headerEntry : this._headersMap.entrySet()) {
                urlConnection.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
            }
        }
    }

    public void setRouteRemap(Map<String, String> remaps) {
        RouteReplacementServiceImpl routeReplacementService = new RouteReplacementServiceImpl();
        routeReplacementService.putAll(remaps);
        this._entitySource.setRouteReplacementService(routeReplacementService);
    }

    static {
        _registry.add(GtfsRealtimeOneBusAway.obaFeedEntity);
        _registry.add(GtfsRealtimeOneBusAway.obaTripUpdate);
        _registry.add(GtfsRealtimeMTARR.mtaRailroadStopTimeUpdate);
        _registry.add(GtfsRealtimeServiceStatus.mercuryAlert);
        _registry.add(GtfsRealtimeNYCT.nyctFeedHeader);
        _registry.add(GtfsRealtimeNYCT.nyctTripDescriptor);
        _registry.add(GtfsRealtimeNYCT.nyctStopTimeUpdate);
        _registry.add(GtfsRealtimeCrowding.crowdingDescriptor);
        _registry.add(GtfsRealtimeOneBusAway.obaVehicleDescriptor);
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                if (GtfsRealtimeSource.this._enabled) {
                    GtfsRealtimeSource.this.refresh();
                }
            }
            catch (Throwable ex) {
                _log.warn("Error updating from GTFS-realtime data sources for config {}, {}", new Object[]{GtfsRealtimeSource.this.getFeedId(), ex, ex});
            }
        }
    }
}

