/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import java.util.Date;
import java.util.List;
import org.onebusaway.alerts.impl.ServiceAlertLocalizedString;
import org.onebusaway.alerts.impl.ServiceAlertRecord;
import org.onebusaway.alerts.impl.ServiceAlertTimeRange;
import org.onebusaway.alerts.impl.ServiceAlertsSituationAffectsClause;
import org.onebusaway.alerts.service.ServiceAlertsService;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatus;
import org.onebusaway.transit_data_federation.services.realtime.VehicleStatusService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.SystemTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class GtfsRealtimeServiceImpl
implements GtfsRealtimeService {
    private VehicleStatusService _vehicleStatusService;
    private BlockStatusService _blockStatusService;
    private ServiceAlertsService _serviceAlertsService;

    GtfsRealtimeServiceImpl() {
    }

    @Autowired
    public void setVehicleStatusService(VehicleStatusService vehicleStatusService) {
        this._vehicleStatusService = vehicleStatusService;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    @Autowired
    public void setServiceAlertsService(ServiceAlertsService serviceAlertsService) {
        this._serviceAlertsService = serviceAlertsService;
    }

    @Override
    public GtfsRealtime.FeedMessage getTripUpdates() {
        GtfsRealtime.FeedMessage.Builder feedMessage = this.createFeedWithDefaultHeader();
        List<BlockLocation> activeBlocks = this._blockStatusService.getAllActiveBlocks(SystemTime.currentTimeMillis());
        for (BlockLocation activeBlock : activeBlocks) {
            BlockStopTimeEntry nextBlockStop;
            if (!activeBlock.isPredicted() || (nextBlockStop = activeBlock.getNextStop()) == null || !activeBlock.isScheduleDeviationSet()) continue;
            GtfsRealtime.TripUpdate.Builder tripUpdate = GtfsRealtime.TripUpdate.newBuilder();
            BlockTripEntry activeBlockTrip = nextBlockStop.getTrip();
            TripEntry activeTrip = activeBlockTrip.getTrip();
            if (activeBlock.getTimepointPredictions() != null && activeBlock.getTimepointPredictions().size() > 0) {
                List<TimepointPredictionRecord> timepointPredictions = activeBlock.getTimepointPredictions();
                for (TimepointPredictionRecord tpr : timepointPredictions) {
                    GtfsRealtime.TripUpdate.StopTimeUpdate.Builder stopTimeUpdate = GtfsRealtime.TripUpdate.StopTimeUpdate.newBuilder();
                    stopTimeUpdate.setStopId(AgencyAndId.convertToString((AgencyAndId)tpr.getTimepointId()));
                    stopTimeUpdate.setScheduleRelationship(GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.valueOf((int)tpr.getScheduleRelationship().getValue()));
                    if (tpr.getTimepointPredictedArrivalTime() != -1L) {
                        GtfsRealtime.TripUpdate.StopTimeEvent.Builder arrivalStopTimeEvent = GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder();
                        arrivalStopTimeEvent.setTime(tpr.getTimepointPredictedArrivalTime());
                        stopTimeUpdate.setArrival(arrivalStopTimeEvent);
                    }
                    if (tpr.getTimepointPredictedDepartureTime() != -1L) {
                        GtfsRealtime.TripUpdate.StopTimeEvent.Builder departureStopTimeEvent = GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder();
                        departureStopTimeEvent.setTime(tpr.getTimepointPredictedDepartureTime());
                        stopTimeUpdate.setDeparture(departureStopTimeEvent);
                    }
                    tripUpdate.addStopTimeUpdate(stopTimeUpdate);
                }
            } else {
                StopTimeEntry nextStopTime = nextBlockStop.getStopTime();
                StopEntry stop = nextStopTime.getStop();
                GtfsRealtime.TripUpdate.StopTimeUpdate.Builder stopTimeUpdate = GtfsRealtime.TripUpdate.StopTimeUpdate.newBuilder();
                stopTimeUpdate.setStopId(AgencyAndId.convertToString((AgencyAndId)stop.getId()));
                stopTimeUpdate.setStopSequence(nextStopTime.getSequence());
                stopTimeUpdate.setScheduleRelationship(GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED);
                GtfsRealtime.TripUpdate.StopTimeEvent.Builder stopTimeEvent = GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder();
                stopTimeEvent.setDelay((int)activeBlock.getScheduleDeviation());
                stopTimeUpdate.setDeparture(stopTimeEvent);
                tripUpdate.addStopTimeUpdate(stopTimeUpdate);
            }
            AgencyAndId routeId = activeTrip.getRouteCollection().getId();
            AgencyAndId tripId = activeTrip.getId();
            BlockInstance blockInstance = activeBlock.getBlockInstance();
            String startDate = String.format("%1$ty%1$tm%1$td", new Date(blockInstance.getServiceDate()));
            GtfsRealtime.TripDescriptor.Builder tripDescriptor = GtfsRealtime.TripDescriptor.newBuilder();
            tripDescriptor.setRouteId(AgencyAndId.convertToString((AgencyAndId)routeId));
            if (activeBlock.getStatus() != null) {
                tripDescriptor.setScheduleRelationship(GtfsRealtime.TripDescriptor.ScheduleRelationship.valueOf((String)activeBlock.getStatus()));
            } else {
                tripDescriptor.setScheduleRelationship(GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED);
            }
            tripDescriptor.setStartDate(startDate);
            tripDescriptor.setTripId(AgencyAndId.convertToString((AgencyAndId)tripId));
            tripUpdate.setTrip(tripDescriptor);
            AgencyAndId vehicleId = activeBlock.getVehicleId();
            GtfsRealtime.VehicleDescriptor.Builder vehicleDescriptor = GtfsRealtime.VehicleDescriptor.newBuilder();
            vehicleDescriptor.setId(AgencyAndId.convertToString((AgencyAndId)vehicleId));
            tripUpdate.setVehicle(vehicleDescriptor);
            GtfsRealtime.FeedEntity.Builder feedEntity = GtfsRealtime.FeedEntity.newBuilder();
            feedEntity.setTripUpdate(tripUpdate);
            feedEntity.setId(vehicleDescriptor.getId());
            feedMessage.addEntity(feedEntity);
        }
        return feedMessage.build();
    }

    @Override
    public GtfsRealtime.FeedMessage getVehiclePositions() {
        GtfsRealtime.FeedMessage.Builder feedMessage = this.createFeedWithDefaultHeader();
        List<VehicleStatus> statuses = this._vehicleStatusService.getAllVehicleStatuses();
        for (VehicleStatus status : statuses) {
            VehicleLocationRecord record = status.getRecord();
            GtfsRealtime.VehiclePosition.Builder vehiclePosition = GtfsRealtime.VehiclePosition.newBuilder();
            if (record.isCurrentLocationSet()) {
                GtfsRealtime.Position.Builder position = GtfsRealtime.Position.newBuilder();
                position.setLatitude((float)record.getCurrentLocationLat());
                position.setLongitude((float)record.getCurrentLocationLon());
                vehiclePosition.setPosition(position);
            }
            GtfsRealtime.VehicleDescriptor.Builder vehicleDescriptor = GtfsRealtime.VehicleDescriptor.newBuilder();
            vehicleDescriptor.setId(AgencyAndId.convertToString((AgencyAndId)record.getVehicleId()));
            vehiclePosition.setVehicle(vehicleDescriptor);
            if (record.getTimeOfLocationUpdate() != 0L) {
                vehiclePosition.setTimestamp(record.getTimeOfLocationUpdate() / 1000L);
            } else {
                vehiclePosition.setTimestamp(record.getTimeOfRecord() / 1000L);
            }
            GtfsRealtime.FeedEntity.Builder feedEntity = GtfsRealtime.FeedEntity.newBuilder();
            feedEntity.setVehicle(vehiclePosition);
            feedEntity.setId(vehicleDescriptor.getId());
            feedMessage.addEntity(feedEntity);
        }
        return feedMessage.build();
    }

    @Override
    public GtfsRealtime.FeedMessage getAlerts() {
        GtfsRealtime.FeedMessage.Builder feedMessage = this.createFeedWithDefaultHeader();
        List serviceAlerts = this._serviceAlertsService.getAllServiceAlerts();
        for (ServiceAlertRecord serviceAlert : serviceAlerts) {
            GtfsRealtime.TranslatedString translated;
            GtfsRealtime.Alert.Builder alert = GtfsRealtime.Alert.newBuilder();
            if (serviceAlert.getSummaries() != null) {
                for (ServiceAlertLocalizedString string : serviceAlert.getSummaries()) {
                    translated = this.convertTranslatedString(string);
                    alert.setHeaderText(translated);
                }
            }
            if (serviceAlert.getDescriptions() != null) {
                for (ServiceAlertLocalizedString string : serviceAlert.getDescriptions()) {
                    translated = this.convertTranslatedString(string);
                    alert.setDescriptionText(translated);
                }
            }
            for (ServiceAlertTimeRange range : serviceAlert.getActiveWindows()) {
                GtfsRealtime.TimeRange.Builder timeRange = GtfsRealtime.TimeRange.newBuilder();
                if (range.getFromValue() != null) {
                    timeRange.setStart(range.getFromValue().longValue());
                }
                if (range.getToValue() != null) {
                    timeRange.setEnd(range.getToValue().longValue());
                }
                alert.addActivePeriod(timeRange);
            }
            for (ServiceAlertsSituationAffectsClause affects : serviceAlert.getAllAffects()) {
                GtfsRealtime.EntitySelector.Builder entitySelector = GtfsRealtime.EntitySelector.newBuilder();
                if (affects.getAgencyId() != null) {
                    entitySelector.setAgencyId(affects.getAgencyId());
                }
                if (affects.getRouteId() != null) {
                    entitySelector.setRouteId(this.id(serviceAlert.getAgencyId(), affects.getRouteId()));
                }
                if (affects.getTripId() != null) {
                    GtfsRealtime.TripDescriptor.Builder trip = GtfsRealtime.TripDescriptor.newBuilder();
                    trip.setTripId(this.id(serviceAlert.getAgencyId(), affects.getTripId()));
                    entitySelector.setTrip(trip);
                }
                if (affects.getStopId() != null) {
                    entitySelector.setStopId(this.id(serviceAlert.getAgencyId(), affects.getStopId()));
                }
                alert.addInformedEntity(entitySelector);
            }
            GtfsRealtime.FeedEntity.Builder feedEntity = GtfsRealtime.FeedEntity.newBuilder();
            feedEntity.setAlert(alert);
            feedEntity.setId(this.id(serviceAlert.getAgencyId(), serviceAlert.getServiceAlertId()));
            feedMessage.addEntity(feedEntity);
        }
        return feedMessage.build();
    }

    private GtfsRealtime.FeedMessage.Builder createFeedWithDefaultHeader() {
        GtfsRealtime.FeedMessage.Builder feedMessage = GtfsRealtime.FeedMessage.newBuilder();
        GtfsRealtime.FeedHeader.Builder feedHeader = GtfsRealtime.FeedHeader.newBuilder();
        feedHeader.setIncrementality(GtfsRealtime.FeedHeader.Incrementality.FULL_DATASET);
        feedHeader.setGtfsRealtimeVersion("2.0");
        feedMessage.setHeader(feedHeader);
        return feedMessage;
    }

    private GtfsRealtime.TranslatedString convertTranslatedString(ServiceAlertLocalizedString ts) {
        GtfsRealtime.TranslatedString.Builder translated = GtfsRealtime.TranslatedString.newBuilder();
        GtfsRealtime.TranslatedString.Translation.Builder builder = GtfsRealtime.TranslatedString.Translation.newBuilder();
        builder.setText(ts.getValue());
        if (ts.getLanguage() != null) {
            builder.setLanguage(ts.getLanguage());
        }
        translated.addTranslation(builder);
        return translated.build();
    }

    private String id(String agencyId, String id) {
        return AgencyAndId.convertToString((AgencyAndId)new AgencyAndId(agencyId, id));
    }
}

