/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeNegativeArrivals;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GtfsRealtimeNegativeArrivalsImpl
implements GtfsRealtimeNegativeArrivals,
InitializingBean {
    private Map<String, Boolean> agencyNegativeScheduledArrivalMap = new HashMap<String, Boolean>();
    private Map<String, GtfsRealtimeSource> gtfsRealtimeSourceMap;

    @Autowired(required=false)
    public void setGtfsRealtimeSourceMap(Map<String, GtfsRealtimeSource> gtfsRealtimeSourceMap) {
        this.gtfsRealtimeSourceMap = gtfsRealtimeSourceMap;
    }

    public void afterPropertiesSet() throws Exception {
        this.init();
    }

    @PostConstruct
    public void init() {
        if (this.gtfsRealtimeSourceMap == null) {
            return;
        }
        for (Map.Entry<String, GtfsRealtimeSource> pair : this.gtfsRealtimeSourceMap.entrySet()) {
            GtfsRealtimeSource grs = pair.getValue();
            for (String id : grs.getAgencyIds()) {
                this.agencyNegativeScheduledArrivalMap.put(id, grs.getShowNegativeScheduledArrivals());
            }
        }
    }

    @Override
    public Boolean getShowNegativeScheduledArrivalByAgencyId(String agencyId) {
        return this.agencyNegativeScheduledArrivalMap.get(agencyId);
    }
}

