/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.List;
import org.onebusaway.alerts.impl.ServiceAlertLibrary;
import org.onebusaway.alerts.service.ServiceAlerts;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.services.ConsolidatedStopsService;
import org.onebusaway.transit_data_federation.services.RouteReplacementService;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GtfsRealtimeEntitySource {
    private static final Logger _log = LoggerFactory.getLogger(GtfsRealtimeEntitySource.class);
    private TransitGraphDao _transitGraphDao;
    private ConsolidatedStopsService _consolidatedStopsService;
    private RouteReplacementService _routeReplacementService;
    private List<String> _agencyIds;
    private List<String> _tripIdRegexs;

    GtfsRealtimeEntitySource() {
    }

    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    public void setConsolidatedStopService(ConsolidatedStopsService service) {
        this._consolidatedStopsService = service;
    }

    public void setRouteReplacementService(RouteReplacementService routeReplacementService) {
        this._routeReplacementService = routeReplacementService;
    }

    public void setAgencyIds(List<String> agencyIds) {
        this._agencyIds = agencyIds;
    }

    public void setTripIdRegexs(List<String> tripIdRegex) {
        this._tripIdRegexs = tripIdRegex;
    }

    public List<String> getTripIdRegexes() {
        return this._tripIdRegexs;
    }

    public RouteEntry getRoute(AgencyAndId routeId) {
        routeId = this.considerRouteReplacements(routeId);
        return this._transitGraphDao.getRouteForId(routeId);
    }

    private AgencyAndId considerRouteReplacements(AgencyAndId routeId) {
        if (this._routeReplacementService == null) {
            return routeId;
        }
        if (this._routeReplacementService.containsRoute(routeId)) {
            return this._routeReplacementService.replace(routeId);
        }
        return routeId;
    }

    public ServiceAlerts.Id getRouteId(String routeId) {
        AgencyAndId id3;
        for (String agencyId : this._agencyIds) {
            AgencyAndId id2 = new AgencyAndId(agencyId, routeId);
            RouteEntry route = this._transitGraphDao.getRouteForId(id2);
            if (route == null) continue;
            return ServiceAlertLibrary.id((AgencyAndId)route.getParent().getId());
        }
        try {
            id3 = AgencyAndId.convertFromString((String)routeId);
            RouteEntry route = this._transitGraphDao.getRouteForId(id3);
            if (route != null) {
                return ServiceAlertLibrary.id((AgencyAndId)route.getParent().getId());
            }
        }
        catch (IllegalArgumentException id3) {
            // empty catch block
        }
        id3 = new AgencyAndId(this._agencyIds.get(0), routeId);
        _log.warn("route not found with id \"{}\", defaulting to {}", (Object)routeId, (Object)id3);
        return ServiceAlertLibrary.id((AgencyAndId)id3);
    }

    public ServiceAlerts.Id getTripId(String tripId) {
        TripEntry trip = this.getTrip(tripId);
        if (trip != null) {
            return ServiceAlertLibrary.id((AgencyAndId)trip.getId());
        }
        _log.warn("trip not found with id \"{}\"", (Object)tripId);
        AgencyAndId id = new AgencyAndId(this._agencyIds.get(0), tripId);
        return ServiceAlertLibrary.id((AgencyAndId)id);
    }

    public TripEntry getTrip(String tripId) {
        if (this._tripIdRegexs != null) {
            for (String regex : this._tripIdRegexs) {
                TripEntry tripEntry = this.getTripInternal(tripId.replaceAll(regex, ""));
                if (tripEntry == null) continue;
                return tripEntry;
            }
        }
        return this.getTripInternal(tripId);
    }

    private TripEntry getTripInternal(String tripId) {
        for (String agencyId : this._agencyIds) {
            AgencyAndId id = new AgencyAndId(agencyId, tripId);
            TripEntry trip = this._transitGraphDao.getTripEntryForId(id);
            if (trip == null) continue;
            return trip;
        }
        try {
            AgencyAndId id = AgencyAndId.convertFromString((String)tripId);
            TripEntry trip = this._transitGraphDao.getTripEntryForId(id);
            if (trip != null) {
                return trip;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    public StopEntry getStop(AgencyAndId stopId) {
        return this._transitGraphDao.getStopEntryForId(stopId, false);
    }

    public ServiceAlerts.Id getStopId(String stopId) {
        AgencyAndId id3;
        for (String agencyId : this._agencyIds) {
            AgencyAndId id2 = new AgencyAndId(agencyId, stopId);
            StopEntry stop = this._transitGraphDao.getStopEntryForId(id2);
            if (stop == null) continue;
            return ServiceAlertLibrary.id((AgencyAndId)id2);
        }
        try {
            id3 = AgencyAndId.convertFromString((String)stopId);
            StopEntry stop = this._transitGraphDao.getStopEntryForId(id3);
            if (stop != null) {
                return ServiceAlertLibrary.id((AgencyAndId)id3);
            }
        }
        catch (IllegalArgumentException id3) {
            // empty catch block
        }
        if (this._consolidatedStopsService != null) {
            if (stopId.indexOf(95) > 0) {
                AgencyAndId consolidatedId = this._consolidatedStopsService.getConsolidatedStopIdForHiddenStopId(AgencyAndId.convertFromString((String)stopId));
                if (consolidatedId != null) {
                    return ServiceAlertLibrary.id((AgencyAndId)consolidatedId);
                }
            } else {
                for (String agencyId : this._agencyIds) {
                    AgencyAndId consolidatedId = this._consolidatedStopsService.getConsolidatedStopIdForHiddenStopId(new AgencyAndId(agencyId, stopId));
                    if (consolidatedId == null) continue;
                    return ServiceAlertLibrary.id((AgencyAndId)consolidatedId);
                }
            }
        }
        _log.warn("alert stop not found with id \"{}\"", (Object)stopId);
        id3 = new AgencyAndId(this._agencyIds.get(0), stopId);
        return ServiceAlertLibrary.id((AgencyAndId)id3);
    }

    public List<String> getAgencyIds() {
        return this._agencyIds;
    }

    public boolean isGraphReady() {
        try {
            return this._transitGraphDao != null && this._transitGraphDao.getAllRoutes() != null && !this._transitGraphDao.getAllRoutes().isEmpty();
        }
        catch (Throwable t) {
            return false;
        }
    }
}

