/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeCancelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GtfsRealtimeCanceledHarness {
    private static Logger _log = LoggerFactory.getLogger(GtfsRealtimeCanceledHarness.class);
    private int _refreshInterval = 0;
    private List<AgencyAndId> _routeIds = new ArrayList<AgencyAndId>();
    private GtfsRealtimeCancelService _service;
    private ScheduledFuture<?> _refreshTask;
    private ScheduledExecutorService _scheduledExecutorService;

    @Autowired
    public void setGtfsRealtimeCancelService(GtfsRealtimeCancelService service) {
        this._service = service;
    }

    public void setRefreshInterval(int refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    @Autowired
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutorService = scheduledExecutorService;
    }

    public void setRouteIds(String routeIdAsCsv) {
        block7: {
            if (routeIdAsCsv == null) break block7;
            if (routeIdAsCsv.contains(",")) {
                for (String s : routeIdAsCsv.split(",")) {
                    try {
                        this._routeIds.add(AgencyAndId.convertFromString((String)s));
                    }
                    catch (IllegalStateException ise) {
                        _log.error("invalid route {}", (Object)s);
                    }
                }
            } else {
                try {
                    this._routeIds.add(AgencyAndId.convertFromString((String)routeIdAsCsv));
                }
                catch (IllegalStateException ise) {
                    _log.error("invalid route {}", (Object)routeIdAsCsv);
                }
            }
        }
    }

    @PostConstruct
    public void start() {
        if (this._refreshInterval > 0) {
            this._refreshTask = this._scheduledExecutorService.scheduleAtFixedRate(new RefreshTask(), 0L, this._refreshInterval, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this._refreshTask != null) {
            this._refreshTask.cancel(true);
            this._refreshTask = null;
        }
    }

    public void refresh() {
        if (this._routeIds != null) {
            this._service.cancelServiceForRoutes(this._routeIds, System.currentTimeMillis());
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                GtfsRealtimeCanceledHarness.this.refresh();
            }
            catch (Throwable t) {
                _log.error("refresh exception: ", (Object)t, (Object)t);
            }
        }
    }
}

