/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.common.primitives.Doubles;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedStopInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockDescriptor;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeServiceSource;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockStopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.RouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicBlockConfigurationEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicBlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicRouteEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicStopEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicStopTimeEntryImpl;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicTripEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTripBuilder {
    private static Logger _log = LoggerFactory.getLogger(DynamicTripBuilder.class);
    private Map<String, DynamicRouteEntry> _routeCache = new PassiveExpiringMap(3600000L);
    private GtfsRealtimeServiceSource _serviceSource;
    private GtfsRealtimeEntitySource _entitySource;

    public void setServiceSource(GtfsRealtimeServiceSource serviceSource) {
        this._serviceSource = serviceSource;
    }

    public void setEntityource(GtfsRealtimeEntitySource dataSource) {
        this._entitySource = dataSource;
    }

    public BlockDescriptor createBlockDescriptor(AddedTripInfo addedTripInfo, long currentTime) {
        try {
            String validationMessage;
            BlockDescriptor dynamicBd = new BlockDescriptor();
            dynamicBd.setVehicleId(addedTripInfo.getVehicleId());
            dynamicBd.setScheduleRelationship(addedTripInfo.getScheduleRelationship());
            AgencyAndId blockId = new AgencyAndId(addedTripInfo.getAgencyId(), addedTripInfo.getTripId());
            BlockInstance instance = this._serviceSource.getBlockIndexService().getDynamicBlockInstance(blockId);
            if (instance != null && !this.tripPatternMatches(addedTripInfo, instance)) {
                if (this.isBlockUnderway(instance, addedTripInfo.getServiceDate(), currentTime)) {
                    dynamicBd.setMutated(true);
                }
                instance = null;
            }
            if (instance == null) {
                instance = this.createBlockInstance(addedTripInfo);
            }
            if ((validationMessage = this.isValid(instance)) != null) {
                _log.error("validation failed for additional trip {} with {}", (Object)addedTripInfo.getTripId(), (Object)validationMessage);
                return null;
            }
            dynamicBd.setBlockInstance(instance);
            dynamicBd.setStartTime(addedTripInfo.getTripStartTime());
            dynamicBd.setStartDate(new ServiceDate(new Date(addedTripInfo.getServiceDate())));
            return dynamicBd;
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return null;
        }
    }

    private boolean isBlockUnderway(BlockInstance instance, long serviceDate, long currentTime) {
        return this.isPastStop(instance, serviceDate, currentTime, 0);
    }

    private boolean isPastStop(BlockInstance instance, long serviceDate, long currentTime, int stopSequence) {
        long stopTime;
        BlockTripEntry blockTripEntry = instance.getBlock().getTrips().get(0);
        if (blockTripEntry.getStopTimes().isEmpty()) {
            return false;
        }
        BlockStopTimeEntry blockStopTimeEntry = blockTripEntry.getStopTimes().get(stopSequence);
        int time = 0;
        time = blockStopTimeEntry.getStopTime().getArrivalTime();
        if (time <= 0) {
            time = blockStopTimeEntry.getStopTime().getDepartureTime();
        }
        return (stopTime = (long)time + serviceDate) < currentTime;
    }

    private boolean tripPatternMatches(AddedTripInfo addedTripInfo, BlockInstance instance) {
        String lastAddedStop;
        int i = -1;
        String actualStops = this.fingerprintTripInfoStops(addedTripInfo.getStops());
        String expectedStops = this.fingerprintBlockStops(instance.getBlock().getStopTimes());
        return expectedStops.contains(actualStops) && ((lastAddedStop = this.lastStopIdAddedStop(addedTripInfo.getStops())) == null || lastAddedStop.equals(this.lastStopIdStopTime(instance.getBlock().getStopTimes())));
    }

    private String lastStopIdStopTime(List<BlockStopTimeEntry> stopTimes) {
        if (stopTimes != null && !stopTimes.isEmpty()) {
            return AgencyAndId.convertToString((AgencyAndId)stopTimes.get(stopTimes.size() - 1).getStopTime().getStop().getId());
        }
        return null;
    }

    private String lastStopIdAddedStop(List<AddedStopInfo> stops) {
        if (stops != null && !stops.isEmpty()) {
            return stops.get(stops.size() - 1).getStopId();
        }
        return null;
    }

    private String fingerprintTripInfoStops(List<AddedStopInfo> stops) {
        StringBuffer sb = new StringBuffer();
        if (stops == null) {
            return sb.toString();
        }
        for (AddedStopInfo stop : stops) {
            sb.append(stop.getStopId());
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private String fingerprintBlockStops(List<BlockStopTimeEntry> stopTimes) {
        StringBuffer sb = new StringBuffer();
        if (stopTimes == null) {
            return sb.toString();
        }
        for (BlockStopTimeEntry stopTime : stopTimes) {
            sb.append(stopTime.getStopTime().getStop().getId().getId());
            sb.append(",");
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private String isValid(BlockInstance instance) {
        if (instance == null) {
            return "NuLl instance";
        }
        if (instance.getServiceDate() < 1000L) {
            return "Invalid ServiceDate " + instance.getServiceDate();
        }
        if (instance.getState() == null) {
            return "Missing State";
        }
        if (instance.getBlock() == null) {
            return "Missing Block";
        }
        BlockConfigurationEntry block = instance.getBlock();
        if (block.getBlock() == null) {
            return "Null Block";
        }
        if (block.getTrips() == null || block.getTrips().isEmpty()) {
            return "Empty Trips";
        }
        BlockTripEntry blockTripEntry = block.getTrips().get(0);
        if (blockTripEntry.getTrip() == null) {
            return "Empty BlockTrip";
        }
        if (blockTripEntry.getTrip().getId() == null) {
            return "Missing BlockTrip Id";
        }
        if (blockTripEntry.getTrip().getId().getId() == null) {
            return "Missing BlockTrip Id.id";
        }
        if (blockTripEntry.getStopTimes() == null || blockTripEntry.getStopTimes().isEmpty()) {
            return "No StopTImes";
        }
        return null;
    }

    private BlockInstance createBlockInstance(AddedTripInfo addedTripInfo) {
        BlockConfigurationEntry blockConfiguration = this.createBlockConfiguration(addedTripInfo);
        if (blockConfiguration == null) {
            return null;
        }
        return new BlockInstance(blockConfiguration, addedTripInfo.getServiceDate());
    }

    private BlockConfigurationEntry createBlockConfiguration(AddedTripInfo addedTripInfo) {
        DynamicBlockConfigurationEntryImpl.Builder configBuilder = DynamicBlockConfigurationEntryImpl.builder();
        BlockEntry blockEntry = this.createBlockEntry(addedTripInfo);
        configBuilder.setBlock(blockEntry);
        configBuilder.setServiceIds(this.createServiceIdActivation(addedTripInfo));
        configBuilder.setTrips(new ArrayList<TripEntry>());
        TripEntry trip = this.createTrip(addedTripInfo, blockEntry);
        if (trip == null) {
            return null;
        }
        configBuilder.getTrips().add(trip);
        DynamicBlockConfigurationEntryImpl config = new DynamicBlockConfigurationEntryImpl(configBuilder);
        blockEntry.getConfigurations().add(config);
        return config;
    }

    private TripEntry createTrip(AddedTripInfo addedTripInfo, BlockEntry block) {
        DynamicTripEntryImpl trip = new DynamicTripEntryImpl();
        trip.setId(new AgencyAndId(addedTripInfo.getAgencyId(), addedTripInfo.getTripId()));
        DynamicRouteEntry route = this.createRoute(addedTripInfo);
        if (route == null) {
            return null;
        }
        trip.setRoute(route);
        trip.setDirectionId(this.getGtfsDirectionId(addedTripInfo.getDirectionId()));
        trip.setBlock(block);
        trip.setServiceId(this.createLocalizedServiceId(addedTripInfo));
        trip.setStopTimes(this.createStopTimes(addedTripInfo, trip));
        trip.setTotalTripDistance(this.calculateTripDistance(trip));
        if (trip.getStopTimes() == null || trip.getStopTimes().isEmpty()) {
            _log.debug("aborting trip creation {} with no stops", (Object)addedTripInfo.getTripId());
            return null;
        }
        trip.setShapeId(this.createShape(trip, new AgencyAndId(trip.getId().getAgencyId(), trip.getId().getId())));
        return trip;
    }

    private AgencyAndId createShape(DynamicTripEntryImpl trip, AgencyAndId shapeId) {
        ShapePoints shapePointsForShapeId = this._serviceSource.getShapePointService().getShapePointsForShapeId(shapeId);
        if (shapePointsForShapeId == null) {
            this.createShapePoints(trip, shapeId);
        }
        return shapeId;
    }

    private void createShapePoints(DynamicTripEntryImpl trip, AgencyAndId shapeId) {
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        for (StopTimeEntry stopTimeEntry : trip.getStopTimes()) {
            CoordinatePoint stopLocation = stopTimeEntry.getStop().getStopLocation();
            lats.add(stopLocation.getLat());
            lons.add(stopLocation.getLon());
        }
        ShapePoints shapePoints = new ShapePoints();
        shapePoints.setShapeId(shapeId);
        shapePoints.setLats(lats.stream().mapToDouble(Double::doubleValue).toArray());
        shapePoints.setLons(lons.stream().mapToDouble(Double::doubleValue).toArray());
        shapePoints.ensureDistTraveled();
        this._serviceSource.getNarrativeService().addShapePoints(shapePoints);
    }

    private String getGtfsDirectionId(String directionFlag) {
        if ("N".equalsIgnoreCase(directionFlag)) {
            return "0";
        }
        if ("S".equalsIgnoreCase(directionFlag)) {
            return "1";
        }
        return directionFlag;
    }

    private List<StopTimeEntry> createStopTimes(AddedTripInfo addedTripInfo, DynamicTripEntryImpl trip) {
        ArrayList<StopTimeEntry> stops = new ArrayList<StopTimeEntry>();
        int sequence = 0;
        for (AddedStopInfo stopInfo : addedTripInfo.getStops()) {
            if (stopInfo == null) continue;
            StopEntry stop = this.findStop(addedTripInfo.getAgencyId(), stopInfo.getStopId());
            if (stop == null) {
                _log.debug("no such stop {}", (Object)stopInfo.getStopId());
                continue;
            }
            DynamicStopTimeEntryImpl stopTime = new DynamicStopTimeEntryImpl();
            stopTime.setStop(this.copyFromStop(stop));
            if (stopInfo.getArrivalTime() > 0L) {
                stopTime.setArrivalTime(this.toSecondsInDay(stopInfo.getArrivalTime(), addedTripInfo.getServiceDate()));
            }
            if (stopInfo.getDepartureTime() > 0L) {
                stopTime.setDepartureTime(this.toSecondsInDay(stopInfo.getDepartureTime(), addedTripInfo.getServiceDate()));
            }
            stopTime.setSequence(sequence);
            stopTime.setTrip(trip);
            if (stopTime.getArrivalTime() < 1 && stopTime.getDepartureTime() < 1) {
                _log.error("invalid stoptime -- no data for stop {} on trip {} with arrival {}/departure {} ", new Object[]{stopTime.getId(), trip.getId(), stopTime.getArrivalTime(), stopTime.getDepartureTime()});
                continue;
            }
            ++sequence;
            stops.add(stopTime);
        }
        ShapePoints shapePoints = null;
        shapePoints = this.loadShapePoints(trip, stops);
        this._serviceSource.getStopTimeEntriesFactory().ensureStopTimesHaveShapeDistanceTraveledSet(stops, shapePoints);
        return stops;
    }

    private ShapePoints loadShapePoints(DynamicTripEntryImpl trip, List<StopTimeEntry> stops) {
        ShapePoints result = new ShapePoints();
        result.setShapeId(trip.getShapeId());
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        if (stops != null) {
            for (StopTimeEntry stopTime : stops) {
                if (stopTime == null || stopTime.getStop() == null) continue;
                lats.add(stopTime.getStop().getStopLat());
                lons.add(stopTime.getStop().getStopLon());
            }
            result.setLats(Doubles.toArray(lats));
            result.setLons(Doubles.toArray(lons));
            return result;
        }
        return null;
    }

    private int toSecondsInDay(long time, long serviceDate) {
        if (time > Integer.MAX_VALUE) {
            return Math.toIntExact((time - serviceDate) / 1000L);
        }
        return Math.toIntExact(time);
    }

    private DynamicStopEntryImpl copyFromStop(StopEntry staticStop) {
        return new DynamicStopEntryImpl(staticStop.getId(), staticStop.getStopLat(), staticStop.getStopLon(), staticStop.getParent());
    }

    private StopEntry findStop(String agencyId, String stopId) {
        return this._entitySource.getStop(new AgencyAndId(agencyId, stopId));
    }

    private double calculateTripDistance(DynamicTripEntryImpl trip) {
        double distance = 0.0;
        if (trip.getStopTimes() == null || trip.getStopTimes().size() < 2) {
            return distance;
        }
        CoordinatePoint lastLocation = null;
        for (StopTimeEntry stopTime : trip.getStopTimes()) {
            if (lastLocation == null) {
                lastLocation = stopTime.getStop().getStopLocation();
                continue;
            }
            CoordinatePoint stopLocation = stopTime.getStop().getStopLocation();
            distance += SphericalGeometryLibrary.distance((CoordinatePoint)lastLocation, (CoordinatePoint)stopLocation);
            lastLocation = stopLocation;
        }
        return distance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicRouteEntry createRoute(AddedTripInfo addedTripInfo) {
        String routeId = addedTripInfo.getRouteId();
        if (!this._routeCache.containsKey(routeId)) {
            RouteEntry staticRouteEntry = this.findRouteEntry(addedTripInfo.getAgencyId(), routeId);
            if (staticRouteEntry == null) {
                _log.error("no such route " + routeId);
                return null;
            }
            Map<String, DynamicRouteEntry> map = this._routeCache;
            synchronized (map) {
                if (!this._routeCache.containsKey(routeId)) {
                    this._routeCache.put(routeId, this.copyFromRoute(staticRouteEntry));
                }
            }
        }
        return this._routeCache.get(routeId);
    }

    private DynamicRouteEntry copyFromRoute(RouteEntry staticRouteEntry) {
        DynamicRouteEntry route = new DynamicRouteEntry();
        route.setId(staticRouteEntry.getId());
        route.setParent(staticRouteEntry.getParent());
        route.setTrips(new ArrayList<TripEntry>());
        route.setType(staticRouteEntry.getType());
        return route;
    }

    private RouteEntry findRouteEntry(String agency, String routeId) {
        return this._entitySource.getRoute(new AgencyAndId(agency, routeId));
    }

    private BlockEntry createBlockEntry(AddedTripInfo addedTripInfo) {
        DynamicBlockEntry entry = new DynamicBlockEntry();
        entry.setId(new AgencyAndId(addedTripInfo.getAgencyId(), addedTripInfo.getTripId()));
        entry.setConfigurations(new ArrayList<BlockConfigurationEntry>());
        return entry;
    }

    private ServiceIdActivation createServiceIdActivation(AddedTripInfo addedTripInfo) {
        return new ServiceIdActivation(this.createLocalizedServiceId(addedTripInfo));
    }

    private LocalizedServiceId createLocalizedServiceId(AddedTripInfo addedTripInfo) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String serviceIdDate = sdf.format(addedTripInfo.getServiceDate());
        LocalizedServiceId serviceId = new LocalizedServiceId(new AgencyAndId(addedTripInfo.getAgencyId(), "DYN-" + serviceIdDate), TimeZone.getDefault());
        return serviceId;
    }
}

