/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DuplicatedTripService;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DuplicatedTripServiceParser;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DuplicatedTripServiceParserImpl;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeEntitySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicatedTripServiceImpl
implements DuplicatedTripService {
    private static final Logger _log = LoggerFactory.getLogger(DuplicatedTripServiceImpl.class);
    private GtfsRealtimeEntitySource _entitySource;
    private DuplicatedTripServiceParser duplicatedTripServiceParser = null;

    public void setGtfsRealtimeEntitySource(GtfsRealtimeEntitySource source) {
        this._entitySource = source;
    }

    @Override
    public AddedTripInfo handleDuplicatedDescriptor(GtfsRealtime.TripUpdate tu) {
        try {
            return this.getParser().parse(tu);
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return null;
        }
    }

    private DuplicatedTripServiceParser getParser() {
        if (this.duplicatedTripServiceParser == null) {
            this.duplicatedTripServiceParser = new DuplicatedTripServiceParserImpl();
            this.duplicatedTripServiceParser.setGtfsRealtimeEntitySource(this._entitySource);
        }
        return this.duplicatedTripServiceParser;
    }
}

