/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.HashMap;
import java.util.Map;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.DataSourceMonitor;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.springframework.stereotype.Component;

@Component
public class DataSourceMonitorImpl
implements DataSourceMonitor {
    private boolean _initialized = false;
    private long _refreshIntervalMillis = 60000L;
    private ExternalServices _externalServices = null;
    private Map<String, Long> _lastUpdateByFeedId = new HashMap<String, Long>();

    @Override
    public void logUpdate(MonitoredResult result) {
        ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
        if (es != null) {
            this.logUpdate(es, result);
        }
    }

    private void logUpdate(ExternalServices es, MonitoredResult result) {
        long lastUpdate = this.getLastUpdate(result);
        if (this.hasUpdateExpired(lastUpdate)) {
            this.publishMetric(es, result);
            this.markUpdated(result);
        }
    }

    private void markUpdated(MonitoredResult result) {
        String feedId = result.getFeedId();
        this._lastUpdateByFeedId.put(feedId, System.currentTimeMillis());
    }

    private void publishMetric(ExternalServices es, MonitoredResult result) {
        String feedId = result.getFeedId();
        String env = System.getProperty("oba.cloud.env");
        if (env == null) {
            env = "test";
        }
        es.publishMetric(env, "Matched", "feed", feedId, (double)result.getMatchedTripIds().size());
        es.publishMetric(env, "Added", "feed", feedId, (double)result.getAddedTripIds().size());
        es.publishMetric(env, "Duplicated", "feed", feedId, (double)result.getDuplicatedTripIds().size());
        es.publishMetric(env, "Canceled", "feed", feedId, (double)result.getCancelledTripIds().size());
        es.publishMetric(env, "Unmatched", "feed", feedId, (double)result.getUnmatchedTripIds().size());
        es.publishMetric(env, "Total", "feed", feedId, (double)(result.getMatchedTripIds().size() + result.getAddedTripIds().size() + result.getDuplicatedTripIds().size() + result.getCancelledTripIds().size() + result.getUnmatchedTripIds().size()));
    }

    private boolean hasUpdateExpired(long lastUpdate) {
        return lastUpdate + this._refreshIntervalMillis < System.currentTimeMillis();
    }

    private long getLastUpdate(MonitoredResult result) {
        String feedId = result.getFeedId();
        if (this._lastUpdateByFeedId.containsKey(feedId)) {
            return this._lastUpdateByFeedId.get(feedId);
        }
        return 0L;
    }

    private ExternalServices getExternalServices() {
        if (!this._initialized) {
            try {
                this._externalServices = new ExternalServicesBridgeFactory().getExternalServices();
            }
            finally {
                this._initialized = true;
            }
        }
        return this._externalServices;
    }
}

