/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockDescriptor;

class CombinedTripUpdatesAndVehiclePosition
implements Comparable<CombinedTripUpdatesAndVehiclePosition> {
    public BlockDescriptor block;
    private TreeSet<GtfsRealtime.TripUpdate> tripUpdates = new TreeSet(new TripComparator());
    public GtfsRealtime.VehiclePosition vehiclePosition;

    CombinedTripUpdatesAndVehiclePosition() {
    }

    public void setTripUpdates(List<GtfsRealtime.TripUpdate> updates) {
        this.tripUpdates.addAll(updates);
    }

    public List<GtfsRealtime.TripUpdate> getTripUpdates() {
        return new ArrayList<GtfsRealtime.TripUpdate>(this.tripUpdates);
    }

    public int getTripUpdatesSize() {
        return this.tripUpdates.size();
    }

    @Override
    public int compareTo(CombinedTripUpdatesAndVehiclePosition o) {
        return this.block.getBlockInstance().getBlock().getBlock().getId().compareTo(o.block.getBlockInstance().getBlock().getBlock().getId());
    }

    public String toString() {
        return "block=" + (this.block != null ? this.block.toString() : "empty") + " tripUpdates=" + this.tripUpdates.toString() + (String)(this.vehiclePosition != null ? " vehiclePosition=" + this.vehiclePosition.toString() : "");
    }

    private class TripComparator
    implements Comparator {
        private TripComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            GtfsRealtime.TripUpdate t1 = (GtfsRealtime.TripUpdate)o1;
            GtfsRealtime.TripUpdate t2 = (GtfsRealtime.TripUpdate)o2;
            if (this.verifyStartTime(t1) && this.verifyStartTime(t2)) {
                return Math.toIntExact(this.parseDate(t1.getTrip().getStartDate(), t1.getTrip().getStartTime()) - this.parseDate(t2.getTrip().getStartDate(), t2.getTrip().getStartTime()));
            }
            return t1.getTrip().getTripId().compareTo(t2.getTrip().getTripId());
        }

        private long parseDate(String startDate, String startTime) throws IllegalStateException {
            if (startDate == null || startDate.length() == 0) {
                startDate = "00000000";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd hh:mm:ss");
            try {
                return sdf.parse(startDate + " " + startTime).getTime();
            }
            catch (ParseException e) {
                throw new IllegalStateException("invalid date format: " + startDate + " " + startTime);
            }
        }

        private boolean verifyStartTime(GtfsRealtime.TripUpdate t) {
            return t.hasTrip() && t.getTrip().hasStartTime();
        }
    }
}

