/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.onebusaway.collections.MappingLibrary;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockServiceDate;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.dynamic.DynamicBlockConfigurationEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockFinder {
    private static Logger _log = LoggerFactory.getLogger(BlockFinder.class);
    private final BlockCalendarService _blockCalendarService;
    public final Map<AgencyAndId, BlockServiceDate> _cache = new PassiveExpiringMap(1800000L);

    public BlockFinder(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Refreshable(dependsOn={"transitGraph"})
    public void reset() {
        this._cache.clear();
    }

    public BlockServiceDate getBlockServiceDateFromTrip(TripEntry tripEntry, long currentTime) {
        if (!this._cache.containsKey(tripEntry.getId())) {
            BlockServiceDate blockServiceDate = this.getBlockServiceDateFromTripUnCached(tripEntry, currentTime);
            this._cache.put(tripEntry.getId(), blockServiceDate);
        }
        return this._cache.get(tripEntry.getId());
    }

    private BlockServiceDate getBlockServiceDateFromTripUnCached(TripEntry tripEntry, long currentTime) {
        List<ServiceDate> possibleServiceDates = this.getPossibleServiceDates(currentTime);
        for (ServiceDate serviceDateGuess : possibleServiceDates) {
            int adjustedTripStartTime;
            BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(tripEntry.getBlock().getId(), serviceDateGuess.getAsDate().getTime());
            if (blockInstance == null) continue;
            ServiceDate serviceDate = new ServiceDate(new Date(blockInstance.getServiceDate()));
            Integer tripStartTime = this.getTripStartTime(blockInstance, tripEntry);
            if (tripStartTime == null || (adjustedTripStartTime = this.getBlockStartTimeForTripStartTime(blockInstance, tripEntry.getId(), tripStartTime)) <= 0) continue;
            return new BlockServiceDate(serviceDate, blockInstance, adjustedTripStartTime);
        }
        _log.error("block {} of trip {} not found on service dates {}", new Object[]{tripEntry.getBlock().getId(), tripEntry.getId(), possibleServiceDates});
        return null;
    }

    private Integer getTripStartTime(BlockInstance blockInstance, TripEntry tripEntry) {
        for (BlockTripEntry testTrip : blockInstance.getBlock().getTrips()) {
            if (!testTrip.getTrip().getId().equals((Object)tripEntry.getId())) continue;
            return testTrip.getTrip().getStopTimes().get(0).getDepartureTime();
        }
        return null;
    }

    private List<ServiceDate> getPossibleServiceDates(long currentTime) {
        ArrayList<ServiceDate> possibleDates = new ArrayList<ServiceDate>();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        if (cal.get(11) < 4) {
            possibleDates.add(this.yesterday(currentTime));
        }
        possibleDates.add(this.today(currentTime));
        if (cal.get(11) > 20) {
            possibleDates.add(this.tomorrow(currentTime));
        }
        return possibleDates;
    }

    private ServiceDate tomorrow(long currentTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        cal.add(5, 1);
        return new ServiceDate(cal);
    }

    private ServiceDate yesterday(long currentTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(currentTime);
        cal.add(5, -1);
        return new ServiceDate(cal);
    }

    private ServiceDate today(long currentTime) {
        return new ServiceDate(new Date(currentTime));
    }

    private int getBlockStartTimeForTripStartTime(BlockInstance instance, AgencyAndId tripId, int tripStartTime) {
        BlockConfigurationEntry block = instance.getBlock();
        if (block.getTrips() == null || block.getTrips().isEmpty()) {
            _log.debug("no trips for trip start time on block {}", (Object)block.getBlock().getId());
            return -1;
        }
        Map blockTripsById = null;
        try {
            blockTripsById = MappingLibrary.mapToValue(block.getTrips(), (String)"trip.id");
        }
        catch (IllegalStateException ise) {
            if (block instanceof DynamicBlockConfigurationEntryImpl) {
                return block.getDepartureTimeForIndex(0);
            }
            _log.debug("invalid block {}", (Object)block.getBlock().getId());
            return -1;
        }
        int rawBlockStartTime = block.getDepartureTimeForIndex(0);
        if (!blockTripsById.containsKey(tripId)) {
            _log.debug("getBlockStartTimeForTripStartTime(" + instance + ", " + tripId + ", " + tripStartTime + ") did not find matching trip; aborting");
            return -1;
        }
        int rawTripStartTime = ((BlockTripEntry)blockTripsById.get(tripId)).getDepartureTimeForIndex(0);
        int adjustedBlockStartTime = rawBlockStartTime + (tripStartTime - rawTripStartTime);
        if (adjustedBlockStartTime < 0) {
            return rawBlockStartTime;
        }
        return adjustedBlockStartTime;
    }
}

