/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import com.google.transit.realtime.GtfsRealtime;
import com.google.transit.realtime.GtfsRealtimeNYCT;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedStopInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedTripService;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.GtfsRealtimeServiceSource;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.NyctTripService;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.NyctTripServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddedTripServiceImpl
implements AddedTripService {
    private static final Logger _log = LoggerFactory.getLogger(AddedTripServiceImpl.class);
    private NyctTripService nycService = new NyctTripServiceImpl();

    @Override
    public AddedTripInfo handleNyctDescriptor(GtfsRealtimeServiceSource serviceSource, GtfsRealtime.TripUpdate tu, GtfsRealtimeNYCT.NyctTripDescriptor nyctTripDescriptor, long currentTime) {
        AddedTripInfo info = this.nycService.parse(tu, nyctTripDescriptor, currentTime);
        if (info != null && info.getStops() != null) {
            for (AddedStopInfo addedStop : info.getStops()) {
                this.enforceWrongwayConcurrency(serviceSource, info, addedStop);
            }
        }
        return info;
    }

    @Override
    public AddedTripInfo handleAddedDescriptor(GtfsRealtimeServiceSource serviceSource, String agencyId, GtfsRealtime.TripUpdate tu, long currentTime) {
        try {
            AddedTripInfo addedTrip = new AddedTripInfo();
            if (!tu.hasTrip()) {
                return null;
            }
            GtfsRealtime.TripDescriptor trip = tu.getTrip();
            addedTrip.setAgencyId(agencyId);
            addedTrip.setTripId(trip.getTripId());
            addedTrip.setTripStartTime(this.parseTripStartTime(trip.getStartTime()));
            addedTrip.setServiceDate(AddedTripInfo.getStartOfDay(new Date(currentTime)).getTime());
            addedTrip.setScheduleRelationshipValue(trip.getScheduleRelationship().toString());
            addedTrip.setRouteId(trip.getRouteId());
            addedTrip.setDirectionId(String.valueOf(trip.getDirectionId()));
            for (GtfsRealtime.TripUpdate.StopTimeUpdate stopTimeUpdate : tu.getStopTimeUpdateList()) {
                AddedStopInfo stopInfo = new AddedStopInfo();
                if (stopTimeUpdate.hasStopId()) {
                    stopInfo.setStopId(stopTimeUpdate.getStopId());
                }
                if (stopTimeUpdate.hasArrival() && stopTimeUpdate.getArrival().getTime() > 0L) {
                    stopInfo.setArrivalTime(stopTimeUpdate.getArrival().getTime() * 1000L);
                }
                if (stopTimeUpdate.hasDeparture() && stopTimeUpdate.getDeparture().getTime() > 0L) {
                    stopInfo.setDepartureTime(stopTimeUpdate.getDeparture().getTime() * 1000L);
                }
                if (stopInfo.getArrivalTime() <= 0L && stopInfo.getDepartureTime() <= 0L) continue;
                this.enforceWrongwayConcurrency(serviceSource, addedTrip, stopInfo);
                addedTrip.addStopTime(stopInfo);
            }
            return addedTrip;
        }
        catch (Throwable t) {
            _log.error("source-exception {}", (Object)t, (Object)t);
            return null;
        }
    }

    private void enforceWrongwayConcurrency(GtfsRealtimeServiceSource serviceSource, AddedTripInfo info, AddedStopInfo stopInfo) {
        if (stopInfo == null) {
            return;
        }
        StopDirectionSwap swap = serviceSource.getStopSwapService().findStopDirectionSwap(new AgencyAndId(info.getAgencyId(), info.getRouteId()), this.mapDirection(info.getDirectionId()), new AgencyAndId(info.getAgencyId(), stopInfo.getStopId()));
        if (swap == null) {
            return;
        }
        stopInfo.setStopId(swap.getToStop().getId());
    }

    private String mapDirection(String compassDirection) {
        if ("N".equals(compassDirection)) {
            return "0";
        }
        if ("S".equals(compassDirection)) {
            return "1";
        }
        return "-1";
    }

    private int parseTripStartTime(String startTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(startTime);
        }
        catch (ParseException e) {
            return -1;
        }
        return Math.toIntExact(date.getTime() / 1000L);
    }
}

