/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.AddedStopInfo;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.BlockDescriptor;

public class AddedTripInfo {
    private String agencyId;
    private int tripStartTime = 0;
    private long serviceDate = -1L;
    private String tripId = null;
    private AgencyAndId shapeId;
    private String routeId = null;
    private String directionId = null;
    private String vehicleId = null;
    private List<AddedStopInfo> stops = new ArrayList<AddedStopInfo>();
    private BlockDescriptor.ScheduleRelationship scheduleRelationship;

    public BlockDescriptor.ScheduleRelationship getScheduleRelationship() {
        return this.scheduleRelationship;
    }

    public void setScheduleRelationshipValue(String value) {
        this.scheduleRelationship = BlockDescriptor.ScheduleRelationship.valueOf(value);
    }

    public AgencyAndId getShapeId() {
        return this.shapeId;
    }

    public void setShapeId(AgencyAndId shapeId) {
        this.shapeId = shapeId;
    }

    public boolean hasServiceDate() {
        return this.serviceDate > 0L;
    }

    public int getTripStartTime() {
        return this.tripStartTime;
    }

    public void setTripStartTime(int tripStartTime) {
        this.tripStartTime = tripStartTime;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getTripId() {
        return this.tripId;
    }

    public void setTripId(String tripId) {
        this.tripId = tripId;
    }

    public String getDirectionId() {
        return this.directionId;
    }

    public void setDirectionId(String directionId) {
        this.directionId = directionId;
    }

    public void addStopTime(AddedStopInfo stopInfo) {
        this.stops.add(stopInfo);
    }

    public List<AddedStopInfo> getStops() {
        return this.stops;
    }

    public void setStops(List<AddedStopInfo> stops) {
        this.stops = stops;
    }

    public void setServiceDateFromStopTime(long time) {
        this.serviceDate = AddedTripInfo.getStartOfDay(new Date(time)).getTime();
    }

    public static Date getStartOfDay(Date serviceDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(serviceDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public long getServiceDate() {
        return this.serviceDate;
    }

    public void setServiceDate(long time) {
        this.serviceDate = time;
    }

    public String getAgencyId() {
        return this.agencyId;
    }

    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    public String getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(String vehicleId) {
        this.vehicleId = vehicleId;
    }
}

