/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.realtime.api.VehicleLocationListener;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.gtfs_realtime.MonitoredResult;
import org.onebusaway.transit_data_federation.impl.transit_graph.TransitGraphDaoImpl;
import org.onebusaway.transit_data_federation.services.blocks.BlockGeospatialService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.ServiceIdActivation;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.transit_data_federation.testing.UnitTestingSupport;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiriLikeRealtimeSource {
    private static final Logger _log = LoggerFactory.getLogger(SiriLikeRealtimeSource.class);
    private static SimpleDateFormat ISO_DATE_SHORT_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
    private static SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSXXX");
    public List<String> _routeList = new ArrayList<String>();
    private XPathExpression mvjExpression;
    private XPathExpression tripIdExpression;
    private XPathExpression serviceDateExpression;
    private XPathExpression recordedAtExpression;
    private XPathExpression vehicleIdExpression;
    private XPathExpression latExpression;
    private XPathExpression lonExpression;
    private TransitGraphDaoImpl _transitGraphDao;
    private BlockGeospatialService _blockGeospatialService;
    private VehicleLocationListener _vehicleLocationListener;
    private ScheduledExecutorService _scheduledExecutorService;
    private ScheduledFuture<?> _refreshTask;
    private DocumentBuilderFactory factory;
    private DocumentBuilder builder;
    private String _agency;
    private String _baseUrl;
    private String _apiKey;
    private int _refreshInterval = 30;

    public void setApiKey(String key) {
        this._apiKey = key;
    }

    public String getApiKey() {
        return this._apiKey;
    }

    public void setBaseUrl(String url) {
        this._baseUrl = url;
    }

    public String getUrl() {
        return this._baseUrl;
    }

    public void setAgency(String agencyId) {
        this._agency = agencyId;
    }

    private String getAgency() {
        return this._agency;
    }

    public void setRefreshInterval(int refreshInterval) {
        this._refreshInterval = refreshInterval;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDaoImpl transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockGeospatialService(BlockGeospatialService blockGeospatialService) {
        this._blockGeospatialService = blockGeospatialService;
    }

    @Autowired
    public void setVehicleLocationListener(VehicleLocationListener vehicleLocationListener) {
        this._vehicleLocationListener = vehicleLocationListener;
    }

    @Autowired
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this._scheduledExecutorService = scheduledExecutorService;
    }

    @PostConstruct
    public void setup() throws Exception {
        ISO_DATE_FORMAT.setLenient(false);
        ISO_DATE_SHORT_FORMAT.setLenient(false);
        this.factory = DocumentBuilderFactory.newInstance();
        this.builder = this.factory.newDocumentBuilder();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        this.mvjExpression = xpath.compile("/Siri/VehicleMonitoringDelivery/VehicleActivity/MonitoredVehicleJourney");
        this.tripIdExpression = xpath.compile("FramedVehicleJourneyRef/DatedVehicleJourneyRef/text()");
        this.serviceDateExpression = xpath.compile("FramedVehicleJourneyRef/DataFrameRef/text()");
        this.recordedAtExpression = xpath.compile("/Siri/VehicleMonitoringDelivery/VehicleActivity/RecordedAtTime/text()");
        this.vehicleIdExpression = xpath.compile("VehicleRef/text()");
        this.latExpression = xpath.compile("VehicleLocation/Latitude/text()");
        this.lonExpression = xpath.compile("VehicleLocation/Longitude/text()");
        if (this._refreshInterval > 0) {
            this._refreshTask = this._scheduledExecutorService.scheduleAtFixedRate(new RefreshTask(), 0L, this._refreshInterval, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void stop() {
        if (this._refreshTask != null) {
            this._refreshTask.cancel(true);
            this._refreshTask = null;
        }
    }

    public void setRoutes(List<String> routes) {
        this._routeList = routes;
    }

    public List<String> getRoutes() {
        return this._routeList;
    }

    public void refresh() throws Exception {
        MonitoredResult result = new MonitoredResult();
        this.handleUpdates(result);
    }

    private synchronized void handleUpdates(MonitoredResult result) throws Exception {
        int vehicles = 0;
        int trips = 0;
        for (String route : this.getRoutes()) {
            NodesAndTimestamp nodesAndTimestamp = this.parseVehicles(new URL(this.constructUrl(route, this.getApiKey(), this.getUrl())));
            _log.debug("found " + nodesAndTimestamp.getNodes().size() + " nodes");
            for (Node n : nodesAndTimestamp.getNodes()) {
                ++vehicles;
                VehicleLocationRecord vlr = this.parse(n, nodesAndTimestamp.getTimestamp());
                if (vlr == null) continue;
                ++trips;
                result.addMatchedTripId(vlr.getTripId().getId());
                try {
                    this._vehicleLocationListener.handleVehicleLocationRecord(vlr);
                }
                catch (Exception exception) {}
            }
        }
        _log.info("updated " + trips + " of " + vehicles + " for agency " + this.getAgency());
    }

    private String constructUrl(String route, String apiKey, String url) {
        return url + "?route=" + route + "&usertoken=" + apiKey;
    }

    public NodesAndTimestamp parseVehicles(URL url) throws Exception {
        ArrayList<Node> vehicles = new ArrayList<Node>();
        Document doc = this.builder.parse(url.toString());
        String recordedAtStr = (String)this.recordedAtExpression.evaluate(doc, XPathConstants.STRING);
        long timestamp = this.parseDate(recordedAtStr).getTime();
        _log.debug("timestamp=" + new Date(timestamp) + " for date " + recordedAtStr);
        NodeList nl = (NodeList)this.mvjExpression.evaluate(doc, XPathConstants.NODESET);
        if (nl == null || nl.getLength() == 0) {
            _log.debug("no nodes found");
            return new NodesAndTimestamp(vehicles, timestamp);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            vehicles.add(nl.item(i));
        }
        return new NodesAndTimestamp(vehicles, timestamp);
    }

    public VehicleLocationRecord parse(Node node, long timestamp) throws Exception {
        String tripId = (String)this.tripIdExpression.evaluate(node, XPathConstants.STRING);
        if (tripId == null) {
            _log.error("no trip for node=" + node);
            return null;
        }
        if (timestamp == 0L) {
            timestamp = SystemTime.currentTimeMillis();
        }
        String serviceDateStr = (String)this.serviceDateExpression.evaluate(node, XPathConstants.STRING);
        Date serviceDate = this.parseServiceDate(serviceDateStr);
        VehicleLocationRecord vlr = new VehicleLocationRecord();
        try {
            vlr.setTimeOfLocationUpdate(timestamp);
            vlr.setTimeOfRecord(timestamp);
            vlr.setTripId(new AgencyAndId(this.getAgency(), tripId));
            vlr.setServiceDate(serviceDate.getTime());
            vlr.setVehicleId(new AgencyAndId(this.getAgency(), (String)this.vehicleIdExpression.evaluate(node, XPathConstants.STRING)));
            vlr.setCurrentLocationLat(this.asDouble(this.latExpression.evaluate(node, XPathConstants.STRING)));
            vlr.setCurrentLocationLon(this.asDouble(this.lonExpression.evaluate(node, XPathConstants.STRING)));
            Integer scheduleDeviation = this.calculateScheduleDeviation(vlr);
            if (scheduleDeviation != null) {
                vlr.setScheduleDeviation((double)scheduleDeviation.intValue());
            }
        }
        catch (NumberFormatException nfe) {
            _log.info("caught nfe", (Throwable)nfe);
            return null;
        }
        _log.debug("return vlr=" + vlr);
        return vlr;
    }

    protected Integer calculateScheduleDeviation(VehicleLocationRecord vlr) {
        TripEntry tripEntry = this._transitGraphDao.getTripEntryForId(vlr.getTripId());
        if (tripEntry != null) {
            vlr.setBlockId(tripEntry.getBlock().getId());
            long time = vlr.getTimeOfLocationUpdate() / 1000L;
            double lat = vlr.getCurrentLocationLat();
            double lon = vlr.getCurrentLocationLon();
            long serviceDateTime = vlr.getServiceDate();
            long effectiveScheduleTimeSeconds = this.getEffectiveScheduleTime(tripEntry, lat, lon, time, serviceDateTime);
            long effectiveScheduleTime = effectiveScheduleTimeSeconds + serviceDateTime / 1000L;
            int deviation = (int)(time - effectiveScheduleTime);
            _log.debug("deviation(" + vlr.getVehicleId() + " is " + deviation + " time=" + new Date(time * 1000L) + ", effectiveScheduleTime=" + new Date(effectiveScheduleTime * 1000L));
            return deviation;
        }
        return null;
    }

    private long getEffectiveScheduleTime(TripEntry trip, double lat, double lon, long timestamp, long serviceDate) {
        ServiceIdActivation serviceIds = new ServiceIdActivation(trip.getServiceId());
        BlockConfigurationEntry blockConfig = UnitTestingSupport.blockConfiguration(trip.getBlock(), serviceIds, trip);
        BlockInstance block = new BlockInstance(blockConfig, serviceDate);
        CoordinatePoint location = new CoordinatePoint(lat, lon);
        ScheduledBlockLocation loc = this._blockGeospatialService.getBestScheduledBlockLocationForLocation(block, location, timestamp, 0.0, trip.getTotalTripDistance());
        return loc.getScheduledTime();
    }

    private double asDouble(Object obj) {
        String s = (String)obj;
        return Double.parseDouble(s);
    }

    public Date parseShortDate(String s) throws Exception {
        return ISO_DATE_SHORT_FORMAT.parse(s);
    }

    public Date parseDate(String s) throws Exception {
        int endPos = "yyyy-MM-ddTHH:mm:ss.SSS".length();
        s = ((String)s).substring(0, endPos - 1) + ((String)s).substring(((String)s).length() - 7, ((String)s).length());
        return ISO_DATE_FORMAT.parse((String)s);
    }

    public Date parseServiceDate(String serviceDateStr) throws Exception {
        Date d = ISO_DATE_SHORT_FORMAT.parse(serviceDateStr);
        return new ServiceDate(d).getAsDate();
    }

    public static class NodesAndTimestamp {
        private List<Node> _nodes;
        private long _timestamp;

        public NodesAndTimestamp(List<Node> nodes, long timestamp) {
            this._nodes = nodes;
            this._timestamp = timestamp;
        }

        public List<Node> getNodes() {
            return this._nodes;
        }

        public long getTimestamp() {
            return this._timestamp;
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            try {
                SiriLikeRealtimeSource.this.refresh();
            }
            catch (Throwable ex) {
                _log.warn("Error updating from GTFS-realtime data sources", ex);
            }
        }
    }
}

