/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.onebusaway.gtfs.model.calendar.LocalizedServiceId;
import org.onebusaway.gtfs.model.calendar.ServiceInterval;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicHelper;
import org.onebusaway.transit_data_federation.services.realtime.DynamicCalendarService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DynamicCalendarServiceImpl
implements DynamicCalendarService {
    private static Logger _log = LoggerFactory.getLogger(DynamicCalendarServiceImpl.class);
    private DynamicHelper helper = new DynamicHelper();

    @Override
    public boolean hasServiceId(LocalizedServiceId localizedServiceId) {
        return this.helper.isServiceIdDynamic(localizedServiceId.getId().getId());
    }

    @Override
    public Collection<Date> getServiceDatesWithinRange(LocalizedServiceId localizedServiceId, ServiceInterval interval, Date from, Date to) {
        Date today = this.getDateFromServiceId(localizedServiceId);
        long startOfDay = today.getTime() - 3600000L;
        long endOfDay = today.getTime() + 86400000L + 10800000L - 1L;
        if (from.getTime() <= endOfDay && startOfDay <= to.getTime()) {
            Date[] dates = new Date[]{today};
            return Arrays.asList(dates);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isLocalizedServiceIdActiveOnDate(LocalizedServiceId lsid, Date serviceDate) {
        Date lsidDate = this.getDateFromServiceId(lsid);
        return lsidDate.equals(serviceDate);
    }

    private Date getDateFromServiceId(LocalizedServiceId localizedServiceId) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date serviceDate = null;
        try {
            serviceDate = sdf.parse(localizedServiceId.getId().getId().replaceAll("DYN-", ""));
        }
        catch (ParseException e) {
            _log.error("unexpected dynamic serviceId {", (Object)localizedServiceId.getId().toString());
            return null;
        }
        return serviceDate;
    }
}

