/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.CoordinatePoint;
import org.onebusaway.geospatial.services.SphericalGeometryLibrary;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data_federation.impl.probability.DeviationModel;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.services.beans.TripDetailsBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockGeospatialService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockSequenceIndex;
import org.onebusaway.transit_data_federation.services.blocks.BlockStatusService;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.realtime.CurrentVehicleEstimationService;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.onebusaway.util.SystemTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class CurrentVehicleEstimationServiceImpl
implements CurrentVehicleEstimationService {
    private static NumberFormat _format = new DecimalFormat("0.00");
    private BlockCalendarService _blockCalendarService;
    private BlockGeospatialService _blockGeospatialService;
    private BlockStatusService _blockStatusService;
    private TripDetailsBeanService _tripStatusBeanService;
    private BlockLocationService _blockLocationService;
    private int _maxWindow = 5;
    private double _maxAccuracy = 250.0;
    private DeviationModel _realTimeLocationDeviationModel = new DeviationModel(200.0);
    private DeviationModel _scheduleOnlyLocationDeviationModel = new DeviationModel(500.0);
    private DeviationModel _scheduleDeviationLateModel = new DeviationModel(900.0);
    private DeviationModel _scheduleDeviationEarlyModel = new DeviationModel(240.0);
    private int _maxTravelBackwardsTime = 120;
    private double _maxTravelBackwardsDecayFactor = 0.4;
    private double _shortCutProbability = 0.5;

    CurrentVehicleEstimationServiceImpl() {
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setBlockGeospatialService(BlockGeospatialService blockGeospatialService) {
        this._blockGeospatialService = blockGeospatialService;
    }

    @Autowired
    public void setBlockStatusService(BlockStatusService blockStatusService) {
        this._blockStatusService = blockStatusService;
    }

    @Autowired
    public void setTripStatusBeanService(TripDetailsBeanService tripStatusBeanService) {
        this._tripStatusBeanService = tripStatusBeanService;
    }

    @Autowired
    public void setBlockLocationService(BlockLocationService blockLocationService) {
        this._blockLocationService = blockLocationService;
    }

    @Override
    public ListBean<CurrentVehicleEstimateBean> getCurrentVehicleEstimates(CurrentVehicleEstimateQueryBean query) {
        long minT = SystemTime.currentTimeMillis() - (long)(this._maxWindow * 60 * 1000);
        minT = 0L;
        List<CurrentVehicleEstimateQueryBean.Record> records = this.getRecords(query.getRecords(), minT);
        if (records.isEmpty()) {
            return new ListBean();
        }
        ArrayList<CurrentVehicleEstimateBean> beans = new ArrayList<CurrentVehicleEstimateBean>();
        if (this.tryDirectMatchAgainstVehicleId(query, records, beans)) {
            return new ListBean(beans, true);
        }
        Map<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime = this.getRecordsByTimestamp(records);
        ArrayList<Date> timestamps = new ArrayList<Date>(recordsByTime.keySet());
        Collections.sort(timestamps);
        if (this.tryDirectMatchAgainstBlockId(query, records, recordsByTime, timestamps, query.getMinProbability(), beans)) {
            return new ListBean(beans, true);
        }
        Set<BlockSequenceIndex> allIndices = this.getBlockSequenceIndicesForRecords(recordsByTime);
        for (BlockSequenceIndex index : allIndices) {
            Map<BlockInstance, List<List<BlockLocation>>> allLocations = this._blockStatusService.getBlocksForIndex(index, timestamps);
            for (Map.Entry<BlockInstance, List<List<BlockLocation>>> entry : allLocations.entrySet()) {
                BlockInstance blockInstance = entry.getKey();
                List<List<BlockLocation>> realTimeLocations = entry.getValue();
                this.computeEstimatesForBlockInstance(records, recordsByTime, blockInstance, realTimeLocations, query.getMinProbability(), beans);
            }
        }
        Collections.sort(beans);
        return new ListBean(beans, false);
    }

    private void computeEstimatesForBlockInstance(List<CurrentVehicleEstimateQueryBean.Record> records, Map<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime, BlockInstance blockInstance, Collection<List<BlockLocation>> realTimeLocations, double minProbabilityForConsideration, List<CurrentVehicleEstimateBean> beans) {
        if (realTimeLocations.isEmpty()) {
            this.computeCumulativeProbabilityForScheduledBlockLocations(records, blockInstance, minProbabilityForConsideration, beans);
        } else {
            for (List<BlockLocation> locations : realTimeLocations) {
                this.computeCumulativeProbabilityForRealTimeBlockLocations(recordsByTime, locations, minProbabilityForConsideration, beans);
            }
        }
    }

    private boolean tryDirectMatchAgainstVehicleId(CurrentVehicleEstimateQueryBean query, List<CurrentVehicleEstimateQueryBean.Record> records, List<CurrentVehicleEstimateBean> beans) {
        if (query.getVehicleId() == null) {
            return false;
        }
        CurrentVehicleEstimateQueryBean.Record record = records.get(records.size() - 1);
        AgencyAndId vehicleId = AgencyAndIdLibrary.convertFromString((String)query.getVehicleId());
        BlockLocation location = this._blockLocationService.getLocationForVehicleAndTime(vehicleId, new TargetTime(record.getTimestamp()));
        if (location == null) {
            return false;
        }
        double d = SphericalGeometryLibrary.distance((CoordinatePoint)record.getLocation(), (CoordinatePoint)location.getLocation());
        double p = this._realTimeLocationDeviationModel.probability(d);
        if (p < this._shortCutProbability) {
            return false;
        }
        CurrentVehicleEstimateBean bean = new CurrentVehicleEstimateBean();
        bean.setProbability(p);
        bean.setTripStatus(this._tripStatusBeanService.getBlockLocationAsStatusBean(location, query.getTime()));
        beans.add(bean);
        return true;
    }

    private boolean tryDirectMatchAgainstBlockId(CurrentVehicleEstimateQueryBean query, List<CurrentVehicleEstimateQueryBean.Record> records, Map<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime, List<Date> timestamps, double minProbabilityForConsideration, List<CurrentVehicleEstimateBean> beans) {
        String blockIdAsString = query.getBlockId();
        long serviceDate = query.getServiceDate();
        if (blockIdAsString == null || serviceDate == 0L) {
            return false;
        }
        AgencyAndId blockId = AgencyAndIdLibrary.convertFromString((String)blockIdAsString);
        BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(blockId, serviceDate);
        if (blockInstance == null) {
            return false;
        }
        Map<AgencyAndId, List<BlockLocation>> locationsForBlockInstance = this._blockLocationService.getLocationsForBlockInstance(blockInstance, timestamps, query.getTime());
        Collection<List<BlockLocation>> realTimeLocations = locationsForBlockInstance.values();
        this.computeEstimatesForBlockInstance(records, recordsByTime, blockInstance, realTimeLocations, minProbabilityForConsideration, beans);
        return !beans.isEmpty();
    }

    private void addResult(BlockLocation location, double cumulativeP, String debug, double minProbabilityForConsideration, List<CurrentVehicleEstimateBean> beans) {
        if (cumulativeP >= minProbabilityForConsideration) {
            CurrentVehicleEstimateBean bean = new CurrentVehicleEstimateBean();
            bean.setProbability(cumulativeP);
            TripStatusBean status = this._tripStatusBeanService.getBlockLocationAsStatusBean(location, location.getTime());
            bean.setTripStatus(status);
            bean.setDebug(debug);
            beans.add(bean);
        }
    }

    private List<CurrentVehicleEstimateQueryBean.Record> getRecords(List<CurrentVehicleEstimateQueryBean.Record> records, long minT) {
        ArrayList<CurrentVehicleEstimateQueryBean.Record> pruned = new ArrayList<CurrentVehicleEstimateQueryBean.Record>();
        for (CurrentVehicleEstimateQueryBean.Record record : records) {
            if (record.getTimestamp() < minT || record.getAccuracy() > this._maxAccuracy) continue;
            pruned.add(record);
        }
        Collections.sort(pruned);
        return pruned;
    }

    private Map<Date, CurrentVehicleEstimateQueryBean.Record> getRecordsByTimestamp(List<CurrentVehicleEstimateQueryBean.Record> records) {
        HashMap<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime = new HashMap<Date, CurrentVehicleEstimateQueryBean.Record>();
        for (CurrentVehicleEstimateQueryBean.Record record : records) {
            Date timestamp = new Date(record.getTimestamp());
            recordsByTime.put(timestamp, record);
        }
        return recordsByTime;
    }

    private Set<BlockSequenceIndex> getBlockSequenceIndicesForRecords(Map<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime) {
        Set<BlockSequenceIndex> allIndices = null;
        for (CurrentVehicleEstimateQueryBean.Record record : recordsByTime.values()) {
            CoordinateBounds bounds = SphericalGeometryLibrary.bounds((CoordinatePoint)record.getLocation(), (double)record.getAccuracy());
            Set<BlockSequenceIndex> indices = this._blockGeospatialService.getBlockSequenceIndexPassingThroughBounds(bounds);
            if (allIndices == null) {
                allIndices = indices;
                continue;
            }
            allIndices.retainAll(indices);
        }
        return allIndices;
    }

    private void computeCumulativeProbabilityForRealTimeBlockLocations(Map<Date, CurrentVehicleEstimateQueryBean.Record> recordsByTime, List<BlockLocation> locations, double minProbabilityForConsideration, List<CurrentVehicleEstimateBean> beans) {
        DoubleArrayList ps = new DoubleArrayList();
        for (BlockLocation location : locations) {
            Date t = new Date(location.getTime());
            CurrentVehicleEstimateQueryBean.Record record = recordsByTime.get(t);
            CoordinatePoint userLocation = record.getLocation();
            CoordinatePoint vehicleLocation = location.getLocation();
            double d = SphericalGeometryLibrary.distance((CoordinatePoint)userLocation, (CoordinatePoint)vehicleLocation);
            double p = this._realTimeLocationDeviationModel.probability(d);
            ps.add(p);
        }
        BlockLocation last = locations.get(locations.size() - 1);
        double mu = Descriptive.mean((DoubleArrayList)ps);
        String debug = this.asString(ps);
        this.addResult(last, mu, debug, minProbabilityForConsideration, beans);
    }

    private void computeCumulativeProbabilityForScheduledBlockLocations(List<CurrentVehicleEstimateQueryBean.Record> records, BlockInstance blockInstance, double minProbabilityForConsideration, List<CurrentVehicleEstimateBean> beans) {
        DoubleArrayList ps = new DoubleArrayList();
        ArrayList<ScheduledBlockLocation> blockLocations = new ArrayList<ScheduledBlockLocation>();
        CurrentVehicleEstimateQueryBean.Record firstRecord = records.get(0);
        ScheduledBlockLocation firstLocation = this._blockGeospatialService.getBestScheduledBlockLocationForLocation(blockInstance, firstRecord.getLocation(), firstRecord.getTimestamp(), 0.0, Double.POSITIVE_INFINITY);
        blockLocations.add(firstLocation);
        ps.add(this.updateScheduledBlockLocationProbability(blockInstance, firstRecord, firstLocation));
        CurrentVehicleEstimateQueryBean.Record lastRecord = records.get(records.size() - 1);
        ScheduledBlockLocation lastLocation = this._blockGeospatialService.getBestScheduledBlockLocationForLocation(blockInstance, lastRecord.getLocation(), lastRecord.getTimestamp(), 0.0, Double.POSITIVE_INFINITY);
        ps.add(this.updateScheduledBlockLocationProbability(blockInstance, lastRecord, lastLocation));
        if (Descriptive.mean((DoubleArrayList)ps) < minProbabilityForConsideration) {
            return;
        }
        int maxTravelBackwardsTime = this.computeMaxTravelBackwardsTime(lastRecord.getTimestamp() - firstRecord.getTimestamp());
        if (lastLocation.getScheduledTime() < firstLocation.getScheduledTime() - maxTravelBackwardsTime) {
            return;
        }
        double minDistanceAlongBlock = Math.min(firstLocation.getDistanceAlongBlock(), lastLocation.getDistanceAlongBlock()) - 500.0;
        double maxDistanceAlongBlock = Math.max(firstLocation.getDistanceAlongBlock(), lastLocation.getDistanceAlongBlock()) + 500.0;
        for (int i = 1; i < records.size() - 1; ++i) {
            CurrentVehicleEstimateQueryBean.Record record = records.get(i);
            ScheduledBlockLocation location = this._blockGeospatialService.getBestScheduledBlockLocationForLocation(blockInstance, record.getLocation(), record.getTimestamp(), minDistanceAlongBlock, maxDistanceAlongBlock);
            blockLocations.add(location);
            ps.add(this.updateScheduledBlockLocationProbability(blockInstance, record, location));
            if (!(Descriptive.mean((DoubleArrayList)ps) < minProbabilityForConsideration)) continue;
            return;
        }
        blockLocations.add(lastLocation);
        this.updateProbabilitiesWithScheduleDeviations(records, blockLocations, ps);
        BlockLocation location = this._blockLocationService.getLocationForBlockInstanceAndScheduledBlockLocation(blockInstance, lastLocation, lastRecord.getTimestamp());
        double mu = Descriptive.mean((DoubleArrayList)ps);
        String debug = this.asString(ps);
        this.addResult(location, mu, debug, minProbabilityForConsideration, beans);
    }

    private double updateScheduledBlockLocationProbability(BlockInstance blockInstance, CurrentVehicleEstimateQueryBean.Record record, ScheduledBlockLocation location) {
        double locationDelta = SphericalGeometryLibrary.distance((CoordinatePoint)record.getLocation(), (CoordinatePoint)location.getLocation());
        double locationP = this._scheduleOnlyLocationDeviationModel.probability(locationDelta);
        long serviceDate = blockInstance.getServiceDate();
        int timeDelta = (int)((record.getTimestamp() - serviceDate) / 1000L - (long)location.getScheduledTime());
        double scheduleP = 0.0;
        scheduleP = timeDelta < 0 ? this._scheduleDeviationEarlyModel.probability(-timeDelta) : this._scheduleDeviationLateModel.probability(timeDelta);
        return locationP * scheduleP;
    }

    private void updateProbabilitiesWithScheduleDeviations(List<CurrentVehicleEstimateQueryBean.Record> records, List<ScheduledBlockLocation> blockLocations, DoubleArrayList ps) {
        if (records.size() != blockLocations.size()) {
            throw new IllegalStateException();
        }
        if (records.size() != ps.size()) {
            throw new IllegalStateException();
        }
        for (int i = 1; i < records.size(); ++i) {
            CurrentVehicleEstimateQueryBean.Record prevRecord = records.get(i - 1);
            CurrentVehicleEstimateQueryBean.Record nextRecord = records.get(i);
            long recordDeltaT = nextRecord.getTimestamp() - prevRecord.getTimestamp();
            if (recordDeltaT <= 0L) continue;
            int maxTravelBackwardsTime = this.computeMaxTravelBackwardsTime(recordDeltaT);
            ScheduledBlockLocation prevLocation = blockLocations.get(i - 1);
            ScheduledBlockLocation nextLocation = blockLocations.get(i);
            int locationDeltaT = nextLocation.getScheduledTime() - prevLocation.getScheduledTime();
            if (locationDeltaT >= 0 || Math.abs(locationDeltaT) <= maxTravelBackwardsTime) continue;
            ps.set(i, 0.0);
        }
    }

    private int computeMaxTravelBackwardsTime(long t) {
        return (int)Math.max(0.0, (double)this._maxTravelBackwardsTime - this._maxTravelBackwardsDecayFactor * (double)t / 1000.0);
    }

    private String asString(DoubleArrayList values) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(_format.format(values.get(i)));
        }
        return b.toString();
    }
}

