/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.collections.CollectionsLibrary;
import org.onebusaway.collections.FactoryMap;
import org.onebusaway.collections.Min;
import org.onebusaway.collections.Range;
import org.onebusaway.container.ConfigurationParameter;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.realtime.api.EVehicleType;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.AbstractBlockLocationServiceImpl;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordDao;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordKey;
import org.onebusaway.transit_data_federation.impl.realtime.DynamicHelper;
import org.onebusaway.transit_data_federation.model.TargetTime;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.blocks.BlockVehicleLocationListener;
import org.onebusaway.transit_data_federation.services.blocks.ScheduledBlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocation;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationListener;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationService;
import org.onebusaway.transit_data_federation.services.realtime.RealTimeHistoryService;
import org.onebusaway.transit_data_federation.services.realtime.ScheduleDeviationSamples;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElement;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationCacheElements;
import org.onebusaway.transit_data_federation.services.realtime.VehicleLocationRecordCache;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockConfigurationEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(value="org.onebusaway.transit_data_federation.impl.realtime:name=BlockLocationServiceImpl")
public class BlockLocationServiceImpl
extends AbstractBlockLocationServiceImpl
implements BlockLocationService,
BlockVehicleLocationListener {
    private static Logger _log = LoggerFactory.getLogger(BlockLocationServiceImpl.class);
    private VehicleLocationRecordCache _cache;
    private BlockLocationRecordDao _blockLocationRecordDao;
    private TransitGraphDao _transitGraphDao;
    private BlockCalendarService _blockCalendarService;
    private RealTimeHistoryService _realTimeHistoryService;
    private DynamicHelper helper = new DynamicHelper();
    private List<BlockLocationListener> _blockLocationListeners = Collections.emptyList();
    private int _blockLocationRecordCacheWindowSize = 1200;
    private int _predictionCacheMaxOffset = 300;
    private int _statelessAvlOffset = 30;
    private int _blockInstanceMatchingWindow = 3600000;
    private boolean _persistBlockLocationRecords = false;
    private List<BlockLocationRecord> _recordPersistenceQueue = new ArrayList<BlockLocationRecord>();
    private ScheduledExecutorService _executor = Executors.newSingleThreadScheduledExecutor();
    private volatile long _lastInsertDuration = 0L;
    private volatile long _lastInsertCount = 0L;
    private AtomicInteger _blockLocationRecordPersistentStoreAccessCount = new AtomicInteger();

    public void setStatelessAvlOffset(int offset) {
        this._statelessAvlOffset = offset;
    }

    @Autowired
    public void setVehicleLocationRecordCache(VehicleLocationRecordCache cache) {
        this._cache = cache;
    }

    @Autowired
    public void setBlockLocationRecordDao(BlockLocationRecordDao blockLocationRecordDao) {
        this._blockLocationRecordDao = blockLocationRecordDao;
    }

    @Autowired
    public void setTransitGraphDao(TransitGraphDao transitGraphDao) {
        this._transitGraphDao = transitGraphDao;
    }

    @Autowired
    public void setBlockCalendarService(BlockCalendarService blockCalendarService) {
        this._blockCalendarService = blockCalendarService;
    }

    @Autowired
    public void setRealTimeHistoryService(RealTimeHistoryService realTimeHistoryService) {
        this._realTimeHistoryService = realTimeHistoryService;
    }

    @Autowired
    public void setBlockLocationListeners(List<BlockLocationListener> listeners) {
        this._blockLocationListeners = listeners;
    }

    @ConfigurationParameter
    public void setBlockLocationRecordCacheWindowSize(int windowSize) {
        this._blockLocationRecordCacheWindowSize = windowSize;
    }

    @ConfigurationParameter
    public void setPersistBlockLocationRecords(boolean persistBlockLocationRecords) {
        this._persistBlockLocationRecords = persistBlockLocationRecords;
    }

    @ManagedAttribute
    public long getLastInsertDuration() {
        return this._lastInsertDuration;
    }

    @ManagedAttribute
    public long getLastInsertCount() {
        return this._lastInsertCount;
    }

    @ManagedAttribute
    public long getBlockLocationRecordPersistentStoreAccessCount() {
        return this._blockLocationRecordPersistentStoreAccessCount.get();
    }

    @PostConstruct
    public void start() {
        if (this._persistBlockLocationRecords) {
            this._executor.scheduleAtFixedRate(new PredictionWriter(), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    @PreDestroy
    public void stop() {
        this._executor.shutdownNow();
    }

    @Override
    public void handleVehicleLocationRecord(VehicleLocationRecord record) {
        BlockInstance instance = this.getVehicleLocationRecordAsBlockInstance(record);
        if (instance != null) {
            ScheduledBlockLocation scheduledBlockLocation = this.getScheduledBlockLocationForVehicleLocationRecord(record, instance);
            if (!record.isScheduleDeviationSet() && scheduledBlockLocation != null) {
                int deviation = (int)((record.getTimeOfRecord() - record.getServiceDate()) / 1000L - (long)scheduledBlockLocation.getScheduledTime());
                record.setScheduleDeviation((double)deviation);
            }
            ScheduleDeviationSamples samples = null;
            if (this._sampleScheduleDeviationHistory) {
                samples = this._realTimeHistoryService.sampleScheduleDeviationsForVehicle(instance, record, scheduledBlockLocation);
            }
            this.putBlockLocationRecord(instance, record, scheduledBlockLocation, samples);
        }
    }

    @Override
    public void resetVehicleLocation(AgencyAndId vehicleId) {
        this._cache.clearRecordsForVehicleId(vehicleId);
    }

    @Override
    public BlockLocation getLocationForBlockInstance(BlockInstance blockInstance, TargetTime time) {
        List<VehicleLocationCacheElements> records = this.getBlockLocationRecordCollectionForBlock(blockInstance, time);
        VehicleLocationCacheElements record = null;
        if (!records.isEmpty()) {
            record = records.get(0);
        }
        return this.getBlockLocation(blockInstance, record, null, time.getTargetTime());
    }

    @Override
    public BlockLocation getLocationForBlockInstanceAndScheduledBlockLocation(BlockInstance blockInstance, ScheduledBlockLocation scheduledLocation, long targetTime) {
        return this.getBlockLocation(blockInstance, null, scheduledLocation, targetTime);
    }

    @Override
    public List<BlockLocation> getLocationsForBlockInstance(BlockInstance blockInstance, TargetTime time) {
        List<VehicleLocationCacheElements> records = this.getBlockLocationRecordCollectionForBlock(blockInstance, time);
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
        for (VehicleLocationCacheElements cacheRecord : records) {
            BlockLocation location = this.getBlockLocation(blockInstance, cacheRecord, null, time.getTargetTime());
            if (location == null) continue;
            locations.add(location);
        }
        return locations;
    }

    @Override
    public Map<AgencyAndId, List<BlockLocation>> getLocationsForBlockInstance(BlockInstance blockInstance, List<Date> times, long currentTime) {
        FactoryMap locationsByVehicleId = new FactoryMap(new ArrayList());
        for (Date time : times) {
            TargetTime tt = new TargetTime(time.getTime(), currentTime);
            List<VehicleLocationCacheElements> records = this.getBlockLocationRecordCollectionForBlock(blockInstance, tt);
            for (VehicleLocationCacheElements cacheRecord : records) {
                BlockLocation location = this.getBlockLocation(blockInstance, cacheRecord, null, time.getTime());
                if (location == null) continue;
                ((List)locationsByVehicleId.get(location.getVehicleId())).add(location);
            }
        }
        return locationsByVehicleId;
    }

    @Override
    public BlockLocation getScheduledLocationForBlockInstance(BlockInstance blockInstance, long targetTime) {
        return this.getBlockLocation(blockInstance, null, null, targetTime);
    }

    @Override
    public BlockLocation getLocationForVehicleAndTime(AgencyAndId vehicleId, TargetTime targetTime) {
        List<VehicleLocationCacheElements> cacheRecords = this.getBlockLocationRecordCollectionForVehicle(vehicleId, targetTime);
        if (cacheRecords.size() > 1) {
            _log.error("multiple cache entries for vehicle " + vehicleId);
        }
        for (VehicleLocationCacheElements cacheRecord : cacheRecords) {
            BlockInstance blockInstance = cacheRecord.getBlockInstance();
            BlockLocation location = this.getBlockLocation(blockInstance, cacheRecord, null, targetTime.getTargetTime());
            if (location == null) continue;
            return location;
        }
        return null;
    }

    private BlockInstance getVehicleLocationRecordAsBlockInstance(VehicleLocationRecord record) {
        AgencyAndId blockId = record.getBlockId();
        if (blockId == null) {
            AgencyAndId tripId = record.getTripId();
            if (tripId == null) {
                throw new IllegalArgumentException("at least one of blockId or tripId must be specified for VehicleLocationRecord");
            }
            TripEntry tripEntry = this._transitGraphDao.getTripEntryForId(tripId);
            if (tripEntry == null) {
                throw new IllegalArgumentException("trip not found with id=" + tripId);
            }
            BlockEntry block = tripEntry.getBlock();
            blockId = block.getId();
        }
        if (record.getServiceDate() == 0L) {
            throw new IllegalArgumentException("you must specify a serviceDate");
        }
        if (record.getTimeOfRecord() == 0L) {
            throw new IllegalArgumentException("you must specify a record time");
        }
        BlockInstance blockInstance = this.getBestBlockForRecord(blockId, record.getServiceDate(), record.getTimeOfRecord());
        return blockInstance;
    }

    private BlockInstance getBestBlockForRecord(AgencyAndId blockId, long serviceDate, long timeOfRecord) {
        long timeFrom = timeOfRecord - (long)this._blockInstanceMatchingWindow;
        long timeTo = timeOfRecord + (long)this._blockInstanceMatchingWindow;
        List<BlockInstance> blocks = this._blockCalendarService.getActiveBlocks(blockId, timeFrom, timeTo);
        if (blocks.isEmpty()) {
            return null;
        }
        if (blocks.size() == 1) {
            return blocks.get(0);
        }
        Min m = new Min();
        for (BlockInstance block : blocks) {
            long delta = Math.abs(block.getServiceDate() - serviceDate);
            m.add((double)delta, (Object)block);
        }
        return (BlockInstance)m.getMinElement();
    }

    private void putBlockLocationRecord(BlockInstance blockInstance, VehicleLocationRecord record, ScheduledBlockLocation scheduledBlockLocation, ScheduleDeviationSamples samples) {
        BlockLocation location;
        VehicleLocationCacheElements elements = this._cache.addRecord(blockInstance, record, scheduledBlockLocation, samples);
        if (!CollectionsLibrary.isEmpty(this._blockLocationListeners) && (location = this.getBlockLocation(blockInstance, elements, scheduledBlockLocation, record.getTimeOfRecord())) != null) {
            for (BlockLocationListener listener : this._blockLocationListeners) {
                listener.handleBlockLocation(location);
            }
        }
        if (this._persistBlockLocationRecords) {
            List<BlockLocationRecord> blockLocationRecords = this.getVehicleLocationRecordAsBlockLocationRecord(blockInstance, record, scheduledBlockLocation);
            this.addPredictionToPersistenceQueue(blockLocationRecords);
        }
    }

    private List<VehicleLocationCacheElements> getBlockLocationRecordCollectionForBlock(BlockInstance blockInstance, TargetTime time) {
        return this.getBlockLocationRecordCollections(new BlockInstanceStrategy(blockInstance), time);
    }

    private List<VehicleLocationCacheElements> getBlockLocationRecordCollectionForVehicle(AgencyAndId vehicleId, TargetTime time) {
        return this.getBlockLocationRecordCollections(new VehicleIdRecordStrategy(vehicleId), time);
    }

    private List<VehicleLocationCacheElements> getBlockLocationRecordCollections(RecordStrategy strategy, TargetTime time) {
        boolean outOfRange;
        List<VehicleLocationCacheElements> entries = strategy.getRecordsFromCache();
        if (!entries.isEmpty()) {
            ArrayList<VehicleLocationCacheElements> inRange = new ArrayList<VehicleLocationCacheElements>();
            long offset = this._predictionCacheMaxOffset * 1000;
            if (strategy.getRecordAgeWindowInSeconds() != null) {
                offset = strategy.getRecordAgeWindowInSeconds() * 1000;
            }
            for (VehicleLocationCacheElements elements : entries) {
                if (elements.isEmpty()) continue;
                Range range = elements.getTimeRange();
                long tFrom = (long)(range.getMin() - (double)offset);
                long tTo = (long)(range.getMax() + (double)offset);
                if (tFrom > time.getCurrentTime() || time.getCurrentTime() > tTo) continue;
                inRange.add(elements);
            }
            if (!inRange.isEmpty()) {
                return inRange;
            }
        }
        long offset = this._blockLocationRecordCacheWindowSize * 1000 / 2;
        boolean bl = outOfRange = time.getTargetTime() + offset < time.getCurrentTime() || time.getCurrentTime() < time.getTargetTime() - offset;
        if (outOfRange && this._persistBlockLocationRecords) {
            this._blockLocationRecordPersistentStoreAccessCount.incrementAndGet();
            long fromTime = time.getTargetTime() - offset;
            long toTime = time.getTargetTime() + offset;
            List<BlockLocationRecord> predictions = strategy.getRecordsFromDao(fromTime, toTime);
            if (!predictions.isEmpty()) {
                Map<BlockLocationRecordKey, List<BlockLocationRecord>> recordsByKey = this.groupRecord(predictions);
                ArrayList<VehicleLocationCacheElements> allCollections = new ArrayList<VehicleLocationCacheElements>();
                for (Map.Entry<BlockLocationRecordKey, List<BlockLocationRecord>> entry : recordsByKey.entrySet()) {
                    BlockLocationRecordKey key = entry.getKey();
                    List<BlockLocationRecord> blockLocationRecords = entry.getValue();
                    List<VehicleLocationCacheElements> someRecords = this.getBlockLocationRecordsAsVehicleLocationRecords(key.getBlockInstance(), blockLocationRecords);
                    allCollections.addAll(someRecords);
                }
                return allCollections;
            }
        }
        return Collections.emptyList();
    }

    private List<BlockLocationRecord> getVehicleLocationRecordAsBlockLocationRecord(BlockInstance blockInstance, VehicleLocationRecord record, ScheduledBlockLocation scheduledBlockLocation) {
        BlockLocationRecord.Builder builder = BlockLocationRecord.builder();
        if (scheduledBlockLocation != null) {
            BlockTripEntry activeTrip = scheduledBlockLocation.getActiveTrip();
            builder.setTripId(activeTrip.getTrip().getId());
            builder.setBlockId(activeTrip.getBlockConfiguration().getBlock().getId());
            builder.setVehicleType(EVehicleType.toEnum((int)activeTrip.getTrip().getRoute().getType()));
            double distanceAlongBlock = scheduledBlockLocation.getDistanceAlongBlock();
            builder.setDistanceAlongBlock(distanceAlongBlock);
            double distanceAlongTrip = distanceAlongBlock - activeTrip.getDistanceAlongBlock();
            builder.setDistanceAlongTrip(distanceAlongTrip);
        }
        if (record.getBlockId() != null) {
            builder.setBlockId(record.getBlockId());
        }
        if (record.getTripId() != null) {
            builder.setTripId(record.getTripId());
        }
        builder.setTime(record.getTimeOfRecord());
        builder.setServiceDate(record.getServiceDate());
        if (record.isScheduleDeviationSet()) {
            builder.setScheduleDeviation(record.getScheduleDeviation());
        }
        if (record.isDistanceAlongBlockSet()) {
            double distanceAlongBlock = record.getDistanceAlongBlock();
            builder.setDistanceAlongBlock(distanceAlongBlock);
            AgencyAndId tripId = record.getTripId();
            if (tripId != null) {
                BlockConfigurationEntry block = blockInstance.getBlock();
                for (BlockTripEntry blockTrip : block.getTrips()) {
                    TripEntry trip = blockTrip.getTrip();
                    if (!trip.getId().equals((Object)tripId)) continue;
                    double distanceAlongTrip = distanceAlongBlock - blockTrip.getDistanceAlongBlock();
                    builder.setDistanceAlongTrip(distanceAlongTrip);
                }
            }
        }
        if (record.isCurrentLocationSet()) {
            builder.setLocationLat(record.getCurrentLocationLat());
            builder.setLocationLon(record.getCurrentLocationLon());
        }
        if (record.isCurrentOrientationSet()) {
            builder.setOrientation(record.getCurrentOrientation());
        }
        builder.setPhase(record.getPhase());
        builder.setStatus(record.getStatus());
        builder.setVehicleId(record.getVehicleId());
        List predictions = record.getTimepointPredictions();
        if (predictions == null || predictions.isEmpty()) {
            return Arrays.asList(builder.create());
        }
        ArrayList<BlockLocationRecord> results = new ArrayList<BlockLocationRecord>();
        for (TimepointPredictionRecord tpr : predictions) {
            if (tpr.isSkipped()) continue;
            builder.setTimepointId(tpr.getTimepointId());
            builder.setTimepointScheduledTime(tpr.getTimepointScheduledTime());
            builder.setTimepointPredictedArrivalTime(tpr.getTimepointPredictedArrivalTime());
            builder.setTimepointPredictedDepartureTime(tpr.getTimepointPredictedDepartureTime());
            results.add(builder.create());
        }
        return results;
    }

    private List<VehicleLocationCacheElements> getBlockLocationRecordsAsVehicleLocationRecords(BlockInstance blockInstance, List<BlockLocationRecord> records) {
        ArrayList<VehicleLocationCacheElements> results = new ArrayList<VehicleLocationCacheElements>();
        for (BlockLocationRecord record : records) {
            VehicleLocationRecord vlr = new VehicleLocationRecord();
            vlr.setBlockId(blockInstance.getBlock().getBlock().getId());
            if (record.isLocationSet()) {
                vlr.setCurrentLocationLat(record.getLocationLat().doubleValue());
                vlr.setCurrentLocationLon(record.getLocationLon().doubleValue());
            }
            if (record.isOrientationSet()) {
                vlr.setCurrentOrientation(record.getOrientation().doubleValue());
            }
            if (record.isDistanceAlongBlockSet()) {
                vlr.setDistanceAlongBlock(record.getDistanceAlongBlock().doubleValue());
            }
            vlr.setPhase(record.getPhase());
            if (record.isScheduleDeviationSet()) {
                vlr.setScheduleDeviation(record.getScheduleDeviation().doubleValue());
            }
            vlr.setServiceDate(record.getServiceDate());
            vlr.setStatus(record.getStatus());
            vlr.setTimeOfRecord(record.getTime());
            vlr.setVehicleId(record.getVehicleId());
            VehicleLocationCacheElement element = new VehicleLocationCacheElement(vlr, null, null);
            VehicleLocationCacheElements elements = new VehicleLocationCacheElements(blockInstance, element);
            results.add(elements);
        }
        return results;
    }

    private Map<BlockLocationRecordKey, List<BlockLocationRecord>> groupRecord(List<BlockLocationRecord> predictions) {
        FactoryMap recordsByKey = new FactoryMap(new ArrayList());
        for (BlockLocationRecord record : predictions) {
            long serviceDate;
            AgencyAndId blockId = record.getBlockId();
            BlockInstance blockInstance = this._blockCalendarService.getBlockInstance(blockId, serviceDate = record.getServiceDate());
            if (blockInstance == null) continue;
            BlockLocationRecordKey key = new BlockLocationRecordKey(blockInstance, record.getVehicleId());
            ((List)recordsByKey.get(key)).add(record);
        }
        return recordsByKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPredictionToPersistenceQueue(List<BlockLocationRecord> records) {
        List<BlockLocationRecord> list = this._recordPersistenceQueue;
        synchronized (list) {
            this._recordPersistenceQueue.addAll(records);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BlockLocationRecord> getPredictionPersistenceQueue() {
        List<BlockLocationRecord> list = this._recordPersistenceQueue;
        synchronized (list) {
            ArrayList<BlockLocationRecord> queue = new ArrayList<BlockLocationRecord>(this._recordPersistenceQueue);
            this._recordPersistenceQueue.clear();
            return queue;
        }
    }

    private class VehicleIdRecordStrategy
    implements RecordStrategy {
        private final AgencyAndId _vehicleId;
        private final Integer _recordAgeWindowInSeconds;

        @Override
        public final Integer getRecordAgeWindowInSeconds() {
            return this._recordAgeWindowInSeconds;
        }

        public VehicleIdRecordStrategy(AgencyAndId vehicleId) {
            this._vehicleId = vehicleId;
            this._recordAgeWindowInSeconds = null;
        }

        @Override
        public List<VehicleLocationCacheElements> getRecordsFromCache() {
            VehicleLocationCacheElements elementsForVehicleId = BlockLocationServiceImpl.this._cache.getRecordForVehicleId(this._vehicleId);
            if (elementsForVehicleId == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(elementsForVehicleId);
        }

        @Override
        public List<BlockLocationRecord> getRecordsFromDao(long fromTime, long toTime) {
            return BlockLocationServiceImpl.this._blockLocationRecordDao.getBlockLocationRecordsForVehicleAndTimeRange(this._vehicleId, fromTime, toTime);
        }
    }

    private class BlockInstanceStrategy
    implements RecordStrategy {
        private final BlockInstance _blockInstance;
        private final Integer _recordAgeWindowInSeconds;

        @Override
        public Integer getRecordAgeWindowInSeconds() {
            return this._recordAgeWindowInSeconds;
        }

        public BlockInstanceStrategy(BlockInstance blockInstance) {
            this._blockInstance = blockInstance;
            this._recordAgeWindowInSeconds = this.getRecordAgeWindowFromBlock(blockInstance);
        }

        private Integer getRecordAgeWindowFromBlock(BlockInstance blockInstance) {
            if (blockInstance != null && !blockInstance.getBlock().getTrips().isEmpty() && blockInstance.getBlock().getTrips().get(0).getTrip() != null && blockInstance.getBlock().getTrips().get(0).getTrip().getRoute() != null) {
                return this.getRecordAgeFromRouteType(blockInstance.getBlock().getTrips().get(0).getTrip().getRoute().getType());
            }
            return null;
        }

        private Integer getRecordAgeFromRouteType(int routeType) {
            if (routeType == EVehicleType.SUBWAY.getGtfsType()) {
                return BlockLocationServiceImpl.this._statelessAvlOffset;
            }
            return null;
        }

        @Override
        public List<VehicleLocationCacheElements> getRecordsFromCache() {
            return BlockLocationServiceImpl.this._cache.getRecordsForBlockInstance(this._blockInstance);
        }

        @Override
        public List<BlockLocationRecord> getRecordsFromDao(long fromTime, long toTime) {
            BlockConfigurationEntry blockConfig = this._blockInstance.getBlock();
            BlockEntry block = blockConfig.getBlock();
            return BlockLocationServiceImpl.this._blockLocationRecordDao.getBlockLocationRecordsForBlockServiceDateAndTimeRange(block.getId(), this._blockInstance.getServiceDate(), fromTime, toTime);
        }
    }

    private static interface RecordStrategy {
        public List<VehicleLocationCacheElements> getRecordsFromCache();

        public List<BlockLocationRecord> getRecordsFromDao(long var1, long var3);

        public Integer getRecordAgeWindowInSeconds();
    }

    private class PredictionWriter
    implements Runnable {
        private PredictionWriter() {
        }

        @Override
        public void run() {
            try {
                List<BlockLocationRecord> queue = BlockLocationServiceImpl.this.getPredictionPersistenceQueue();
                if (queue.isEmpty()) {
                    return;
                }
                long t1 = SystemTime.currentTimeMillis();
                BlockLocationServiceImpl.this._blockLocationRecordDao.saveBlockLocationRecords(queue);
                long t2 = SystemTime.currentTimeMillis();
                BlockLocationServiceImpl.this._lastInsertDuration = t2 - t1;
                BlockLocationServiceImpl.this._lastInsertCount = queue.size();
            }
            catch (Throwable ex) {
                _log.error("error writing block location records to dao", ex);
            }
        }
    }
}

