/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;

class BlockLocationRecordKey {
    private final BlockInstance blockInstance;
    private final AgencyAndId vehicleId;

    public BlockLocationRecordKey(BlockInstance blockInstance, AgencyAndId vehicleId) {
        if (blockInstance == null) {
            throw new IllegalArgumentException("blockInstance is null");
        }
        if (vehicleId == null) {
            throw new IllegalArgumentException("vehicleId is null");
        }
        this.blockInstance = blockInstance;
        this.vehicleId = vehicleId;
    }

    public BlockInstance getBlockInstance() {
        return this.blockInstance;
    }

    public AgencyAndId getVehicleId() {
        return this.vehicleId;
    }

    public String toString() {
        return "key(blockInstance=" + this.blockInstance + " vehicleId=" + this.vehicleId + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockInstance.hashCode();
        result = 31 * result + this.vehicleId.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockLocationRecordKey other = (BlockLocationRecordKey)obj;
        if (!this.blockInstance.equals(other.blockInstance)) {
            return false;
        }
        return this.vehicleId.equals((Object)other.vehicleId);
    }
}

