/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Property;
import org.hibernate.query.Query;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.stereotype.Component;

@Component
@ManagedResource(value="org.onebusaway.transit_data_federation.impl.realtime:name=BlockLocationRecordDaoImpl")
public class BlockLocationRecordDaoImpl
implements BlockLocationRecordDao {
    private SessionFactory _sessionFactory;
    private AtomicInteger _savedRecordCount = new AtomicInteger();

    @Autowired
    public void setSessionFactory(SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
    }

    @ManagedAttribute
    public int getSavedRecordCount() {
        return this._savedRecordCount.intValue();
    }

    @Override
    public void saveBlockLocationRecord(BlockLocationRecord record) {
        this.getSession().save((Object)record);
        this._savedRecordCount.incrementAndGet();
    }

    @Override
    public void saveBlockLocationRecords(List<BlockLocationRecord> records) {
        Session session = this.getSession();
        Iterator<BlockLocationRecord> it = records.iterator();
        while (it.hasNext()) {
            session.saveOrUpdate((Object)it.next());
        }
        this._savedRecordCount.addAndGet(records.size());
    }

    @Override
    public List<BlockLocationRecord> getBlockLocationRecordsForBlockServiceDateAndTimeRange(AgencyAndId blockId, long serviceDate, long fromTime, long toTime) {
        Query query = this.getSession().getNamedQuery("blockLocationRecordsForBlockServiceDateAndTimeRange");
        query.setParameter("blockId", (Object)blockId);
        query.setParameter("serviceDate", (Object)serviceDate);
        query.setParameter("fromTime", (Object)fromTime);
        query.setParameter("toTime", (Object)toTime);
        return query.list();
    }

    @Override
    public List<BlockLocationRecord> getBlockLocationRecordsForVehicleAndTimeRange(AgencyAndId vehicleId, long fromTime, long toTime) {
        Query query = this.getSession().getNamedQuery("blockLocationRecordsForVehicleAndTimeRange");
        query.setParameter("vehicleId", (Object)vehicleId);
        query.setParameter("fromTime", (Object)fromTime);
        query.setParameter("toTime", (Object)toTime);
        return query.list();
    }

    @Override
    public List<BlockLocationRecord> getBlockLocationRecords(AgencyAndId blockId, AgencyAndId tripId, AgencyAndId vehicleId, long serviceDate, long fromTime, long toTime, int recordLimit) {
        Criteria c = this.getSession().createCriteria(BlockLocationRecord.class);
        if (blockId != null) {
            c.add((Criterion)Property.forName((String)"blockId").eq((Object)blockId));
        }
        if (tripId != null) {
            c.add((Criterion)Property.forName((String)"tripId").eq((Object)tripId));
        }
        if (vehicleId != null) {
            c.add((Criterion)Property.forName((String)"vehicleId").eq((Object)vehicleId));
        }
        if (serviceDate != 0L) {
            c.add((Criterion)Property.forName((String)"serviceDate").eq((Object)serviceDate));
        }
        if (fromTime != 0L) {
            c.add((Criterion)Property.forName((String)"time").ge((Object)fromTime));
        }
        if (toTime != 0L) {
            c.add((Criterion)Property.forName((String)"time").le((Object)toTime));
        }
        if (recordLimit != 0) {
            c.setFetchSize(recordLimit);
        }
        c.addOrder(Order.asc((String)"time"));
        return c.list();
    }

    private Session getSession() {
        return this._sessionFactory.getCurrentSession();
    }
}

