/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecord;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordCollection;
import org.onebusaway.transit_data_federation.impl.realtime.BlockLocationRecordKey;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.realtime.BlockLocationRecordCache;
import org.onebusaway.util.SystemTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class BlockLocationRecordCacheImpl
implements BlockLocationRecordCache {
    private static Logger _log = LoggerFactory.getLogger(BlockLocationRecordCacheImpl.class);
    private ConcurrentMap<BlockLocationRecordKey, BlockLocationRecordCollection> _recordsByKey = new ConcurrentHashMap<BlockLocationRecordKey, BlockLocationRecordCollection>();
    private ConcurrentMap<AgencyAndId, List<BlockLocationRecordKey>> _keysByVehicleId = new ConcurrentHashMap<AgencyAndId, List<BlockLocationRecordKey>>();
    private ConcurrentMap<BlockInstance, List<BlockLocationRecordKey>> _keysByBlockInstance = new ConcurrentHashMap<BlockInstance, List<BlockLocationRecordKey>>();
    private int _blockLocationRecordCacheWindowSize = 1200;
    private int _cacheEvictionFrequency = 1;
    private ScheduledExecutorService _executor;
    private ScheduledFuture<?> _evictionHandler;

    BlockLocationRecordCacheImpl() {
    }

    public void setBlockLocationRecordCacheWindowSize(int windowSize) {
        this._blockLocationRecordCacheWindowSize = windowSize;
    }

    public void setCacheEvictionFrequency(int cacheEvictionFrequency) {
        this._cacheEvictionFrequency = cacheEvictionFrequency;
    }

    @PostConstruct
    public void start() {
        this._executor = Executors.newScheduledThreadPool(1);
        this._evictionHandler = this._executor.scheduleAtFixedRate(new CacheEvictionHandler(), this._cacheEvictionFrequency, this._cacheEvictionFrequency, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void stop() {
        if (this._evictionHandler != null) {
            this._evictionHandler.cancel(true);
        }
        if (this._executor != null) {
            this._executor.shutdownNow();
        }
    }

    @Override
    public List<BlockLocationRecordCollection> getRecordsForVehicleId(AgencyAndId vehicleId) {
        return this.getRecordsFromMap(this._keysByVehicleId, vehicleId);
    }

    @Override
    public List<BlockLocationRecordCollection> getRecordsForBlockInstance(BlockInstance blockInstance) {
        return this.getRecordsFromMap(this._keysByBlockInstance, blockInstance);
    }

    @Override
    public void addRecord(BlockInstance blockInstance, BlockLocationRecord record) {
        BlockLocationRecordCollection newRecords;
        AgencyAndId vehicleId = record.getVehicleId();
        BlockLocationRecordKey key = new BlockLocationRecordKey(blockInstance, vehicleId);
        BlockLocationRecordCollection records = (BlockLocationRecordCollection)this._recordsByKey.get(key);
        if (records == null && (records = this._recordsByKey.putIfAbsent(key, newRecords = BlockLocationRecordCollection.createFromRecords(blockInstance, Arrays.asList(record)))) == null) {
            this.addKeyToMap(this._keysByVehicleId, vehicleId, key);
            this.addKeyToMap(this._keysByBlockInstance, blockInstance, key);
        }
        if (records != null) {
            records = records.addRecord(blockInstance, record, this._blockLocationRecordCacheWindowSize * 1000);
            this._recordsByKey.put(key, records);
        }
    }

    @Override
    public void clearRecordsForVehicleId(AgencyAndId vehicleId) {
        List keysForVehicleId = (List)this._keysByVehicleId.remove(vehicleId);
        if (keysForVehicleId != null) {
            ArrayList keys = new ArrayList(keysForVehicleId);
            for (BlockLocationRecordKey key : keys) {
                this.removeRecordsForKey(key, true);
            }
        }
    }

    public void clearStaleRecords(long time) {
        Iterator it = this._recordsByKey.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            BlockLocationRecordKey key = (BlockLocationRecordKey)entry.getKey();
            BlockLocationRecordCollection value = (BlockLocationRecordCollection)entry.getValue();
            if (value.getMeasuredLastUpdateTime() >= time) continue;
            if (_log.isDebugEnabled()) {
                _log.debug("pruning block location record cache for vehicle=" + key.getVehicleId() + " block=" + key.getBlockInstance());
            }
            it.remove();
            this.removeRecordsForKey(key, false);
        }
    }

    private <K> List<BlockLocationRecordCollection> getRecordsFromMap(ConcurrentMap<K, List<BlockLocationRecordKey>> map, K subKey) {
        ArrayList<BlockLocationRecordCollection> allRecords = new ArrayList<BlockLocationRecordCollection>();
        List keys = (List)map.get(subKey);
        if (keys != null) {
            for (BlockLocationRecordKey key : keys) {
                BlockLocationRecordCollection records = (BlockLocationRecordCollection)this._recordsByKey.get(key);
                if (records == null) continue;
                allRecords.add(records);
            }
        }
        return allRecords;
    }

    private <K> void addKeyToMap(ConcurrentMap<K, List<BlockLocationRecordKey>> map, K subKey, BlockLocationRecordKey key) {
        ArrayList<BlockLocationRecordKey> extendedCopy;
        ArrayList origCopy;
        do {
            List<BlockLocationRecordKey> newKeys;
            List<BlockLocationRecordKey> keys;
            if ((keys = (List<BlockLocationRecordKey>)map.get(subKey)) == null && (keys = map.putIfAbsent(subKey, newKeys = Arrays.asList(key))) == null) {
                return;
            }
            origCopy = new ArrayList(keys);
            if (origCopy.contains(key)) {
                return;
            }
            extendedCopy = new ArrayList<BlockLocationRecordKey>(origCopy);
            extendedCopy.add(key);
        } while (!map.replace(subKey, origCopy, extendedCopy));
    }

    private void removeRecordsForKey(BlockLocationRecordKey key, boolean removeRecords) {
        if (removeRecords) {
            this._recordsByKey.remove(key);
        }
        this.removeKeyFromMap(this._keysByBlockInstance, key, key.getBlockInstance());
        this.removeKeyFromMap(this._keysByVehicleId, key, key.getVehicleId());
    }

    private <K> void removeKeyFromMap(ConcurrentMap<K, List<BlockLocationRecordKey>> map, BlockLocationRecordKey key, K subKey) {
        ArrayList origCopy;
        ArrayList reducedCopy;
        do {
            List keys;
            if ((keys = (List)map.get(subKey)) == null) {
                return;
            }
            origCopy = new ArrayList(keys);
            if (!origCopy.contains(key)) {
                return;
            }
            reducedCopy = new ArrayList(origCopy);
            reducedCopy.remove(key);
        } while (!(reducedCopy.isEmpty() ? map.remove(subKey, origCopy) : map.replace(subKey, origCopy, reducedCopy)));
    }

    private class CacheEvictionHandler
    implements Runnable {
        private CacheEvictionHandler() {
        }

        @Override
        public void run() {
            BlockLocationRecordCacheImpl.this.clearStaleRecords(SystemTime.currentTimeMillis() - (long)(BlockLocationRecordCacheImpl.this._blockLocationRecordCacheWindowSize * 1000));
        }
    }
}

