/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.narrative;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.transit_data_federation.impl.narrative.NarrativeProviderImpl;
import org.onebusaway.transit_data_federation.model.ShapePoints;
import org.onebusaway.transit_data_federation.model.narrative.AgencyNarrative;
import org.onebusaway.transit_data_federation.model.narrative.RouteCollectionNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopNarrative;
import org.onebusaway.transit_data_federation.model.narrative.StopTimeNarrative;
import org.onebusaway.transit_data_federation.model.narrative.TripNarrative;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.onebusaway.transit_data_federation.services.blocks.BlockTripIndex;
import org.onebusaway.transit_data_federation.services.narrative.NarrativeService;
import org.onebusaway.transit_data_federation.services.transit_graph.BlockTripEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.StopTimeEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.utility.ObjectSerializationLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NarrativeServiceImpl
implements NarrativeService {
    private static Logger _log = LoggerFactory.getLogger(NarrativeServiceImpl.class);
    private Map<AgencyAndId, TripNarrative> _dynamicTripCache = new HashMap<AgencyAndId, TripNarrative>();
    private NarrativeProviderImpl _provider;
    private FederatedTransitDataBundle _bundle;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    public void setStopTimeNarrativeProvider(NarrativeProviderImpl provider) {
        this._provider = provider;
    }

    @PostConstruct
    @Refreshable(dependsOn={"narrativeData"})
    public void setup() throws IOException, ClassNotFoundException {
        File path = this._bundle.getNarrativeProviderPath();
        this._provider = path.exists() ? (NarrativeProviderImpl)ObjectSerializationLibrary.readObject((File)path) : new NarrativeProviderImpl();
    }

    @Override
    public AgencyNarrative getAgencyForId(String agencyId) {
        return this._provider.getNarrativeForAgencyId(agencyId);
    }

    @Override
    public StopNarrative getStopForId(AgencyAndId stopId) {
        return this._provider.getNarrativeForStopId(stopId);
    }

    @Override
    public StopTimeNarrative getStopTimeForEntry(StopTimeEntry entry) {
        return this._provider.getNarrativeForStopTimeEntry(entry);
    }

    @Override
    public RouteCollectionNarrative getRouteCollectionForId(AgencyAndId routeCollectionId) {
        return this._provider.getRouteCollectionNarrativeForId(routeCollectionId);
    }

    @Override
    public TripNarrative getTripForId(AgencyAndId tripId) {
        TripNarrative tn = this._provider.getNarrativeForTripId(tripId);
        if (tn == null) {
            tn = this._dynamicTripCache.get(tripId);
        }
        return tn;
    }

    @Override
    public ShapePoints getShapePointsForId(AgencyAndId id) {
        return this._provider.getShapePointsForId(id);
    }

    @Override
    public void addDynamicTrip(BlockTripIndex blockTripIndex) {
        this.addDynamicTrip(blockTripIndex, false);
    }

    @Override
    public void updateDynamicTrip(BlockTripIndex blockTripIndex) {
        this.addDynamicTrip(blockTripIndex, true);
    }

    private void addDynamicTrip(BlockTripIndex blockTripIndex, boolean forceUpdate) {
        int lastStopIndex;
        BlockTripEntry blockTripEntry = blockTripIndex.getTrips().get(0);
        TripEntry trip = blockTripEntry.getTrip();
        AgencyAndId tripId = trip.getId();
        if (this._dynamicTripCache.containsKey(tripId) && !forceUpdate) {
            return;
        }
        TripNarrative.Builder builder = TripNarrative.builder();
        RouteCollectionNarrative routeNarrative = this.getRouteCollectionForId(trip.getRoute().getId());
        List<StopTimeEntry> stopTimes = trip.getStopTimes();
        AgencyAndId stopId = stopTimes.get(lastStopIndex = stopTimes.size() - 1).getStop().getId();
        StopNarrative stopForId = this.getStopForId(stopId);
        if (stopForId == null) {
            _log.error("no such stop {}", (Object)stopId);
            return;
        }
        builder.setTripHeadsign(stopForId.getName());
        builder.setRouteShortName(routeNarrative.getShortName());
        this._dynamicTripCache.put(tripId, builder.create());
    }

    @Override
    public List<StopTimeNarrative> getStopTimeNarrativesForPattern(AgencyAndId routeId, String directionId, List<AgencyAndId> stopIds) {
        return this._provider.getStopTimeNarrativesForPattern(routeId, directionId, stopIds);
    }

    @Override
    public StopTimeNarrative getStopTimeNarrativeForPattern(AgencyAndId routeId, AgencyAndId stopId, String directionId) {
        return this._provider.getStopTimeNarrativeForPattern(routeId, stopId, directionId);
    }

    @Override
    public void addShapePoints(ShapePoints shapePoints) {
        this._provider.addShapePoints(shapePoints);
    }

    @Override
    public List<AgencyAndId> getStaticRoutes(AgencyAndId stopId) {
        return this._provider.getStaticRoutes(stopId);
    }
}

