/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.federated;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.exceptions.NoSuchTripServiceException;
import org.onebusaway.exceptions.OutOfServiceAreaServiceException;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.annotations.FederatedByAgencyIdMethod;
import org.onebusaway.federations.annotations.FederatedByEntityIdMethod;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.gtfs.model.calendar.ServiceDate;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.OccupancyStatusBean;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureForStopQueryBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.ConsolidatedStopMapBean;
import org.onebusaway.transit_data.model.HistoricalOccupancyByStopQueryBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RegisterAlarmQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteGroupingBean;
import org.onebusaway.transit_data.model.RouteScheduleBean;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopCalendarDaysBean;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data.model.StopRouteScheduleBean;
import org.onebusaway.transit_data.model.StopScheduleBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.transit_data.model.blocks.BlockBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.ScheduledBlockLocationBean;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data.model.problems.ETripProblemGroupBy;
import org.onebusaway.transit_data.model.problems.StopProblemReportBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportSummaryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportSummaryBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateQueryBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordQueryBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertRecordBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsQueryBean;
import org.onebusaway.transit_data.model.trips.TripForVehicleQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForBoundsQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;
import org.onebusaway.transit_data_federation.impl.realtime.apc.VehicleOccupancyRecordCache;
import org.onebusaway.transit_data_federation.model.bundle.HistoricalRidership;
import org.onebusaway.transit_data_federation.services.AgencyService;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureAlarmService;
import org.onebusaway.transit_data_federation.services.ArrivalAndDepartureQuery;
import org.onebusaway.transit_data_federation.services.CanonicalRoutesService;
import org.onebusaway.transit_data_federation.services.ConsolidatedStopsService;
import org.onebusaway.transit_data_federation.services.PredictionHelperService;
import org.onebusaway.transit_data_federation.services.RidershipService;
import org.onebusaway.transit_data_federation.services.ScheduleHelperService;
import org.onebusaway.transit_data_federation.services.StopSwapService;
import org.onebusaway.transit_data_federation.services.beans.AgencyBeanService;
import org.onebusaway.transit_data_federation.services.beans.ArrivalsAndDeparturesBeanService;
import org.onebusaway.transit_data_federation.services.beans.BlockBeanService;
import org.onebusaway.transit_data_federation.services.beans.RouteBeanService;
import org.onebusaway.transit_data_federation.services.beans.RouteScheduleBeanService;
import org.onebusaway.transit_data_federation.services.beans.RoutesBeanService;
import org.onebusaway.transit_data_federation.services.beans.ServiceAlertsBeanService;
import org.onebusaway.transit_data_federation.services.beans.ShapeBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopScheduleBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopWithArrivalsAndDeparturesBeanService;
import org.onebusaway.transit_data_federation.services.beans.StopsBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripBeanService;
import org.onebusaway.transit_data_federation.services.beans.TripDetailsBeanService;
import org.onebusaway.transit_data_federation.services.beans.VehicleStatusBeanService;
import org.onebusaway.transit_data_federation.services.blocks.BlockCalendarService;
import org.onebusaway.transit_data_federation.services.blocks.BlockInstance;
import org.onebusaway.transit_data_federation.services.bundle.TransitDataServiceTemplate;
import org.onebusaway.transit_data_federation.services.realtime.CurrentVehicleEstimationService;
import org.onebusaway.transit_data_federation.services.reporting.UserReportingService;
import org.onebusaway.transit_data_federation.services.transit_graph.StopEntry;
import org.onebusaway.transit_data_federation.services.transit_graph.TransitGraphDao;
import org.onebusaway.transit_data_federation.services.transit_graph.TripEntry;
import org.onebusaway.util.AgencyAndIdLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TransitDataServiceTemplateImpl
implements TransitDataServiceTemplate {
    private static Logger _log = LoggerFactory.getLogger(TransitDataServiceTemplateImpl.class);
    @Autowired
    private TransitGraphDao _transitGraphDao;
    @Autowired
    private AgencyBeanService _agencyBeanService;
    @Autowired
    private AgencyService _agencyService;
    @Autowired
    private StopBeanService _stopBeanService;
    @Autowired
    private RouteBeanService _routeBeanService;
    @Autowired
    private StopScheduleBeanService _stopScheduleBeanService;
    @Autowired
    private RouteScheduleBeanService _routeScheduleBeanService;
    @Autowired
    private StopWithArrivalsAndDeparturesBeanService _stopWithArrivalsAndDepaturesBeanService;
    @Autowired
    private ArrivalsAndDeparturesBeanService _arrivalsAndDeparturesBeanService;
    @Autowired
    private ArrivalAndDepartureAlarmService _arrivalAndDepartureAlarmService;
    @Autowired
    private StopsBeanService _stopsBeanService;
    @Autowired
    private RoutesBeanService _routesBeanService;
    @Autowired
    private TripBeanService _tripBeanService;
    @Autowired
    private TripDetailsBeanService _tripDetailsBeanService;
    @Autowired
    private BlockBeanService _blockBeanService;
    @Autowired
    private BlockCalendarService _blockCalendarService;
    @Autowired
    private ShapeBeanService _shapeBeanService;
    @Autowired
    private ServiceAlertsBeanService _serviceAlertsBeanService;
    @Autowired
    private UserReportingService _userReportingService;
    @Autowired
    private CurrentVehicleEstimationService _currentVehicleEstimateService;
    @Autowired
    private VehicleStatusBeanService _vehicleStatusBeanService;
    @Autowired
    private PredictionHelperService _predictionHelperService;
    @Autowired
    private ScheduleHelperService _scheduleHelperService;
    @Autowired
    private ConsolidatedStopsService _consolidatedStopsService;
    @Autowired
    private RidershipService _ridershipService;
    @Autowired
    private VehicleOccupancyRecordCache _vehicleOccupancyRecordCache;
    @Autowired
    private CanonicalRoutesService _canonicalRouteServce;
    @Autowired
    private StopSwapService _stopSwapService;

    public Map<String, List<CoordinateBounds>> getAgencyIdsWithCoverageArea() {
        Map<String, CoordinateBounds> agencyIdsAndCoverageAreas = this._agencyService.getAgencyIdsAndCoverageAreas();
        HashMap<String, List<CoordinateBounds>> result = new HashMap<String, List<CoordinateBounds>>();
        for (Map.Entry<String, CoordinateBounds> entry : agencyIdsAndCoverageAreas.entrySet()) {
            String agencyId = entry.getKey();
            CoordinateBounds bounds = entry.getValue();
            List<CoordinateBounds> coverage = Arrays.asList(bounds);
            result.put(agencyId, coverage);
        }
        return result;
    }

    public List<AgencyWithCoverageBean> getAgenciesWithCoverage() throws ServiceException {
        Map<String, CoordinateBounds> agencyIdsAndCoverageAreas = this._agencyService.getAgencyIdsAndCoverageAreas();
        ArrayList<AgencyWithCoverageBean> beans = new ArrayList<AgencyWithCoverageBean>();
        for (Map.Entry<String, CoordinateBounds> entry : agencyIdsAndCoverageAreas.entrySet()) {
            String agencyId = entry.getKey();
            CoordinateBounds bounds = entry.getValue();
            AgencyBean agencyBean = this._agencyBeanService.getAgencyForId(agencyId);
            if (agencyBean == null) {
                throw new ServiceException("agency not found: " + agencyId);
            }
            AgencyWithCoverageBean bean = new AgencyWithCoverageBean();
            bean.setAgency(agencyBean);
            bean.setLat((bounds.getMaxLat() + bounds.getMinLat()) / 2.0);
            bean.setLon((bounds.getMaxLon() + bounds.getMinLon()) / 2.0);
            bean.setLatSpan(bounds.getMaxLat() - bounds.getMinLat());
            bean.setLonSpan(bounds.getMaxLon() - bounds.getMinLon());
            beans.add(bean);
        }
        return beans;
    }

    public AgencyBean getAgency(String agencyId) throws ServiceException {
        return this._agencyBeanService.getAgencyForId(agencyId);
    }

    public StopScheduleBean getScheduleForStop(String stopId, Date date) throws ServiceException {
        StopScheduleBean bean = new StopScheduleBean();
        bean.setDate(date);
        AgencyAndId id = this.convertAgencyAndId(stopId);
        StopBean stopBean = this._stopBeanService.getStopForId(id, null);
        if (stopBean == null) {
            return null;
        }
        bean.setStop(stopBean);
        ServiceDate serviceDate = new ServiceDate(date);
        List<StopRouteScheduleBean> routes = this._stopScheduleBeanService.getScheduledArrivalsForStopAndDate(id, serviceDate);
        bean.setRoutes(routes);
        StopCalendarDaysBean calendarDays = this._stopScheduleBeanService.getCalendarForStop(id);
        bean.setCalendarDays(calendarDays);
        return bean;
    }

    public RouteScheduleBean getScheduleForRoute(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        return this._routeScheduleBeanService.getScheduledArrivalsForInterval(routeId, serviceInterval);
    }

    public StopsBean getStops(SearchQueryBean query) throws ServiceException {
        this.checkBounds(query.getBounds());
        return this._stopsBeanService.getStops(query);
    }

    public StopsBean getStopsByName(String stopName) throws ServiceException {
        return this._stopsBeanService.getStopsByName(stopName);
    }

    public StopBean getStop(String stopId) throws ServiceException {
        AgencyAndId id = this.convertAgencyAndId(stopId);
        return this._stopBeanService.getStopForId(id, null);
    }

    public StopBean getStopForServiceDate(String stopId, AgencyServiceInterval serviceInterval) throws ServiceException {
        AgencyAndId id = this.convertAgencyAndId(stopId);
        return this._stopBeanService.getStopForIdForServiceDate(id, serviceInterval);
    }

    public ListBean<String> getStopIdsForAgencyId(String agencyId) {
        return this._stopsBeanService.getStopsIdsForAgencyId(agencyId);
    }

    public StopsBean getStopsForAgencyId(String agencyId) {
        return this._stopsBeanService.getStopsForAgencyId(agencyId);
    }

    public StopWithArrivalsAndDeparturesBean getStopWithArrivalsAndDepartures(String stopId, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) throws ServiceException {
        AgencyAndId id = this.convertAgencyAndId(stopId);
        return this._stopWithArrivalsAndDepaturesBeanService.getArrivalsAndDeparturesByStopId(id, query, serviceInterval);
    }

    public StopsWithArrivalsAndDeparturesBean getStopsWithArrivalsAndDepartures(Collection<String> stopIds, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) throws ServiceException {
        Set<AgencyAndId> ids = this.convertAgencyAndIds(stopIds);
        return this._stopWithArrivalsAndDepaturesBeanService.getArrivalsAndDeparturesForStopIds(ids, query, serviceInterval);
    }

    public ArrivalAndDepartureBean getArrivalAndDepartureForStop(ArrivalAndDepartureForStopQueryBean query) throws ServiceException {
        ArrivalAndDepartureQuery adQuery = this.createArrivalAndDepartureQuery(query);
        return this._arrivalsAndDeparturesBeanService.getArrivalAndDepartureForStop(adQuery, query.getServiceInterval());
    }

    public String registerAlarmForArrivalAndDepartureAtStop(ArrivalAndDepartureForStopQueryBean query, RegisterAlarmQueryBean alarm) {
        ArrivalAndDepartureQuery adQuery = this.createArrivalAndDepartureQuery(query);
        AgencyAndId alarmId = this._arrivalAndDepartureAlarmService.registerAlarmForArrivalAndDepartureAtStop(adQuery, alarm);
        return AgencyAndIdLibrary.convertToString((AgencyAndId)alarmId);
    }

    public void cancelAlarmForArrivalAndDepartureAtStop(String alarmId) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)alarmId);
        this._arrivalAndDepartureAlarmService.cancelAlarmForArrivalAndDepartureAtStop(id);
    }

    public RouteBean getRouteForId(String routeId) throws ServiceException {
        return this._routeBeanService.getRouteForId(this.convertAgencyAndId(routeId));
    }

    public ListBean<String> getRouteIdsForAgencyId(String agencyId) {
        return this._routesBeanService.getRouteIdsForAgencyId(agencyId);
    }

    public ListBean<RouteBean> getRoutesForAgencyId(String agencyId) {
        return this._routesBeanService.getRoutesForAgencyId(agencyId);
    }

    public StopsForRouteBean getStopsForRoute(String routeId) {
        return this._routeBeanService.getStopsForRoute(this.convertAgencyAndId(routeId));
    }

    public StopsForRouteBean getStopsForRouteForServiceInterval(String routeId, AgencyServiceInterval serviceInterval) {
        return this._routeBeanService.getStopsForRouteForServiceInterval(this.convertAgencyAndId(routeId), serviceInterval);
    }

    public TripBean getTrip(String tripId) throws ServiceException {
        return this._tripBeanService.getTripForId(this.convertAgencyAndId(tripId));
    }

    public TripDetailsBean getSingleTripDetails(TripDetailsQueryBean query) throws ServiceException {
        return this._tripDetailsBeanService.getTripForId(query);
    }

    public ListBean<TripDetailsBean> getTripDetails(TripDetailsQueryBean query) throws ServiceException {
        return this._tripDetailsBeanService.getTripsForId(query);
    }

    public ListBean<TripDetailsBean> getTripsForBounds(TripsForBoundsQueryBean query) {
        this.checkBounds(query.getBounds());
        return this._tripDetailsBeanService.getTripsForBounds(query);
    }

    public ListBean<TripDetailsBean> getTripsForRoute(TripsForRouteQueryBean query) {
        return this._tripDetailsBeanService.getTripsForRoute(query);
    }

    public ListBean<TripDetailsBean> getTripsForAgency(TripsForAgencyQueryBean query) {
        return this._tripDetailsBeanService.getTripsForAgency(query);
    }

    public BlockBean getBlockForId(String blockId) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)blockId);
        return this._blockBeanService.getBlockForId(id);
    }

    public BlockInstanceBean getBlockInstance(String blockId, long serviceDate) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)blockId);
        return this._blockBeanService.getBlockInstance(id, serviceDate);
    }

    public ScheduledBlockLocationBean getScheduledBlockLocationFromScheduledTime(String blockId, long serviceDate, int scheduledTime) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)blockId);
        return this._blockBeanService.getScheduledBlockLocationFromScheduledTime(id, serviceDate, scheduledTime);
    }

    public List<BlockInstanceBean> getActiveBlocksForRoute(AgencyAndId route, long timeFrom, long timeTo) {
        ArrayList<BlockInstanceBean> blockInstanceBeans = new ArrayList<BlockInstanceBean>();
        List<BlockInstance> blockInstances = this._blockCalendarService.getActiveBlocksForRouteInTimeRange(route, timeFrom, timeTo);
        for (BlockInstance block : blockInstances) {
            blockInstanceBeans.add(this._blockBeanService.getBlockInstanceAsBean(block));
        }
        return blockInstanceBeans;
    }

    public VehicleStatusBean getVehicleForAgency(String vehicleId, long time) {
        AgencyAndId vid = AgencyAndIdLibrary.convertFromString((String)vehicleId);
        return this._vehicleStatusBeanService.getVehicleForId(vid, time);
    }

    public ListBean<VehicleStatusBean> getAllVehiclesForAgency(String agencyId, long time) {
        return this._vehicleStatusBeanService.getAllVehiclesForAgency(agencyId, time);
    }

    public ListBean<VehicleStatusBean> getFilteredVehiclesForAgency(String agencyId, long time, Integer ageInSeconds) {
        return this._vehicleStatusBeanService.getFilteredVehiclesForAgency(agencyId, time, ageInSeconds);
    }

    public VehicleLocationRecordBean getVehicleLocationRecordForVehicleId(String vehicleId, long targetTime) {
        AgencyAndId id = this.convertAgencyAndId(vehicleId);
        return this._vehicleStatusBeanService.getVehicleLocationRecordForVehicleId(id, targetTime);
    }

    public VehicleLocationRecordBean getVehiclePositionForVehicleId(String vehicleId) {
        AgencyAndId id = this.convertAgencyAndId(vehicleId);
        return this._vehicleStatusBeanService.getVehiclePositionForVehicleId(id);
    }

    public TripDetailsBean getTripDetailsForVehicleAndTime(TripForVehicleQueryBean query) {
        AgencyAndId id = this.convertAgencyAndId(query.getVehicleId());
        return this._tripDetailsBeanService.getTripForVehicle(id, query.getTime().getTime(), query.getInclusion());
    }

    public RoutesBean getRoutes(SearchQueryBean query) throws ServiceException {
        this.checkBounds(query.getBounds());
        return this._routesBeanService.getRoutesForQuery(query);
    }

    public EncodedPolylineBean getShapeForId(String shapeId) {
        AgencyAndId id = this.convertAgencyAndId(shapeId);
        return this._shapeBeanService.getPolylineForShapeId(id);
    }

    public ListBean<String> getShapeIdsForAgencyId(String agencyId) {
        return this._shapeBeanService.getShapeIdsForAgencyId(agencyId);
    }

    public ListBean<CurrentVehicleEstimateBean> getCurrentVehicleEstimates(CurrentVehicleEstimateQueryBean query) {
        return this._currentVehicleEstimateService.getCurrentVehicleEstimates(query);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipForStop(HistoricalOccupancyByStopQueryBean query) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)query.getStopId());
        List<HistoricalRidership> hrs = this._ridershipService.getHistoricalRidershipsForStop(id, query.getServiceDate());
        return this._ridershipService.convertToOccupancyStatusBeans(hrs);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipsForTrip(AgencyAndId tripId, long serviceDate) {
        List<HistoricalRidership> hrs = this._ridershipService.getHistoricalRidershipsForTrip(tripId, serviceDate);
        return this._ridershipService.convertToOccupancyStatusBeans(hrs);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipsForRoute(AgencyAndId routeId, long serviceDate) {
        List<HistoricalRidership> hrs = this._ridershipService.getHistoricalRidershipsForRoute(routeId, serviceDate);
        return this._ridershipService.convertToOccupancyStatusBeans(hrs);
    }

    public List<OccupancyStatusBean> getHistoricalRiderships(AgencyAndId routeId, AgencyAndId tripId, AgencyAndId stopId, long serviceDate) {
        List<HistoricalRidership> hrs = this._ridershipService.getHistoricalRiderships(routeId, tripId, stopId, serviceDate);
        return this._ridershipService.convertToOccupancyStatusBeans(hrs);
    }

    public List<OccupancyStatusBean> getAllHistoricalRiderships(long serviceDate) {
        List<HistoricalRidership> hrs = this._ridershipService.getAllHistoricalRiderships(serviceDate);
        return this._ridershipService.convertToOccupancyStatusBeans(hrs);
    }

    public ListBean<VehicleLocationRecordBean> getVehicleLocationRecords(VehicleLocationRecordQueryBean query) {
        return this._vehicleStatusBeanService.getVehicleLocations(query);
    }

    public VehicleOccupancyRecord getVehicleOccupancyRecordForVehicleIdAndRoute(AgencyAndId vehicleId, String routeId, String directionId) {
        return this._vehicleOccupancyRecordCache.getRecordForVehicleIdAndRoute(vehicleId, routeId, directionId);
    }

    public void submitVehicleLocation(VehicleLocationRecordBean record) {
        this._vehicleStatusBeanService.submitVehicleLocation(record);
    }

    @FederatedByEntityIdMethod
    public void resetVehicleLocation(String vehicleId) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)vehicleId);
        this._vehicleStatusBeanService.resetVehicleLocation(id);
    }

    public ServiceAlertBean createServiceAlert(String agencyId, ServiceAlertBean situation) {
        return this._serviceAlertsBeanService.createServiceAlert(agencyId, situation);
    }

    public void updateServiceAlert(ServiceAlertBean situation) {
        this._serviceAlertsBeanService.updateServiceAlert(situation);
    }

    public ServiceAlertBean copyServiceAlert(String agencyId, ServiceAlertBean situation) {
        return this._serviceAlertsBeanService.copyServiceAlert(agencyId, situation);
    }

    public ServiceAlertBean getServiceAlertForId(String situationId) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)situationId);
        return this._serviceAlertsBeanService.getServiceAlertForId(id);
    }

    public void removeServiceAlert(String situationId) {
        AgencyAndId id = AgencyAndIdLibrary.convertFromString((String)situationId);
        this._serviceAlertsBeanService.removeServiceAlert(id);
    }

    public ListBean<ServiceAlertBean> getAllServiceAlertsForAgencyId(String agencyId) {
        List<ServiceAlertBean> situations = this._serviceAlertsBeanService.getServiceAlertsForFederatedAgencyId(agencyId);
        return new ListBean(situations, false);
    }

    public ListBean<ServiceAlertRecordBean> getAllServiceAlertRecordsForAgencyId(String agencyId) {
        List<ServiceAlertRecordBean> situations = this._serviceAlertsBeanService.getServiceAlertRecordsForFederatedAgencyId(agencyId);
        return new ListBean(situations, false);
    }

    public void removeAllServiceAlertsForAgencyId(String agencyId) {
        this._serviceAlertsBeanService.removeAllServiceAlertsForFederatedAgencyId(agencyId);
    }

    public ListBean<ServiceAlertBean> getServiceAlerts(SituationQueryBean query) {
        List<ServiceAlertBean> situations = this._serviceAlertsBeanService.getServiceAlerts(query);
        return new ListBean(situations, false);
    }

    public void reportProblemWithStop(StopProblemReportBean problem) {
        this._userReportingService.reportProblemWithStop(problem);
    }

    public void reportProblemWithTrip(TripProblemReportBean problem) {
        this._userReportingService.reportProblemWithTrip(problem);
    }

    public ListBean<StopProblemReportSummaryBean> getStopProblemReportSummaries(StopProblemReportQueryBean query) {
        return this._userReportingService.getStopProblemReportSummaries(query);
    }

    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummaries(TripProblemReportQueryBean query) {
        return this.getTripProblemReportSummariesByGrouping(query, ETripProblemGroupBy.TRIP);
    }

    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummariesByGrouping(TripProblemReportQueryBean query, ETripProblemGroupBy groupBy) {
        return this._userReportingService.getTripProblemReportSummaries(query, groupBy);
    }

    @FederatedByAgencyIdMethod
    public ListBean<StopProblemReportBean> getStopProblemReports(StopProblemReportQueryBean query) {
        return this._userReportingService.getStopProblemReports(query);
    }

    public ListBean<TripProblemReportBean> getTripProblemReports(TripProblemReportQueryBean query) {
        return this._userReportingService.getTripProblemReports(query);
    }

    public List<StopProblemReportBean> getAllStopProblemReportsForStopId(String stopId) {
        return this._userReportingService.getAllStopProblemReportsForStopId(this.convertAgencyAndId(stopId));
    }

    public List<TripProblemReportBean> getAllTripProblemReportsForTripId(String tripId) {
        return this._userReportingService.getAllTripProblemReportsForTripId(this.convertAgencyAndId(tripId));
    }

    public StopProblemReportBean getStopProblemReportForStopIdAndId(String stopId, long id) {
        return this._userReportingService.getStopProblemReportForId(id);
    }

    public TripProblemReportBean getTripProblemReportForTripIdAndId(String tripId, long id) {
        return this._userReportingService.getTripProblemReportForId(id);
    }

    public void deleteStopProblemReportForStopIdAndId(String stopId, long id) {
        this._userReportingService.deleteStopProblemReportForId(id);
    }

    public void updateTripProblemReport(TripProblemReportBean tripProblemReport) {
        this._userReportingService.updateTripProblemReport(tripProblemReport);
    }

    public void deleteTripProblemReportForTripIdAndId(String tripId, long id) {
        this._userReportingService.deleteTripProblemReportForId(id);
    }

    public List<String> getAllTripProblemReportLabels() {
        return this._userReportingService.getAllTripProblemReportLabels();
    }

    public List<TimepointPredictionRecord> getPredictionRecordsForTrip(String agencyId, TripStatusBean tripStatus) {
        return this._predictionHelperService.getPredictionRecordsForTrip(agencyId, tripStatus);
    }

    public Boolean routeHasUpcomingScheduledService(String routeAgencyId, long time, String routeId, String directionId) {
        return this._scheduleHelperService.routeHasUpcomingScheduledService(routeAgencyId, time, routeId, directionId);
    }

    public Boolean stopHasUpcomingScheduledService(String stopAgencyId, long time, String stopId, String routeId, String directionId) {
        return this._scheduleHelperService.stopHasUpcomingScheduledService(stopAgencyId, time, stopId, routeId, directionId);
    }

    public List<String> getSearchSuggestions(String agencyId, String input) {
        return this._scheduleHelperService.getSearchSuggestions(agencyId, input);
    }

    public Boolean stopHasRevenueServiceOnRoute(String stopAgencyId, String stopId, String routeId, String directionId) {
        return this._scheduleHelperService.stopHasRevenueServiceOnRoute(stopAgencyId, stopId, routeId, directionId);
    }

    public Boolean stopHasRevenueService(String agencyId, String stopId) {
        return this._scheduleHelperService.stopHasRevenueService(agencyId, stopId);
    }

    public List<StopBean> getAllRevenueStops(AgencyWithCoverageBean agency) {
        SearchQueryBean query = new SearchQueryBean();
        CoordinateBounds bounds = new CoordinateBounds();
        double lat = agency.getLat();
        double lon = agency.getLon();
        double latSpan = agency.getLatSpan() / 2.0;
        double lonSpan = agency.getLonSpan() / 2.0;
        bounds.addPoint(lat - latSpan, lon - lonSpan);
        bounds.addPoint(lat + latSpan, lon + lonSpan);
        query.setBounds(bounds);
        query.setMaxCount(Integer.MAX_VALUE);
        return this._scheduleHelperService.filterRevenueService(agency.getAgency(), this.getStops(query));
    }

    public String getActiveBundleId() {
        return null;
    }

    public BundleMetadata getBundleMetadata() {
        return null;
    }

    public ListBean<RouteGroupingBean> getCanonicalRoute(AgencyServiceInterval serviceInterval, AgencyAndId routeId) {
        return this._canonicalRouteServce.getCanonicalOrMergedRoute(serviceInterval, routeId);
    }

    public ListBean<ConsolidatedStopMapBean> getAllConsolidatedStops() {
        ListBean ret = new ListBean();
        Collection<ConsolidatedStopMapBean> beans = this._consolidatedStopsService.getAllConsolidatedStops();
        ret.setList(new ArrayList<ConsolidatedStopMapBean>(beans));
        return ret;
    }

    public StopDirectionSwap findStopDirectionSwap(AgencyAndId routeId, String directionId, AgencyAndId stopId) {
        return this._stopSwapService.findStopDirectionSwap(routeId, directionId, stopId);
    }

    protected AgencyAndId convertAgencyAndId(String id) {
        return AgencyAndIdLibrary.convertFromString((String)id);
    }

    protected Set<AgencyAndId> convertAgencyAndIds(Iterable<String> ids) {
        HashSet<AgencyAndId> converted = new HashSet<AgencyAndId>();
        for (String id : ids) {
            converted.add(this.convertAgencyAndId(id));
        }
        return converted;
    }

    protected ArrivalAndDepartureQuery createArrivalAndDepartureQuery(ArrivalAndDepartureForStopQueryBean query) {
        ArrivalAndDepartureQuery adQuery = new ArrivalAndDepartureQuery();
        AgencyAndId stopId = AgencyAndIdLibrary.convertFromString((String)query.getStopId());
        StopEntry stop = this._transitGraphDao.getStopEntryForId(stopId, true);
        AgencyAndId tripId = AgencyAndIdLibrary.convertFromString((String)query.getTripId());
        TripEntry trip = this._transitGraphDao.getTripEntryForId(tripId);
        if (trip == null) {
            throw new NoSuchTripServiceException(query.getTripId());
        }
        adQuery.setStop(stop);
        adQuery.setStopSequence(query.getStopSequence());
        adQuery.setTrip(trip);
        adQuery.setServiceDate(query.getServiceDate());
        adQuery.setVehicleId(AgencyAndIdLibrary.convertFromString((String)query.getVehicleId()));
        adQuery.setTime(query.getTime());
        adQuery.setAgenciesExcludingScheduled(query.getAgenciesExcludingScheduled());
        return adQuery;
    }

    protected void checkBounds(CoordinateBounds cb) {
        if (cb == null) {
            return;
        }
        Collection<CoordinateBounds> allAgencyBounds = this._agencyService.getAgencyIdsAndCoverageAreas().values();
        for (CoordinateBounds agencyBounds : allAgencyBounds) {
            if (!agencyBounds.intersects(cb)) continue;
            return;
        }
        throw new OutOfServiceAreaServiceException(cb.toString());
    }
}

