/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.federated;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.onebusaway.exceptions.ServiceException;
import org.onebusaway.federations.annotations.FederatedByAgencyIdMethod;
import org.onebusaway.federations.annotations.FederatedByEntityIdMethod;
import org.onebusaway.geospatial.model.CoordinateBounds;
import org.onebusaway.geospatial.model.EncodedPolylineBean;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.calendar.AgencyServiceInterval;
import org.onebusaway.realtime.api.TimepointPredictionRecord;
import org.onebusaway.realtime.api.VehicleOccupancyRecord;
import org.onebusaway.transit_data.OccupancyStatusBean;
import org.onebusaway.transit_data.model.AgencyBean;
import org.onebusaway.transit_data.model.AgencyWithCoverageBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureBean;
import org.onebusaway.transit_data.model.ArrivalAndDepartureForStopQueryBean;
import org.onebusaway.transit_data.model.ArrivalsAndDeparturesQueryBean;
import org.onebusaway.transit_data.model.ConsolidatedStopMapBean;
import org.onebusaway.transit_data.model.HistoricalOccupancyByStopQueryBean;
import org.onebusaway.transit_data.model.ListBean;
import org.onebusaway.transit_data.model.RegisterAlarmQueryBean;
import org.onebusaway.transit_data.model.RouteBean;
import org.onebusaway.transit_data.model.RouteGroupingBean;
import org.onebusaway.transit_data.model.RouteScheduleBean;
import org.onebusaway.transit_data.model.RoutesBean;
import org.onebusaway.transit_data.model.SearchQueryBean;
import org.onebusaway.transit_data.model.StopBean;
import org.onebusaway.transit_data.model.StopDirectionSwap;
import org.onebusaway.transit_data.model.StopScheduleBean;
import org.onebusaway.transit_data.model.StopWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.StopsBean;
import org.onebusaway.transit_data.model.StopsForRouteBean;
import org.onebusaway.transit_data.model.StopsWithArrivalsAndDeparturesBean;
import org.onebusaway.transit_data.model.VehicleStatusBean;
import org.onebusaway.transit_data.model.blocks.BlockBean;
import org.onebusaway.transit_data.model.blocks.BlockInstanceBean;
import org.onebusaway.transit_data.model.blocks.ScheduledBlockLocationBean;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data.model.problems.ETripProblemGroupBy;
import org.onebusaway.transit_data.model.problems.StopProblemReportBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.StopProblemReportSummaryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportQueryBean;
import org.onebusaway.transit_data.model.problems.TripProblemReportSummaryBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateBean;
import org.onebusaway.transit_data.model.realtime.CurrentVehicleEstimateQueryBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordBean;
import org.onebusaway.transit_data.model.realtime.VehicleLocationRecordQueryBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertBean;
import org.onebusaway.transit_data.model.service_alerts.ServiceAlertRecordBean;
import org.onebusaway.transit_data.model.service_alerts.SituationQueryBean;
import org.onebusaway.transit_data.model.trips.TripBean;
import org.onebusaway.transit_data.model.trips.TripDetailsBean;
import org.onebusaway.transit_data.model.trips.TripDetailsQueryBean;
import org.onebusaway.transit_data.model.trips.TripForVehicleQueryBean;
import org.onebusaway.transit_data.model.trips.TripStatusBean;
import org.onebusaway.transit_data.model.trips.TripsForAgencyQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForBoundsQueryBean;
import org.onebusaway.transit_data.model.trips.TripsForRouteQueryBean;
import org.onebusaway.transit_data.services.TransitDataService;
import org.onebusaway.transit_data_federation.impl.federated.TransitDataServiceTemplateImpl;
import org.onebusaway.transit_data_federation.services.bundle.BundleManagementService;
import org.onebusaway.transit_data_federation.services.bundle.BundleSearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransitDataServiceImpl
implements TransitDataService {
    private static Logger _log = LoggerFactory.getLogger(TransitDataServiceImpl.class);
    @Autowired
    private TransitDataServiceTemplateImpl _transitDataService;
    private BundleManagementService _bundleManagementService;
    @Autowired
    private BundleSearchService _bundleSearchService;
    private int _blockedRequestCounter = 0;

    @Autowired
    public void set_bundleManagementService(BundleManagementService _bundleManagementService) {
        this._bundleManagementService = _bundleManagementService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void blockUntilBundleIsReady() {
        try {
            while (this._bundleManagementService != null && !this._bundleManagementService.bundleIsReady().booleanValue()) {
                ++this._blockedRequestCounter;
                if (this._blockedRequestCounter > 25) {
                    _log.warn("Bundle is not ready or none is loaded--we've blocked 25 TDS requests since last log event.");
                    this._blockedRequestCounter = 0;
                }
                TransitDataServiceImpl transitDataServiceImpl = this;
                synchronized (transitDataServiceImpl) {
                    Thread.sleep(250L);
                    Thread.yield();
                }
            }
            return;
        }
        catch (InterruptedException e) {
            return;
        }
    }

    public Map<String, List<CoordinateBounds>> getAgencyIdsWithCoverageArea() {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAgencyIdsWithCoverageArea();
    }

    public List<AgencyWithCoverageBean> getAgenciesWithCoverage() throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAgenciesWithCoverage();
    }

    public AgencyBean getAgency(String agencyId) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAgency(agencyId);
    }

    public StopScheduleBean getScheduleForStop(String stopId, Date date) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getScheduleForStop(stopId, date);
    }

    public RouteScheduleBean getScheduleForRoute(AgencyAndId routeId, AgencyServiceInterval serviceInterval) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getScheduleForRoute(routeId, serviceInterval);
    }

    public StopsBean getStops(SearchQueryBean query) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStops(query);
    }

    public StopsBean getStopsByName(String stopName) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopsByName(stopName);
    }

    public StopBean getStop(String stopId) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStop(stopId);
    }

    public StopBean getStopForServiceDate(String stopId, AgencyServiceInterval serviceInterval) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopForServiceDate(stopId, serviceInterval);
    }

    public ListBean<String> getStopIdsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopIdsForAgencyId(agencyId);
    }

    public StopsBean getStopsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopsForAgencyId(agencyId);
    }

    public StopWithArrivalsAndDeparturesBean getStopWithArrivalsAndDepartures(String stopId, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopWithArrivalsAndDepartures(stopId, query, serviceInterval);
    }

    public StopsWithArrivalsAndDeparturesBean getStopsWithArrivalsAndDepartures(Collection<String> stopIds, ArrivalsAndDeparturesQueryBean query, AgencyServiceInterval serviceInterval) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopsWithArrivalsAndDepartures(stopIds, query, serviceInterval);
    }

    public ArrivalAndDepartureBean getArrivalAndDepartureForStop(ArrivalAndDepartureForStopQueryBean query) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getArrivalAndDepartureForStop(query);
    }

    public String registerAlarmForArrivalAndDepartureAtStop(ArrivalAndDepartureForStopQueryBean query, RegisterAlarmQueryBean alarm) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.registerAlarmForArrivalAndDepartureAtStop(query, alarm);
    }

    public void cancelAlarmForArrivalAndDepartureAtStop(String alarmId) {
        this.blockUntilBundleIsReady();
        this._transitDataService.cancelAlarmForArrivalAndDepartureAtStop(alarmId);
    }

    public RouteBean getRouteForId(String routeId) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getRouteForId(routeId);
    }

    public ListBean<String> getRouteIdsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getRouteIdsForAgencyId(agencyId);
    }

    public ListBean<RouteBean> getRoutesForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getRoutesForAgencyId(agencyId);
    }

    public StopsForRouteBean getStopsForRoute(String routeId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopsForRoute(routeId);
    }

    public StopsForRouteBean getStopsForRouteForServiceInterval(String routeId, AgencyServiceInterval serviceInterval) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopsForRouteForServiceInterval(routeId, serviceInterval);
    }

    public TripBean getTrip(String tripId) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTrip(tripId);
    }

    public TripDetailsBean getSingleTripDetails(TripDetailsQueryBean query) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getSingleTripDetails(query);
    }

    public ListBean<TripDetailsBean> getTripDetails(TripDetailsQueryBean query) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripDetails(query);
    }

    public ListBean<TripDetailsBean> getTripsForBounds(TripsForBoundsQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripsForBounds(query);
    }

    public ListBean<TripDetailsBean> getTripsForRoute(TripsForRouteQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripsForRoute(query);
    }

    public ListBean<TripDetailsBean> getTripsForAgency(TripsForAgencyQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripsForAgency(query);
    }

    public BlockBean getBlockForId(String blockId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getBlockForId(blockId);
    }

    public BlockInstanceBean getBlockInstance(String blockId, long serviceDate) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getBlockInstance(blockId, serviceDate);
    }

    public ScheduledBlockLocationBean getScheduledBlockLocationFromScheduledTime(String blockId, long serviceDate, int scheduledTime) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getScheduledBlockLocationFromScheduledTime(blockId, serviceDate, scheduledTime);
    }

    public List<BlockInstanceBean> getActiveBlocksForRoute(AgencyAndId route, long timeFrom, long timeTo) {
        return this._transitDataService.getActiveBlocksForRoute(route, timeFrom, timeTo);
    }

    public VehicleStatusBean getVehicleForAgency(String vehicleId, long time) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getVehicleForAgency(vehicleId, time);
    }

    public ListBean<VehicleStatusBean> getAllVehiclesForAgency(String agencyId, long time) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllVehiclesForAgency(agencyId, time);
    }

    public ListBean<VehicleStatusBean> getFilteredVehiclesForAgency(String agencyId, long time, Integer ageInSeconds) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getFilteredVehiclesForAgency(agencyId, time, ageInSeconds);
    }

    public VehicleLocationRecordBean getVehicleLocationRecordForVehicleId(String vehicleId, long targetTime) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getVehicleLocationRecordForVehicleId(vehicleId, targetTime);
    }

    public VehicleLocationRecordBean getVehiclePositionForVehicleId(String vehicleId) {
        return this._transitDataService.getVehiclePositionForVehicleId(vehicleId);
    }

    public TripDetailsBean getTripDetailsForVehicleAndTime(TripForVehicleQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripDetailsForVehicleAndTime(query);
    }

    public RoutesBean getRoutes(SearchQueryBean query) throws ServiceException {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getRoutes(query);
    }

    public EncodedPolylineBean getShapeForId(String shapeId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getShapeForId(shapeId);
    }

    public ListBean<String> getShapeIdsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getShapeIdsForAgencyId(agencyId);
    }

    public ListBean<CurrentVehicleEstimateBean> getCurrentVehicleEstimates(CurrentVehicleEstimateQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getCurrentVehicleEstimates(query);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipForStop(HistoricalOccupancyByStopQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getHistoricalRidershipForStop(query);
    }

    public List<OccupancyStatusBean> getAllHistoricalRiderships(long serviceDate) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllHistoricalRiderships(serviceDate);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipsForTrip(AgencyAndId tripId, long serviceDate) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getHistoricalRidershipsForTrip(tripId, serviceDate);
    }

    public List<OccupancyStatusBean> getHistoricalRidershipsForRoute(AgencyAndId routeId, long serviceDate) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getHistoricalRidershipsForRoute(routeId, serviceDate);
    }

    public List<OccupancyStatusBean> getHistoricalRiderships(AgencyAndId routeId, AgencyAndId tripId, AgencyAndId stopId, long serviceDate) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getHistoricalRiderships(routeId, tripId, stopId, serviceDate);
    }

    public ListBean<VehicleLocationRecordBean> getVehicleLocationRecords(VehicleLocationRecordQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getVehicleLocationRecords(query);
    }

    public VehicleOccupancyRecord getVehicleOccupancyRecordForVehicleIdAndRoute(AgencyAndId vehicleId, String routeId, String directionId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getVehicleOccupancyRecordForVehicleIdAndRoute(vehicleId, routeId, directionId);
    }

    public void submitVehicleLocation(VehicleLocationRecordBean record) {
        this.blockUntilBundleIsReady();
        this._transitDataService.submitVehicleLocation(record);
    }

    @FederatedByEntityIdMethod
    public void resetVehicleLocation(String vehicleId) {
        this.blockUntilBundleIsReady();
        this._transitDataService.resetVehicleLocation(vehicleId);
    }

    public ServiceAlertBean createServiceAlert(String agencyId, ServiceAlertBean situation) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.createServiceAlert(agencyId, situation);
    }

    public void updateServiceAlert(ServiceAlertBean situation) {
        this.blockUntilBundleIsReady();
        this._transitDataService.updateServiceAlert(situation);
    }

    public ServiceAlertBean getServiceAlertForId(String situationId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getServiceAlertForId(situationId);
    }

    public void removeServiceAlert(String situationId) {
        this.blockUntilBundleIsReady();
        this._transitDataService.removeServiceAlert(situationId);
    }

    public ListBean<ServiceAlertBean> getAllServiceAlertsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllServiceAlertsForAgencyId(agencyId);
    }

    public ListBean<ServiceAlertRecordBean> getAllServiceAlertRecordsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllServiceAlertRecordsForAgencyId(agencyId);
    }

    public ListBean<RouteGroupingBean> getCanonicalRoute(AgencyServiceInterval serviceInterval, AgencyAndId routeId) {
        return this._transitDataService.getCanonicalRoute(serviceInterval, routeId);
    }

    public StopDirectionSwap findStopDirectionSwap(AgencyAndId routeId, String directionId, AgencyAndId stopId) {
        return this._transitDataService.findStopDirectionSwap(routeId, directionId, stopId);
    }

    public void removeAllServiceAlertsForAgencyId(String agencyId) {
        this.blockUntilBundleIsReady();
        this._transitDataService.removeAllServiceAlertsForAgencyId(agencyId);
    }

    public ListBean<ServiceAlertBean> getServiceAlerts(SituationQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getServiceAlerts(query);
    }

    public void reportProblemWithStop(StopProblemReportBean problem) {
        this.blockUntilBundleIsReady();
        this._transitDataService.reportProblemWithStop(problem);
    }

    public void reportProblemWithTrip(TripProblemReportBean problem) {
        this.blockUntilBundleIsReady();
        this._transitDataService.reportProblemWithTrip(problem);
    }

    public ListBean<StopProblemReportSummaryBean> getStopProblemReportSummaries(StopProblemReportQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopProblemReportSummaries(query);
    }

    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummaries(TripProblemReportQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripProblemReportSummaries(query);
    }

    public ListBean<TripProblemReportSummaryBean> getTripProblemReportSummariesByGrouping(TripProblemReportQueryBean query, ETripProblemGroupBy groupBy) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripProblemReportSummariesByGrouping(query, groupBy);
    }

    @FederatedByAgencyIdMethod
    public ListBean<StopProblemReportBean> getStopProblemReports(StopProblemReportQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopProblemReports(query);
    }

    public ListBean<TripProblemReportBean> getTripProblemReports(TripProblemReportQueryBean query) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripProblemReports(query);
    }

    public List<StopProblemReportBean> getAllStopProblemReportsForStopId(String stopId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllStopProblemReportsForStopId(stopId);
    }

    public List<TripProblemReportBean> getAllTripProblemReportsForTripId(String tripId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllTripProblemReportsForTripId(tripId);
    }

    public StopProblemReportBean getStopProblemReportForStopIdAndId(String stopId, long id) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getStopProblemReportForStopIdAndId(stopId, id);
    }

    public TripProblemReportBean getTripProblemReportForTripIdAndId(String tripId, long id) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getTripProblemReportForTripIdAndId(tripId, id);
    }

    public void deleteStopProblemReportForStopIdAndId(String stopId, long id) {
        this.blockUntilBundleIsReady();
        this._transitDataService.deleteStopProblemReportForStopIdAndId(stopId, id);
    }

    public void updateTripProblemReport(TripProblemReportBean tripProblemReport) {
        this.blockUntilBundleIsReady();
        this._transitDataService.updateTripProblemReport(tripProblemReport);
    }

    public void deleteTripProblemReportForTripIdAndId(String tripId, long id) {
        this.blockUntilBundleIsReady();
        this._transitDataService.deleteTripProblemReportForTripIdAndId(tripId, id);
    }

    public List<String> getAllTripProblemReportLabels() {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getAllTripProblemReportLabels();
    }

    public String getActiveBundleId() {
        this.blockUntilBundleIsReady();
        return this._bundleManagementService.getActiveBundleId();
    }

    public BundleMetadata getBundleMetadata() {
        this.blockUntilBundleIsReady();
        return this._bundleManagementService.getBundleMetadata();
    }

    public List<TimepointPredictionRecord> getPredictionRecordsForTrip(String agencyId, TripStatusBean tripStatus) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.getPredictionRecordsForTrip(agencyId, tripStatus);
    }

    public Boolean routeHasUpcomingScheduledService(String agencyId, long time, String routeId, String directionId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.routeHasUpcomingScheduledService(agencyId, time, routeId, directionId);
    }

    public Boolean stopHasUpcomingScheduledService(String agencyId, long time, String stopId, String routeId, String directionId) {
        this.blockUntilBundleIsReady();
        return this._transitDataService.stopHasUpcomingScheduledService(agencyId, time, stopId, routeId, directionId);
    }

    public List<String> getSearchSuggestions(String agencyId, String input) {
        List<String> result = this._bundleSearchService.getSuggestions(input);
        return result;
    }

    public ListBean<StopBean> getStopSuggestions(String agencyId, String input, int maxCount) {
        ListBean<StopBean> result = this._bundleSearchService.getStopSuggestions(input, maxCount);
        return result;
    }

    public ListBean<RouteBean> getRouteSuggestions(String agencyId, String input, int maxCount) {
        ListBean<RouteBean> result = this._bundleSearchService.getRouteSuggestions(input, maxCount);
        return result;
    }

    public Boolean stopHasRevenueServiceOnRoute(String agencyId, String stopId, String routeId, String directionId) {
        return this._transitDataService.stopHasRevenueServiceOnRoute(agencyId, stopId, routeId, directionId);
    }

    public Boolean stopHasRevenueService(String agencyId, String stopId) {
        return this._transitDataService.stopHasRevenueService(agencyId, stopId);
    }

    public List<StopBean> getAllRevenueStops(AgencyWithCoverageBean agency) {
        return this._transitDataService.getAllRevenueStops(agency);
    }

    public ListBean<ConsolidatedStopMapBean> getAllConsolidatedStops() {
        return this._transitDataService.getAllConsolidatedStops();
    }

    public ServiceAlertBean copyServiceAlert(String agencyId, ServiceAlertBean situation) {
        return this._transitDataService.copyServiceAlert(agencyId, situation);
    }
}

