/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.federated;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.onebusaway.exceptions.NoSuchStopServiceException;
import org.onebusaway.exceptions.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TransitDataServiceExceptionInterceptor {
    private final Logger _log = LoggerFactory.getLogger(TransitDataServiceExceptionInterceptor.class);

    @Around(value="execution(* org.onebusaway.transit_data_federation.impl.federated.TransitDataServiceImpl.*(..))")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) throws Throwable {
        try {
            return pjp.proceed();
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (!(ex instanceof NoSuchStopServiceException) && !(ex instanceof IllegalStateException)) {
                this._log.error("error executing TransitDataService method", (Object)(ex.getClass().getName() + ":" + ex.getMessage()));
                if (this._log.isDebugEnabled()) {
                    this._log.debug("detailed message", ex);
                }
            }
            throw new ServiceException(ex);
        }
    }
}

