/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.onebusaway.container.refresh.Refreshable;
import org.onebusaway.transit_data.model.config.BundleMetadata;
import org.onebusaway.transit_data_federation.services.FederatedTransitDataBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BundleConfigDao {
    private static Logger _log = LoggerFactory.getLogger(BundleConfigDao.class);
    private FederatedTransitDataBundle _bundle;
    private BundleMetadata _meta;

    @Autowired
    public void setBundle(FederatedTransitDataBundle bundle) {
        this._bundle = bundle;
    }

    public BundleMetadata getBundleMetadata() {
        return this._meta;
    }

    @PostConstruct
    @Refreshable(dependsOn={"transitGraph"})
    public void setup() throws IOException, ClassNotFoundException {
        this._meta = null;
        File path = this._bundle.getBundleMetadataPath();
        _log.info("looking for metadata file " + path);
        if (path.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            BundleMetadata meta = null;
            try {
                meta = (BundleMetadata)mapper.readValue(path, BundleMetadata.class);
            }
            catch (Exception any) {
                _log.error("reading metadata failed:", (Throwable)any);
            }
            if (meta != null) {
                this._meta = meta;
            }
        } else {
            _log.error(" did not find metadata file " + path);
        }
    }
}

