/*
 * Decompiled with CFR 0.152.
 */
package org.onebusaway.transit_data_federation.impl.bundle;

import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.onebusaway.cloud.api.ExternalServices;
import org.onebusaway.cloud.api.ExternalServicesBridgeFactory;
import org.onebusaway.cloud.api.InputStreamConsumer;
import org.onebusaway.transit_data_federation.impl.bundle.AbstractBundleStoreImpl;
import org.onebusaway.transit_data_federation.model.bundle.BundleItem;
import org.onebusaway.transit_data_federation.services.bundle.BundleStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BundleStoreImpl
extends AbstractBundleStoreImpl
implements BundleStoreService {
    private static Logger _log = LoggerFactory.getLogger(S3BundleStoreImpl.class);
    private String latestBundleURI = null;
    private String remoteIndexURI = null;
    private boolean initialized = false;
    private final Map<Date, S3BundleItem> _bundleFolderByDate = new HashedMap();
    private final Map<Date, S3BundleItem> _bundleFileByDate = new HashedMap();

    public void setLatestBundleURI(String s) {
        this.latestBundleURI = s;
    }

    public S3BundleStoreImpl(String bundleRootPath, String remoteSourceURI) {
        super(bundleRootPath);
        this.remoteIndexURI = remoteSourceURI;
    }

    @Override
    public List<BundleItem> getBundles() throws Exception {
        if (!this.initialized) {
            this.loadInitial();
            this.initialized = true;
        }
        if (this.isFile(this.remoteIndexURI)) {
            String indexFile = this.remoteIndexURI.replaceFirst("file:", "");
            _log.info("looking for index file on disk at " + indexFile);
            String latest = this.parseConfigFromStream(new FileInputStream(indexFile));
            if (latest != null) {
                this.setLatestBundleURI(latest);
            }
        } else {
            ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
            String s3IndexFile = this.remoteIndexURI;
            es.getFileAsStream(s3IndexFile, new InputStreamConsumer(){

                public void accept(InputStream inputStream) throws IOException {
                    String latest = S3BundleStoreImpl.this.parseConfigFromStream(inputStream);
                    if (latest != null) {
                        S3BundleStoreImpl.this.setLatestBundleURI(latest);
                    }
                }
            }, this.getProfile(), this.getRegion());
        }
        if (this.latestBundleURI == null) {
            throw new RuntimeException("no index file found at " + this.remoteIndexURI);
        }
        final String bundleRoot = this._bundleRootPath;
        String[] bundleNameParts = this.latestBundleURI.split("/");
        String bundleTarName = bundleNameParts[bundleNameParts.length - 1];
        final String bundleName = bundleTarName.replace(".tar.gz", "");
        S3BundleItem fileItem = new S3BundleItem(bundleTarName, bundleRoot);
        S3BundleItem folderItem = new S3BundleItem(bundleName, bundleRoot);
        if (this.bundleExists(bundleName)) {
            _log.info("bundle {} exists on disk, skipping download", (Object)bundleName);
            this.prune();
        } else if (this.latestBundleURI != null) {
            if (this.isFile(this.latestBundleURI)) {
                String bundleFile = this.latestBundleURI.replaceFirst("file:", "");
                _log.info("loading bundle file on disk at " + bundleFile);
                this.extractBundleFromInput(new FileInputStream(bundleFile), bundleRoot, bundleName);
                this._bundleFileByDate.put(new Date(), fileItem);
                this._bundleFolderByDate.put(new Date(), folderItem);
            } else {
                ExternalServices es = new ExternalServicesBridgeFactory().getExternalServices();
                es.getFileAsStream(this.latestBundleURI, new InputStreamConsumer(){

                    public void accept(InputStream inputStream) throws IOException {
                        FileOutputStream fileStream = S3BundleStoreImpl.this.extractBundleFromInput(inputStream, bundleRoot, bundleName);
                    }
                }, this.getProfile(), this.getRegion());
                this._bundleFileByDate.put(new Date(), fileItem);
                this._bundleFolderByDate.put(new Date(), folderItem);
            }
        }
        File possibleBundle = new File(bundleRoot, bundleName);
        if (!possibleBundle.exists()) {
            throw new RuntimeException("expected dir to exist: " + possibleBundle);
        }
        File dataDir = new File(possibleBundle + File.separator + "data");
        if (dataDir.exists() && dataDir.isDirectory()) {
            _log.info("found unpacked bundle with data directory, re-organizing to be flat");
            try {
                this.moveBundleContents(dataDir, possibleBundle);
            }
            catch (Throwable t) {
                _log.error("organizing bundle failed:", t);
            }
        } else {
            _log.info("possibleBundle looks unpacked at {}, about to check contents", (Object)dataDir);
        }
        File calendarServiceObjectFile = new File(possibleBundle, "CalendarServiceData.obj");
        if (!calendarServiceObjectFile.exists()) {
            throw new RuntimeException("expected file " + calendarServiceObjectFile);
        }
        File metadataFile = new File(possibleBundle, "metadata.json");
        if (!metadataFile.exists()) {
            throw new RuntimeException("expected file " + metadataFile);
        }
        _log.info("bundle looking hopeful at {}", (Object)possibleBundle);
        ArrayList<BundleItem> bundleItems = new ArrayList<BundleItem>();
        BundleItem validLocalBundle = this.createBundleItem(calendarServiceObjectFile, metadataFile, bundleName);
        bundleItems.add(validLocalBundle);
        _log.info("created bundleItems for local bundle {}", (Object)possibleBundle);
        return bundleItems;
    }

    private void loadInitial() {
        String[] bundleDirectories;
        for (String bundleDirectory : bundleDirectories = new File(this._bundleRootPath).list()) {
            File possibleDirectory = new File(this._bundleRootPath, bundleDirectory);
            if (possibleDirectory.isDirectory()) {
                this._bundleFolderByDate.put(this.parseDateFromFolderName(bundleDirectory), new S3BundleItem(bundleDirectory, this._bundleRootPath));
                continue;
            }
            if (possibleDirectory.isFile() && bundleDirectory.endsWith(".tar.gz")) {
                this._bundleFileByDate.put(this.parseDateFromFileName(bundleDirectory), new S3BundleItem(bundleDirectory, this._bundleRootPath));
                continue;
            }
            _log.error("unexpected sub directory {}", (Object)bundleDirectory);
        }
    }

    private Date parseDateFromFileName(String bundleFile) {
        if (bundleFile.startsWith("v.")) {
            try {
                String millisStr = bundleFile.substring("v.".length(), bundleFile.length() - ".tar.gz".length());
                long millis = Long.parseLong(millisStr);
                return new Date(millis);
            }
            catch (Exception any) {
                _log.error("unexpected bundle file {}", (Object)bundleFile);
            }
        }
        return new Date();
    }

    private Date parseDateFromFolderName(String bundleDirectory) {
        if (bundleDirectory.startsWith("v.")) {
            try {
                String millisStr = bundleDirectory.substring("v.".length(), bundleDirectory.length());
                long millis = Long.parseLong(millisStr);
                return new Date(millis);
            }
            catch (Exception any) {
                _log.error("unexpected bundle directory {}", (Object)bundleDirectory);
                return new Date();
            }
        }
        return new Date();
    }

    private boolean isFile(String remoteIndexURI) {
        if (remoteIndexURI == null) {
            return false;
        }
        return remoteIndexURI.startsWith("/") || remoteIndexURI.startsWith("file:///");
    }

    private FileOutputStream extractBundleFromInput(InputStream inputStream, String bundleRoot, String bundleName) throws IOException {
        String bundleLocation = bundleRoot + File.separator + bundleName;
        new File(bundleLocation).mkdirs();
        File bundleFile = new File(bundleLocation + ".tar.gz");
        bundleFile.createNewFile();
        _log.info("copying bundle to {}", (Object)bundleFile);
        FileOutputStream fileStream = new FileOutputStream(bundleFile);
        IOUtils.copy((InputStream)inputStream, (OutputStream)fileStream);
        _log.info("new bundle at {}", (Object)bundleLocation);
        Process exec = Runtime.getRuntime().exec("tar zxvf " + bundleFile + " -C " + bundleRoot);
        try {
            int n = exec.waitFor();
        }
        catch (InterruptedException e) {
            return null;
        }
        return fileStream;
    }

    private String parseConfigFromStream(InputStream inputStream) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        if (inputStream == null) {
            _log.error("no content for index {}", (Object)this.remoteIndexURI);
            return null;
        }
        JsonParser parser = mapper.createParser(inputStream);
        TreeNode treeNode = parser.readValueAsTree();
        TreeNode latestNode = treeNode.get("latest");
        if (latestNode == null || !latestNode.isValueNode()) {
            _log.error("unexpected format for index {}, {}", (Object)this.remoteIndexURI, (Object)parser.getValueAsString());
            return null;
        }
        String latest = latestNode.toString();
        if (latest != null && latest.indexOf("\"") != -1) {
            latest = latest.replace("\"", "");
        }
        if (StringUtils.isBlank((String)latest)) {
            _log.error("no value retrieved for key latest at {}", (Object)this.remoteIndexURI);
            return null;
        }
        _log.info("found latest bundle at {}", (Object)latest);
        return latest;
    }

    private boolean bundleExists(String bundleName) {
        File bundleCheck = new File(this._bundleRootPath + File.separator + bundleName);
        _log.info("checking on bundle {}", (Object)bundleCheck.toString());
        return bundleCheck.exists() && bundleCheck.isDirectory();
    }

    private void moveBundleContents(File srcDir, File destDir) throws IOException {
        _log.info("examining srcDir = {}", (Object)srcDir);
        boolean found = false;
        for (String file : srcDir.list()) {
            found = true;
            String dataFileName = srcDir + File.separator + file;
            File dataFile = new File(dataFileName);
            if (dataFile.exists() && dataFile.isFile()) {
                File destFile = new File(destDir + File.separator + file);
                _log.info("copying data bundle item {} to {}", (Object)dataFile, (Object)destFile);
                Files.move(Paths.get(dataFile.getPath(), new String[0]), Paths.get(destFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                continue;
            }
            _log.info("skipping copy of {}", (Object)dataFile);
        }
        if (!found) {
            throw new RuntimeException("no files found for " + srcDir);
        }
    }

    private String getRegion() {
        String specifiedRegion = System.getProperty("oba.cloud.region");
        if (specifiedRegion != null) {
            return specifiedRegion;
        }
        return "us-east-1";
    }

    private String getProfile() {
        String specifiedProfile = System.getProperty("oba.cloud.profile");
        if (specifiedProfile != null) {
            return specifiedProfile;
        }
        return "default";
    }

    @Override
    public boolean isLegacyBundle() {
        return false;
    }

    public void prune() {
        S3BundleItem s3BundleItem;
        ArrayList<Date> ages;
        if (this._bundleFolderByDate.size() > 3) {
            ages = new ArrayList<Date>(this._bundleFolderByDate.keySet());
            Collections.sort(ages);
            for (int i = 0; i < 3; ++i) {
                ages.remove(ages.size() - 1);
            }
            for (Date age : ages) {
                s3BundleItem = this._bundleFolderByDate.get(age);
                _log.info("deleting bundle directory {} dated {}", (Object)s3BundleItem.bundleName, (Object)age);
                this.deleteFolder(new File(s3BundleItem.bundleRoot, s3BundleItem.bundleName));
                this._bundleFolderByDate.remove(age);
            }
        }
        if (this._bundleFileByDate.size() > 3) {
            ages = new ArrayList<Date>(this._bundleFileByDate.keySet());
            Collections.sort(ages);
            for (int i = 0; i < 3; ++i) {
                ages.remove(ages.size() - 1);
            }
            for (Date age : ages) {
                s3BundleItem = this._bundleFileByDate.get(age);
                _log.info("deleting bundle file {} dated {}", (Object)s3BundleItem.bundleName, (Object)age);
                this.deleteFile(new File(s3BundleItem.bundleRoot, s3BundleItem.bundleName));
                this._bundleFileByDate.remove(age);
            }
        }
    }

    private void deleteFile(File file) {
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFolder(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class S3BundleItem {
        private final String bundleName;
        private final String bundleRoot;

        public S3BundleItem(String bundleName, String bundleRoot) {
            this.bundleName = bundleName;
            this.bundleRoot = bundleRoot;
        }
    }
}

